package com.elitesland.yst.production.aftersale.model.param;

import com.elitesland.yst.production.aftersale.model.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * B端客诉设置;
 * @author : siyufeng
 * @date : 2024-7-3
 */
@Data
@ApiModel(description = "B端客诉设置")
public class BusinessComplaintSetParam extends BaseModelParam {
    @ApiModelProperty("分类编码")
    private String classifyCode;

    @ApiModelProperty("分类名称")
    private String classifyName;

    @ApiModelProperty("最大响应时间")
    private String maxResp;

    @ApiModelProperty("最大处理时间")
    private String maxHandle;

    @ApiModelProperty("客诉类型(1:C端投诉, 2:B端投诉, 3:基本设置）")
    private String complaintType = "2";

    @ApiModelProperty("问题描述")
    private String issueDesc;

    @ApiModelProperty("序号")
    private Integer sortNo;

    @ApiModelProperty("上级id")
    private Long pid;

}