package com.elitesland.yst.production.aftersale.model.param;

import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleSaveVO
 * @Date2023/2/8 14:36
 */
@Data
@ApiModel(description = "车主车辆信息信息保存数据参数")
public class CarOwnerVehicleParam extends BaseModelVO implements Serializable {



    @ApiModelProperty(value = "车主账号")
    private Long carOwnerId;

    @ApiModelProperty(value = "车主姓名")
    private String userName;

    @ApiModelProperty(value = "车主手机号")
    @NotBlank(message = "车主手机号不能为空")
    private String userPhone;

    @ApiModelProperty("车主身份证号")
    private String userIdCard;

    @ApiModelProperty("车主性别")
    private String userSex;

    @ApiModelProperty("车主地区")
    private String userArea;

    @ApiModelProperty("车主生日")
    private LocalDate userBirthday;

    @ApiModelProperty("购买金额")
    private BigDecimal vehicleBuyPrice;


    @ApiModelProperty(value = "车辆来源 1-立马 0-非立马")
    private Integer vehicleSource;

    @ApiModelProperty(value = "绑定时间")
    private String bindingTime;

    @ApiModelProperty(value = "电池编号")
    private String batteryNum;

    @ApiModelProperty(value = "销售门店名称")
    private String salesOutletsName;

    @ApiModelProperty(value = "销售门店编码")
    private String salesOutletsCode;

    @ApiModelProperty("销售门店业务区域")
    private String salesOutletsRegion;

    @ApiModelProperty("销售门店区域经理")
    private String regionalManager;

    @ApiModelProperty("销售门店省区经理")
    private String provincialManager;

    @ApiModelProperty("销售总监")
    private String salesDirector;


    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    @ApiModelProperty(value = "三包卡号")
    private String maintainCardNo;

    @ApiModelProperty(value = "活动编号")
    private String activityNum;

    @ApiModelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("整车类型")
    private String itemType3;

    @ApiModelProperty("车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty("车辆车型")
    private String vehicleModel;

    @ApiModelProperty("车辆颜色")
    private String vehicleColor;

    @ApiModelProperty("电机号")
    private String machineNo;

    @ApiModelProperty("控制器号")
    private String controlNo;

    @ApiModelProperty("报警器号")
    private String alarmNo;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("生产日期")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("销售门店ID")
    private Long salesOutletsId;

    @ApiModelProperty("库存物料(商品编码)")
    private String invMatter;

    @ApiModelProperty("整车序列号")
    private String vehicleSeq;

    @ApiModelProperty("E智行号")
    private String eNo;

    @ApiModelProperty("来源系统类型")
    private String sourceSysType;

    @ApiModelProperty("生产订单号")
    private String produceOrderNo;

    @ApiModelProperty("下线日期")
    private LocalDateTime offlineDate;


    @ApiModelProperty("激活标志")
    private Boolean activatFlag;





    @ApiModelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("购买日期")
    private LocalDate purchaseTime;


    @ApiModelProperty(value = "车架号集合")
    private List<String> vehicles;

    @ApiModelProperty(value = "生产日期")
    private LocalDate productionDate;


    private String sourcePlatform;


    @ApiModelProperty("激活日期")
    private LocalDateTime activatTime;

    @ApiModelProperty("车型")
    private String spuCode;

    @ApiModelProperty("标配")
    private String itemGroup2;

    @ApiModelProperty("上传图片集合")
    List<PictureOrderParam> pictureOrderParamList;


    @ApiModelProperty("区域")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty("省份")
    private String province;
    private String provinceName;

    @ApiModelProperty("经销商编码")
    private String custCode;
    private String custCode2;

    @ApiModelProperty("电池编码")
    private List<String> batteryCodes;

    @ApiModelProperty("电充编码")
    private List<String> chargerCodes;

    @ApiModelProperty("车型")
    private String spuName;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty(name = "库存物料(商品编码)")
    private String mtnrv;

    @ApiModelProperty(name="门店名称")
    private String storeCode2;
}

