package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderEvaluationParam extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("评价级别(1：满意，2：不满意)")
    private String evaluationLevel;

    @ApiModelProperty("评语")
    private String evaluationContent;

    @ApiModelProperty("工单id")
    private Long orderId;

    @ApiModelProperty("工单类型(1：维修工单，2：客诉工单)")
    private String orderType;

    @ApiModelProperty("回访满意度")
    private String returnLevel;

    @ApiModelProperty("改善意见")
    private String returnAdvice;

    @ApiModelProperty("处理回复")
    private String returnReply;

    @ApiModelProperty("上传图片集合")
    List<PictureOrderParam> pictureOrderParamList;

    @ApiModelProperty("工单id")
    private List<Long> orderIdList;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof OrderEvaluationParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
