package com.elitesland.yst.production.aftersale.model.vo;

import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;


@EqualsAndHashCode(callSuper = true)
@Data
public class CarVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("车架号")
    String vehicleNo;

    @ApiModelProperty("车辆名称")
    String vehicleName;

    @ApiModelProperty("车辆规格")
    String vehicleSpecs;

    @ApiModelProperty("车辆类型")
    String vehicleType;

    @ApiModelProperty("整车类型")
    String itemType3;

    @ApiModelProperty("车辆车型")
    String vehicleModel;

    @ApiModelProperty("车辆来源")
    String vehicleSource;

    @ApiModelProperty("车辆颜色")
    String vehicleColor;

    @ApiModelProperty("电机号")
    String machineNo;

    @ApiModelProperty("控制器号")
    String controlNo;

    @ApiModelProperty("报警器号")
    String alarmNo;

    @ApiModelProperty("商品ID")
    Long itemId;

    @ApiModelProperty("生产日期")
    LocalDateTime manufactureDate;

    @ApiModelProperty("绑定时间")
    LocalDateTime bindingTime;

    @ApiModelProperty("购买日期")
    LocalDateTime purchaseTime;

    @ApiModelProperty("出库日期")
    LocalDateTime docTime;

    @ApiModelProperty("激活绑定日期")
    LocalDateTime bindActiveTime;

    @ApiModelProperty("三包卡号")
    String maintainCardNo;

    @ApiModelProperty("销售门店ID")
    Long salesOutletsId;

    @ApiModelProperty("库存物料(商品编码)")
    String invMatter;

    @ApiModelProperty(name = "库存物料(商品编码)")
    String mtnrv;

    @ApiModelProperty("整车序列号")
    String vehicleSeq;

    @ApiModelProperty("E智行号")
    String eNo;

    @ApiModelProperty("来源系统类型")
    String sourceSysType;

    @ApiModelProperty("生产订单号")
    String produceOrderNo;

    @ApiModelProperty("下线日期")
    LocalDateTime offlineDate;

    @ApiModelProperty("车型")
    String spuCode;

    @ApiModelProperty("标配")
    String itemGroup2;

    @ApiModelProperty("电池数量")
    Integer batteryNum;

    @ApiModelProperty("关联整车SPU")
    String spuName;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof CarVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
