package com.elitesland.yst.production.aftersale.model.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class RepairPartsServiceVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("配件id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long partsId;

    @ApiModelProperty("所属维修工单id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long repairId;

    @ApiModelProperty("配件名称")
    @SysCode(sys = "yst-after-sale", mod = "SERVICE_ITEM")
    String partsName;
    String partsNameName;

    @ApiModelProperty("配件分类")
    String partsType;

    @ApiModelProperty("配件售价")
    BigDecimal partsPrice;

    @ApiModelProperty("服务价格")
    BigDecimal servicePrice;

    @ApiModelProperty("服务类型（修件0/换件1/增值服务2）")
    @SysCode(sys = "yst-after-sale", mod = "PARTS_SERVICE")
    String serviceType;
    String serviceTypeName;

    @ApiModelProperty("配件数量")
    Integer partsNum;

    @ApiModelProperty("三包类型（保内0/保外1）")
    String isThreePackage;

    @ApiModelProperty("故障类型id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long breakdownMaintenanceId;

    @ApiModelProperty("故障类型名称")
    private String breakdownMaintenanceName;

    @ApiModelProperty("上传图片集合")
    List<PictureOrderVO> pictureOrderVOList;







    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairPartsServiceVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
