package com.elitesland.yst.production.aftersale.search.bean;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.SearchBean;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "中台管理端客诉工单")
@SearchBean(tables = "complaint_order co LEFT JOIN " +
        "( SELECT * FROM car_owner_vehicle_info WHERE vehicle_no IS NOT NULL AND vehicle_no <> '' and delete_flag = 0) cov " +
        "ON cov.vehicle_no = co.vehicle_no ",
        where = "co.delete_flag = 0 ",
        autoMapTo = "co")
public class ComplaintOrderSearchBean extends BasicsBean implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("工单单号")
    @ExcelProperty("售后工单号")
    private String orderNo;

    @ApiModelProperty("客诉类型")
    @SysCode(sys = "yst-after-sale", mod = "COMPLAINT_TYPE")
    private Integer orderType;

    @ApiModelProperty("联系人")
    @ExcelProperty("客户名称")
    private String orderPerson;

    @ApiModelProperty("所属经销商名称")
    @ExcelProperty("所属经销商")
    private String custName;


    @ApiModelProperty("联系电话")
    @ExcelProperty("联系电话")
    private String orderTel;

    @ApiModelProperty("问题类型id")
    private String issueType;

    @ApiModelProperty("车型")
    @ExcelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("车架号")
    @ExcelProperty("车架号")
    @DbField("co.vehicle_no")
    private String vehicleNo;

    @CreatedDate
    @ExcelProperty("提交时间")
    private LocalDateTime createTime;

    @ApiModelProperty("问题描述")
    @ExcelProperty("问题描述")
    private String issueDescription;

    @ApiModelProperty("备注")
    @ExcelProperty("备注")
    private String remark;

    @ApiModelProperty("确认分类")
    private String confirmType;

    @ApiModelProperty("处理状态")
    @SysCode(sys = "yst-after-sale", mod = "COMPLAINT_ORDER")
    private String orderStatus;


    @ApiModelProperty("时效状态")
    @SysCode(sys = "yst-after-sale", mod = "TIMEOUT_STATUS")
    private String timeoutStatus;

    @ApiModelProperty("车主id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long carOwnerId;

    @LastModifiedDate
    private LocalDateTime modifyTime;

    @ApiModelProperty("处理人id")
    private Long handlePersonId;

    @ApiModelProperty("处理人姓名")
    private String handlePersonName;

    @ApiModelProperty("处理人电话")
    private String handlePersonTel;

    @ApiModelProperty("处理回复")
    private String handleReply;

    @ApiModelProperty("C端取消原因udc")
    @SysCode(sys = "yst-after-sale", mod = "CANCEL_REASON_C")
    private String cancelReasonC;

    @ApiModelProperty("B端取消原因udc")
    @SysCode(sys = "yst-after-sale", mod = "CANCEL_REASON_B")
    private String cancelReasonB;

    @ApiModelProperty("取消原因明细")
    private String cancelDetail;

    @ApiModelProperty("基地")
    private String baseNo;

    @ApiModelProperty("问题补充")
    private String issueSupplement;

    @ApiModelProperty("细分分类")
    private String subdivisionType;

    @ApiModelProperty("派单人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long dispatchPersonId;

    @ApiModelProperty("派单时间")
    private LocalDateTime dispatchTime;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("绑定时间")
    @DbField("cov.binding_time")
    private LocalDateTime bindingTime;

    @ApiModelProperty("激活时间")
    @DbField("cov.activat_time")
    private LocalDateTime activatTime;
    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof PictureOrderVO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
