package com.elitesland.yst.production.aftersale.search.service.impl;

import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.yst.production.aftersale.convert.ComplaintOrderConvert;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.search.bean.ComplaintOrderAndOrderEvaluationSearchBean;
import com.elitesland.yst.production.aftersale.search.bean.ComplaintOrderSearchBean;
import com.elitesland.yst.production.aftersale.search.service.ComplaintOrderSearchBeanService;
import com.elitesland.yst.production.aftersale.search.service.SearchBeanService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepoProc;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.order.rpc.LmVehicleNoRpcService;
import com.elitesland.yst.production.order.rpc.param.LmAfterSaleTimeParam;
import com.elitesland.yst.production.order.rpc.param.resp.LmVehicleNoTimeDTO;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author RYH
 * @date 2023/2/14
 */
@Service
@Log4j2
@RequiredArgsConstructor
public class ComplaintOrderSearchBeanServiceImpl implements ComplaintOrderSearchBeanService {

    private final SearchBeanService searchBeanService;

    @Autowired
    private PictureOrderService pictureOrderService;

    @Autowired
    private SystemService systemService;

    @Autowired
    private OrderEvaluationService orderEvaluationService;

    @Autowired
    private UserService userService;

    @Autowired
    private ComplaintSetRepoProc complaintSetRepoProc;

    @Autowired
    private LmVehicleNoRpcService vehicleNoRpcService;

    @Value("${file.upload.url}")
    private String pictureURL;

    private static final String SYSTEM_ROLE_CODE = "ROLE_admin";

    private final JdbcTemplate jdbcTemplate;

    @Override
    public PagingVO<ComplaintOrderVO> query(ComplaintOrderPageParam param) {
        Long userId = userService.getUserId();
        /*if("PC".equals(param.getSource())){
            param.setCarOwnerId(null);
            if(!userService.getUserDetail().getRoleCodes().contains(SYSTEM_ROLE_CODE)){
                param.setHandlePersonId(userId);
            }
        }else {
            param.setCarOwnerId(userId);
        }*/

        PagingVO<ComplaintOrderVO> complaintOrderVOS = null;
        //查询客诉工单信息
        if (UdcEnum.COMPLAINT_ORDER_KSS005.getValueCode().equals(param.getOrderStatus())) {
            param.setOrderStatus(UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
            complaintOrderVOS = this.unEvaluationQuery(param);
        } else {
            complaintOrderVOS = this.evaluationQuery(param);
        }

        //填充生产时间，车辆编码，出库时间
        this.docTimeQuery(complaintOrderVOS, param);

        //填充图片
        this.pictureQuery(complaintOrderVOS.getRecords());

        //填充评论
        this.evaluationQuery(complaintOrderVOS.getRecords());

        //填充问题类别
        this.setQueryAll(complaintOrderVOS.getRecords());

        //UCD手动翻译
        this.udcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    @Override
    public PagingVO<ComplaintOrderVO> export(ComplaintOrderExlParam complaintOrderExlParam) {
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setOrderType(complaintOrderExlParam.getOrderType());
        complaintOrderPageParam.setIdList(complaintOrderExlParam.getIdList());
        complaintOrderPageParam.setOrderNo(complaintOrderExlParam.getOrderNo());
        complaintOrderPageParam.setOrderStatus(complaintOrderExlParam.getOrderStatus());
        complaintOrderPageParam.setOrderTel(complaintOrderExlParam.getOrderTel());
        complaintOrderPageParam.setOrderPerson(complaintOrderExlParam.getOrderPerson());
        complaintOrderPageParam.setIssueType(complaintOrderExlParam.getIssueType());
        complaintOrderPageParam.setStartTime(complaintOrderExlParam.getStartTime());
        complaintOrderPageParam.setEndTime(complaintOrderExlParam.getEndTime());
        complaintOrderPageParam.setCurrent(complaintOrderExlParam.getCurrent() + 1);
        complaintOrderPageParam.setSize(complaintOrderExlParam.getSize());
        complaintOrderPageParam.setOrders(complaintOrderExlParam.getOrders());
        PagingVO<ComplaintOrderVO> complaintOrderVOS = this.exportQuery(complaintOrderPageParam);

        //问题类型翻译
        this.setQuery(complaintOrderVOS.getRecords());

        complaintOrderVOS.getRecords().forEach(x -> {
            if (StringUtils.isNotEmpty(x.getEvaluationLevel())) {
                x.setEvaluationStatus("已评价");
            } else {
                x.setEvaluationStatus("待评价");
            }

            x.setFeedbackPerson(x.getOrderPerson());

            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(x.getOrderType())) {
                x.setSource("车主");
            }

            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(x.getOrderType())) {
                x.setSource("经销商");
            }
        });

        //UCD手动翻译
        this.udcTranslate(complaintOrderVOS.getRecords());
        //评价UCD手动翻译
        this.evaluationUdcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    private PagingVO<ComplaintOrderVO> exportQuery(ComplaintOrderPageParam param) {
        var whereSqlMapBuilder = this.setMapBuilder(param);
        this.setParamsOrderBy(param.getOrders(), whereSqlMapBuilder);
        SearchResult<ComplaintOrderAndOrderEvaluationSearchBean> searchResult = searchBeanService.getBeanSearcher().search(ComplaintOrderAndOrderEvaluationSearchBean.class, whereSqlMapBuilder.build());
        PagingVO<ComplaintOrderVO> complaintOrderVOPagingVO = new PagingVO<ComplaintOrderVO>();
        complaintOrderVOPagingVO.setRecords(searchResult.getDataList().stream().map(ComplaintOrderConvert.INSTANCE::searchBeanToRespVO).collect(Collectors.toList()));
        complaintOrderVOPagingVO.setTotal(searchResult.getTotalCount().longValue());
        return complaintOrderVOPagingVO;
    }

    /**
     * 评论UDC翻译
     *
     * @param complaintOrderVO
     */
    public void evaluationUdcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_LEVEL_1.getModel(), UdcEnum.EVALUATION_LEVEL_1.getCode());
        Map<String, String> ajStatusMap2 = systemService.sysUdcGetCodeMap(UdcEnum.RETURN_LEVEL_1.getModel(), UdcEnum.RETURN_LEVEL_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(t.getEvaluationLevel())) {
                t.setEvaluationLevelName(ajStatusMap.get(t.getEvaluationLevel()));
            }

            if (!CollectionUtils.isEmpty(ajStatusMap2) && ajStatusMap2.containsKey(t.getEvaluationLevel())) {
                t.setReturnLevelName(ajStatusMap2.get(t.getReturnLevel()));
            }
        });

    }

    @Override
    public PagingVO<ComplaintOrderVO> unEvaluationQuery(ComplaintOrderPageParam param) {
        var whereSqlMapBuilder = this.setMapBuilder(param);
        whereSqlMapBuilder.field(ComplaintOrderAndOrderEvaluationSearchBean::getId).op(FieldOps.IsNull);
        this.setParamsOrderBy(param.getOrders(), whereSqlMapBuilder);
        SearchResult<ComplaintOrderAndOrderEvaluationSearchBean> searchResult = searchBeanService.getBeanSearcher().search(ComplaintOrderAndOrderEvaluationSearchBean.class, whereSqlMapBuilder.build());
        PagingVO<ComplaintOrderVO> complaintOrderVOPagingVO = new PagingVO<ComplaintOrderVO>();
        complaintOrderVOPagingVO.setRecords(searchResult.getDataList().stream().map(ComplaintOrderConvert.INSTANCE::searchBeanToRespVO).collect(Collectors.toList()));
        complaintOrderVOPagingVO.setTotal(searchResult.getTotalCount().longValue());
        return complaintOrderVOPagingVO;
    }

    @Override
    public PagingVO<ComplaintOrderVO> evaluationQuery(ComplaintOrderPageParam param) {

        var whereSqlMapBuilder = this.setMapBuilder(param);
        this.setParamsOrderBy(param.getOrders(), whereSqlMapBuilder);
        SearchResult<ComplaintOrderSearchBean> searchResult = searchBeanService.getBeanSearcher().search(ComplaintOrderSearchBean.class, whereSqlMapBuilder.build());
        PagingVO<ComplaintOrderVO> complaintOrderVOPagingVO = new PagingVO<ComplaintOrderVO>();
        complaintOrderVOPagingVO.setRecords(searchResult.getDataList().stream().map(ComplaintOrderConvert.INSTANCE::searchBeanToRespVO).collect(Collectors.toList()));
        complaintOrderVOPagingVO.setTotal(searchResult.getTotalCount().longValue());
        return complaintOrderVOPagingVO;
    }

    public PagingVO<ComplaintOrderVO> docTimeQuery(PagingVO<ComplaintOrderVO> complaintOrderVOS, ComplaintOrderPageParam param) {
        List<String> vehicles = complaintOrderVOS.stream()
                .map(ComplaintOrderVO::getVehicleNo)
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.toList());

        if (vehicles.isEmpty()) {
            return complaintOrderVOS;
        }

        Map<String, LmVehicleNoTimeDTO> vehicleInfoMap = new HashMap<>();
        LmAfterSaleTimeParam lmAfterSaleTimeParam = new LmAfterSaleTimeParam();
        lmAfterSaleTimeParam.setVehicles(vehicles);

        ApiResult<List<LmVehicleNoTimeDTO>> docTimeByListVehicles = vehicleNoRpcService.getDocTimeByListVehicles(lmAfterSaleTimeParam);
        if (docTimeByListVehicles != null) {
            List<LmVehicleNoTimeDTO> dtos = docTimeByListVehicles.getData();
            if (dtos != null) {
                for (LmVehicleNoTimeDTO dto : dtos) {
                    vehicleInfoMap.put(dto.getVehicleNo(), dto);
                }
            }
        }

        complaintOrderVOS.getRecords().forEach(x -> {
            String vehicleNo = x.getVehicleNo();
            LmVehicleNoTimeDTO vehicleNoInfo = vehicleInfoMap.get(vehicleNo);
            if (vehicleNoInfo != null) {
                x.setDocTime(vehicleNoInfo.getDocTime());
                x.setManufactureDate(vehicleNoInfo.getOfflineTime());
                x.setItemCode(vehicleNoInfo.getItemCode());
            }
        });

        return complaintOrderVOS;
    }

    public void pictureQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(ComplaintOrderVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(collect);
//        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
        List<PictureOrderVO> data = pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(pictureURL + pictureOrderVO.getUrl());
        }
        //对应图片信息赋值
        complaintOrderVOS.stream().forEach(t -> {
            List<PictureOrderVO> respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
            t.setPictureOrderVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
            t.setCompletePictureVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
        });
    }

    public void evaluationQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0).map(ComplaintOrderVO::getId).collect(Collectors.toList());
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderIdList(collect);
        orderEvaluationParam.setOrderType(UdcEnum.EVALUATION_ORDER_TYPE_2.getValueCode());
        List<OrderEvaluationVO> data = orderEvaluationService.queryList(orderEvaluationParam);
        //对应图片信息赋值
        complaintOrderVOS.forEach(t -> {
            List<OrderEvaluationVO> evaluationVOList = data.stream().filter(item -> item.getOrderId().equals(t.getId())).collect(Collectors.toList());
            if (!evaluationVOList.isEmpty()) {
                t.setOrderEvaluationVO(evaluationVOList.get(0));
            }
        });
    }

    public void setQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        if (complaintOrderVOS.isEmpty()) {
            return;
        }
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        List<ComplaintSetVO> complaintSetVOS = complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);

        //对应问题类型赋值
        complaintOrderVOS.forEach(t -> {
            complaintSetVOS.forEach(set -> {
                if (t.getIssueType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                    if (String.valueOf(set.getId()).equals(t.getIssueType()) && set.getComplaintType().equals(t.getOrderType())) {
                        List<ComplaintSetVO> complaintOrders = getAllItems(complaintSetVOS, set.getId());
                        t.setIssueTypeName(getAllClassifyName(complaintOrders));
                    }
                }
                if (t.getConfirmType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                    if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("2")) {
                        List<ComplaintSetVO> complaintOrders = getAllItems(complaintSetVOS, set.getId());
                        t.setConfirmTypeName(getAllClassifyName(complaintOrders));
                    }else if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("1")){
                        t.setConfirmTypeName(set.getClassifyName());
                    }
                }
            });
        });
    }

    public void setQueryAll(List<ComplaintOrderVO> complaintOrderVOS) {
        if (complaintOrderVOS.isEmpty()) {
            return;
        }
        String sql = "SELECT * FROM complaint_set";
        List<ComplaintSetVO> complaintSetVOS = jdbcTemplate.query(sql, new BeanPropertyRowMapper<>(ComplaintSetVO.class));
        // 对应问题类型赋值
        complaintOrderVOS.forEach(t -> {
            complaintSetVOS.forEach(set -> {
                if (t.getIssueType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                    if (String.valueOf(set.getId()).equals(t.getIssueType()) && set.getComplaintType().equals(t.getOrderType())) {
                        List<ComplaintSetVO> complaintOrders = getAllItems(complaintSetVOS, set.getId());
                        t.setIssueTypeName(getAllClassifyName(complaintOrders));
                    }
                }
                if (t.getConfirmType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                    if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("2")) {
                        List<ComplaintSetVO> complaintOrders = getAllItems(complaintSetVOS, set.getId());
                        t.setConfirmTypeName(getAllClassifyName(complaintOrders));
                    }else if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("1")){
                        t.setConfirmTypeName(set.getClassifyName());
                    }
                }
            });
        });
    }

    //得到所有的父标签
    public List<ComplaintSetVO> getAllItems(List<ComplaintSetVO> complaintSetVOS, Long id) {
        List<ComplaintSetVO> complaintOrders = new ArrayList<>();
        while (id != 0) {
            Long finalId = id;
            Optional<ComplaintSetVO> op = complaintSetVOS.stream().filter(x -> x.getId().equals(finalId)).findFirst();
            if(op.isEmpty()){
                throw new BusinessException("");
            }
            complaintOrders.add(op.get());
            id = op.get().getPid();
        }
        return complaintOrders;
    }

    //拼接成"售后服务->sad->sad213->2321->2313"
    public String getAllClassifyName(List<ComplaintSetVO> complaintOrders) {
        StringBuilder stringBuilder = new StringBuilder();
        for(int i = complaintOrders.size() - 1; i >= 0; i--){
            if(i != 0){
                stringBuilder.append(complaintOrders.get(i).getClassifyName()).append("->");
            }else {
                stringBuilder.append(complaintOrders.get(i).getClassifyName());
            }
        }
        return stringBuilder.toString();
    }



    /**
     * UDC翻译
     *
     * @param complaintOrderVO
     */
    public void udcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_ORDER_KSS001.getModel(), UdcEnum.COMPLAINT_ORDER_KSS001.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(t.getOrderStatus())) {
                t.setOrderStatusName(ajStatusMap.get(t.getOrderStatus()));
            }
        });

        Map<String, String> ajStatusMap2 = systemService.sysUdcGetCodeMap(UdcEnum.TIMEOUT_STATUS_1.getModel(), UdcEnum.TIMEOUT_STATUS_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap2) && ajStatusMap2.containsKey(t.getTimeoutStatus())) {
                t.setTimeoutStatusName(ajStatusMap2.get(t.getTimeoutStatus()));
            }
        });

        Map<String, String> ajStatusMap3 = systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_TYPE_1.getModel(), UdcEnum.COMPLAINT_TYPE_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap3) && ajStatusMap3.containsKey(t.getOrderType())) {
                t.setOrderTypeName(ajStatusMap3.get(t.getOrderType()));
            }
        });

        Map<String, String> ajStatusMap4 = systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap4) && ajStatusMap4.containsKey(t.getCancelReasonC())) {
                t.setCancelReasonCName(ajStatusMap4.get(t.getCancelReasonC()));
            }
        });

        Map<String, String> ajStatusMap5 = systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty(ajStatusMap5) && ajStatusMap5.containsKey(t.getCancelReasonB())) {
                t.setCancelReasonBName(ajStatusMap5.get(t.getCancelReasonB()));
            }
        });
    }

    private MapBuilder setMapBuilder(ComplaintOrderPageParam param) {
        var whereSqlMapBuilder = MapUtils.builder()
                .page(param.getPageRequest().getPageNumber(), param.getPageRequest().getPageSize());
        whereSqlMapBuilder.field(ComplaintOrderSearchBean::getDeleteFlag).sql("($1 = ? or $1 is null)", 0);
        if (!StringUtils.isEmpty(param.getOrderType())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderType, param.getOrderType()).op(FieldOps.Equal);
        }
        if (param.getId() != null && param.getId() != 0) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getId, param.getId()).op(FieldOps.Equal);

        }
        if (param.getIdList() != null && !param.getIdList().isEmpty()) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getId, param.getIdList()).op(FieldOps.InList);

        }
        if (param.getCarOwnerId() != null) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getCarOwnerId, param.getCarOwnerId()).op(FieldOps.Equal);

        }
        if (param.getHandlePersonId() != null) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getHandlePersonId, param.getHandlePersonId()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(param.getOrderStatus())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderStatus, param.getOrderStatus()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(param.getOrderTel())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderTel, param.getOrderTel()).op(FieldOps.Contain);
        }
        if (!StringUtils.isEmpty(param.getOrderPerson())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderPerson, param.getOrderPerson()).op(FieldOps.Contain);
        }
        if (!StringUtils.isEmpty(param.getIssueType())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getIssueType, param.getIssueType()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(param.getOrderNo())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderNo, param.getOrderNo()).op(FieldOps.Contain);

        }
        if (param.getStartTime() != null && param.getEndTime() != null) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getCreateTime, param.getStartTime(), param.getEndTime()).op(FieldOps.Between);
        }
        if (!StringUtils.isEmpty(param.getSearchContent())) {
            String searchContent = "%" + param.getSearchContent() + "%";
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderNo, param.getSearchContent()).sql("($1 like ? or issue_description like ?)", searchContent, searchContent);
        }
        if (!StringUtils.isEmpty(param.getTimeoutStatus())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getTimeoutStatus, param.getTimeoutStatus()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(param.getVehicleType())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getVehicleType, param.getVehicleType()).op(FieldOps.Equal);
        }
        if (param.getBindingTimeStart() != null && param.getBindingTimeEnd() != null) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getBindingTime, param.getBindingTimeStart(), param.getBindingTimeEnd()).op(FieldOps.Between);
        }
        if (!StringUtils.isEmpty(param.getVehicleNo())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getVehicleNo, param.getVehicleNo()).op(FieldOps.Equal);
        }
        if (param.getActivatTimeStart() != null && param.getActivatTimeEnd() != null) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getActivatTime, param.getActivatTimeStart(), param.getActivatTimeEnd()).op(FieldOps.Between);
        }
        if (!StringUtils.isEmpty(param.getCustName())) {
            whereSqlMapBuilder.field(ComplaintOrderSearchBean::getCustName, param.getCustName()).op(FieldOps.Contain);
        }
        return whereSqlMapBuilder;
    }

    private void setParamsOrderBy(List<OrderItem> orders, MapBuilder whereSqlMapBuilder) {
        for (OrderItem orderItem : orders) {
            if (orderItem != null && !orderItem.getColumn().isBlank()) {
                if (orderItem.isAsc()) {
                    whereSqlMapBuilder.orderBy(orderItem.getColumn()).asc();
                } else {
                    whereSqlMapBuilder.orderBy(orderItem.getColumn()).desc();
                }
            } else {
                whereSqlMapBuilder.orderBy(orderItem.getColumn()).desc();
            }
        }
    }
}
