package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.param.BatteryQueryParam;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryQueryVO;
import com.elitesland.yst.production.aftersale.model.entity.BatteryCodesDO;
import com.elitesland.yst.production.aftersale.model.entity.QBatteryCodesDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;

@Repository
public class BatteryRepoProc extends BaseRepoProc<BatteryCodesDO> {

    private static final QBatteryCodesDO QDO = QBatteryCodesDO.batteryCodesDO;

    protected BatteryRepoProc() {
        super(QDO);
    }

    public PagingVO<BatteryQueryVO> batteryQuery(BatteryQueryParam batteryQueryParam){
        Predicate predicate = PredicateBuilder.builder().
                andEq(QDO.deleteFlag,0).
                andEq(StringUtils.hasText(batteryQueryParam.getCode()), QDO.code, batteryQueryParam.getCode()).
                andEq(StringUtils.hasText(batteryQueryParam.getType()), QDO.type, batteryQueryParam.getType()).
                andEq(StringUtils.hasText(batteryQueryParam.getFgCode()), QDO.fgCode, batteryQueryParam.getFgCode()).
                andEq(StringUtils.hasText(batteryQueryParam.getFactoryCode()), QDO.factoryCode, batteryQueryParam.getFactoryCode()).
                andEq(StringUtils.hasText(batteryQueryParam.getProducer()), QDO.producer, batteryQueryParam.getProducer()).
                andEq(StringUtils.hasText(batteryQueryParam.getProdCategory()), QDO.prodCategory, batteryQueryParam.getProdCategory()).
                andLike(StringUtils.hasText(batteryQueryParam.getProdSpecs()), QDO.prodSpecs, "%" + batteryQueryParam.getProdSpecs() + "%").
                andBetween(
                        batteryQueryParam.getFactoryOutTimeS() != null && batteryQueryParam.getFactoryOutTimeE() != null,
                        QDO.factoryOutTime, batteryQueryParam.getFactoryOutTimeS(), batteryQueryParam.getFactoryOutTimeE()
                ).
                andBetween(
                        batteryQueryParam.getInTimeS() != null && batteryQueryParam.getInTimeE() != null,
                        QDO.inTime, batteryQueryParam.getInTimeS(), batteryQueryParam.getInTimeE()
                ).
                andBetween(
                        batteryQueryParam.getOutTimeS() != null && batteryQueryParam.getOutTimeE() != null,
                        QDO.outTime, batteryQueryParam.getOutTimeS(), batteryQueryParam.getOutTimeE()
                ).build();

        JPAQuery<BatteryQueryVO> jpaQuery = jpaQueryFactory.select(fieldsOfDTO())
                .from(QDO)
                .where(predicate);
        return queryByPage(jpaQuery, batteryQueryParam.getPageRequest());
    }

    private QBean<BatteryQueryVO> fieldsOfDTO() {
        return Projections.bean(BatteryQueryVO.class,
                QDO.id,
                QDO.code,
                QDO.type,
                QDO.fgCode,
                QDO.factoryCode,
                QDO.factoryName,
                QDO.prodCategory,
                QDO.prodSpecs,
                QDO.prodModel,
                QDO.producer,
                QDO.factoryOutTime,
                QDO.inTime,
                QDO.outTime
        );
    }

    public List<BatteryQueryVO> findBatteryCodes(List<String> codes) {
        Predicate predicate = PredicateBuilder.builder().
                andEq(QDO.deleteFlag,0).
                andIn(!codes.isEmpty(),QDO.code,codes).build();
        JPAQuery<BatteryQueryVO> jpaQuery = jpaQueryFactory.select(fieldsOfDTO())
                .from(QDO)
                .where(predicate);
        return jpaQuery.fetch();
    }
}
