/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.controller.front;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.model.entity.dto.OrgStoreDTO;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/repairOrder"}, produces={"application/json"})
@Validated
@Api(value="\u7ecf\u9500\u5546pc\u7aef\u7ef4\u4fee\u5de5\u5355", tags={"\u7ecf\u9500\u5546pc\u7aef\u7ef4\u4fee\u5de5\u5355"})
public class FrontRepairOrderController {
    private static final Logger log = LogManager.getLogger(FrontRepairOrderController.class);
    private final RepairOrderService repairOrderService;
    private final ExportExcelService<RepairOrderExlParam, RepairOrderVO, Serializable> exportExcelService;
    private final UserService userService;
    private final CrmSaleService crmSaleService;
    private final UdcProvider udcProvider;

    @PostMapping(value={"/repairOrderQuery"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<RepairOrderVO>> repairOrderQuery(@RequestBody RepairOrderExlParam param) {
        PagingVO<RepairOrderVO> query = this.repairOrderService.pcQuery(param);
        return ApiResult.ok(query);
    }

    @PostMapping(value={"/bcRepairOrderQuery"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<RepairOrderVO>> bcRepairOrderQuery(@RequestBody RepairOrderExlParam param) {
        PagingVO<RepairOrderVO> query = this.repairOrderService.bcPcQuery(param);
        return ApiResult.ok(query);
    }

    @PostMapping(value={"/repairOrderDetail"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u8be6\u60c5\u67e5\u8be2")
    public ApiResult<RepairOrderVO> repairOrderDetail(@RequestBody RepairOrderExlParam param) {
        RepairOrderVO query = this.repairOrderService.detail(param);
        return ApiResult.ok((Object)query);
    }

    @PostMapping(value={"/repairOrderDelete"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u6279\u91cf\u5220\u9664")
    public ApiResult repairOrderCancel(@RequestBody List<Long> idList) {
        this.repairOrderService.repairOrderDelete(idList);
        return ApiResult.ok();
    }

    @PostMapping(value={"/repairOrderSave"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u63d0\u4ea4\u4fdd\u5b58/\u4fee\u6539")
    public ApiResult<Long> repairOrderSave(@RequestBody RepairOrderParam saveVO) {
        Long ret = this.repairOrderService.save(saveVO, "PC");
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/repairOrderConfirm"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u786e\u8ba4\u5b8c\u6210")
    public ApiResult<Long> repairOrderConfirm(@RequestBody RepairOrderParam saveVO) {
        Long confirm = this.repairOrderService.confirm(saveVO);
        return ApiResult.ok((Object)confirm);
    }

    @PostMapping(value={"/repairOrderStart"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u5f00\u59cb\u7ef4\u4fee")
    public ApiResult<Long> repairOrderStart(@RequestBody RepairOrderParam saveVO) {
        Long confirm = this.repairOrderService.start(saveVO);
        return ApiResult.ok((Object)confirm);
    }

    @PostMapping(value={"/repairOrderSupply"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u4fe1\u606f\u8865\u5145")
    public ApiResult<Long> repairOrderSupply(@RequestBody RepairOrderParam saveVO) {
        Long confirm = this.repairOrderService.supply(saveVO);
        return ApiResult.ok((Object)confirm);
    }

    @PostMapping(value={"/repairOrderCancel"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u53d6\u6d88")
    public ApiResult<Long> repairOrderCancel(@RequestBody RepairOrderParam saveVO) {
        ApiResult<Long> longApiResult = this.repairOrderService.repairOrderCancel(saveVO);
        return longApiResult;
    }

    @PostMapping(value={"/repairOrderExport"})
    @ApiOperation(value="\u7ef4\u4fee\u5de5\u5355\u5bfc\u51fa")
    public ApiResult repairOrderExport(HttpServletResponse response, @RequestBody RepairOrderExlParam param) {
        ExcelUtils.buildExportColumn(param, RepairOrderVO.class);
        try {
            this.exportExcelService.export((AbstractExportQueryParam)param, response, this.repairOrderService::export).get();
            return ApiResult.ok();
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Throwable)e);
            return ApiResult.fail((String)"\u5bfc\u51fa\u5931\u8d25\uff1a", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/repairStore"})
    @ApiOperation(value="\u7ecf\u9500\u5546pc\u7aef--\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u6240\u5c5e\u95e8\u5e97")
    public ApiResult<List<OrgStoreDTO>> repairStoreQuery() {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairOrderService.repairStoreQuery();
        SysUserDTO user = this.userService.getUserDetail();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)user));
        CrmCustSimpleVO custSimple = this.crmSaleService.getCustSimple(user.getId());
        ArrayList list = new ArrayList();
        Map regionMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
        orgStoreRpcDTOS.forEach(item -> {
            OrgStoreDTO orgStoreDTO = new OrgStoreDTO();
            BeanUtils.copyProperties((Object)item, (Object)((Object)orgStoreDTO));
            if (null != custSimple) {
                orgStoreDTO.setCustCode2(custSimple.getCustCode2());
                orgStoreDTO.setDealerName(custSimple.getCustName());
                orgStoreDTO.setSaleRegionName((String)regionMap.get(custSimple.getRegion()));
                orgStoreDTO.setRegion(custSimple.getRegion());
            }
            list.add(orgStoreDTO);
        });
        return ApiResult.ok(list);
    }

    public FrontRepairOrderController(RepairOrderService repairOrderService, ExportExcelService<RepairOrderExlParam, RepairOrderVO, Serializable> exportExcelService, UserService userService, CrmSaleService crmSaleService, UdcProvider udcProvider) {
        this.repairOrderService = repairOrderService;
        this.exportExcelService = exportExcelService;
        this.userService = userService;
        this.crmSaleService = crmSaleService;
        this.udcProvider = udcProvider;
    }
}

