/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.out.sys;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.support.provider.item.service.ItmItemRpcService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SystemServiceImpl
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    private final SeqNumProvider sysNumberRuleService;
    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    private final UdcProvider udcProvider;
    private final ItmItemRpcService itemRpcService;
    private final SysUserRpcService sysUserService;

    @Override
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map codeMap = this.udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap;
        }
        catch (Exception e) {
            log.error("findCodeBatch error:", (Throwable)e);
            return new HashMap<String, String>();
        }
    }

    @Override
    public String sysNumberRuleGenerateCode(String code, List<String> runtimeValues) {
        String sys = "";
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(runtimeValues);
        try {
            sys = this.sysNumberRuleService.generateCode("yst-after-sale", code, list);
        }
        catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", (Throwable)e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u53d1\u53f7\u5931\u8d25");
        }
        return sys;
    }

    @Override
    public List<SysUserVO> findAllEmpsByIdIn(List<Long> calcEmpIds) {
        try {
            if (calcEmpIds.isEmpty()) {
                return null;
            }
            List sysUserVOList = this.sysUserService.getByIds(calcEmpIds);
            if (!com.alibaba.nacos.client.naming.utils.CollectionUtils.isEmpty((Collection)sysUserVOList)) {
                return sysUserVOList;
            }
        }
        catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)ouId);
        try {
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            param.setFlowRoleCodes(Collections.singletonList(customParams));
            List userIds = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                return userIds;
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return null;
    }

    @Override
    public SysUserDTO sysUserCurrent() {
        try {
            GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
            if (userDetails == null) {
                return null;
            }
            SysUserDTO sysUserDTO = userDetails.getUser();
            if (sysUserDTO == null) {
                return null;
            }
            return sysUserDTO;
        }
        catch (Exception e) {
            log.error("sysUserCurrent error:", (Throwable)e);
            return null;
        }
    }

    public SystemServiceImpl(SeqNumProvider sysNumberRuleService, SysUserFlowRoleRpcService sysUserFlowRoleRpcService, UdcProvider udcProvider, ItmItemRpcService itemRpcService, SysUserRpcService sysUserService) {
        this.sysNumberRuleService = sysNumberRuleService;
        this.sysUserFlowRoleRpcService = sysUserFlowRoleRpcService;
        this.udcProvider = udcProvider;
        this.itemRpcService = itemRpcService;
        this.sysUserService = sysUserService;
    }
}

