/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.model.entity.BatteryGuaranteesDO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.MaintainCardInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnverCardUpdParam;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardInfoVo;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardTotalVo;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryGuaranteesVO;
import com.elitesland.yst.production.aftersale.model.vo.query.BatteryQueryVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.provider.sale.SalesmanRpcProvider;
import com.elitesland.yst.production.aftersale.provider.support.ItmWarrantyConfigRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysMsgRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.BatteryGuaranteesRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.BatteryRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRelateRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.MaintainCardInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.MaintainCardInfoRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.order.rpc.LmSaleDoRpcService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.yst.production.support.provider.price.dto.ItmWarrantyConfigRpcDTO;
import com.elitesland.yst.production.support.provider.price.param.ItmWarrantyConfigRpcQueryParam;
import com.elitesland.yst.production.support.provider.price.service.ItmWarrantyConfigRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaintainCardServiceImpl
extends BaseServiceImpl
implements MaintainCardService {
    private static final Logger log = LogManager.getLogger(MaintainCardServiceImpl.class);
    @Autowired
    private CarService carService;
    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;
    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;
    @Autowired
    private MaintainCardInfoRepo maintainCardInfoRepo;
    @Autowired
    private MaintainCardInfoRepoProc maintainCardInfoRepoProc;
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;
    @Autowired
    private CarMaintainCardRepoProc carMaintainCardRepoProc;
    @Autowired
    private BatteryGuaranteesRepoProc batteryGuaranteesRepoProc;
    @Autowired
    private PictureOrderService pictureOrderService;
    @Autowired
    private CarOwnerInfoRepo carOwnerInfoRepo;
    @Value(value="${file.upload.url}")
    private String pictureURL;
    @Autowired
    private ItmWarrantyConfigRpcProvider itmWarrantyConfigRpcProvider;
    @Autowired
    private CarOwnerVehicleRelateRepoProc carOwnerVehicleRelateRepoProc;
    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmSaleService crmSaleService;
    @Autowired
    private SalesmanRpcProvider salesmanRpcProvider;
    @Autowired
    private UdcProvider udcProvider;
    private static final String YST_SUPPORT = "yst-supp";
    private static final String REGION = "REGION";
    private static final String ACTIVE_THREE_PACKAGE_LOCK = "ACTIVE_THREE_PACKAGE_LOCK";
    private static final String ACTIVE_THREE_PACKAGE = "ACTIVE_THREE_PACKAGE";
    @Autowired
    private PictureOrderRepo pictureOrderRepo;
    @Autowired
    private SysMsgRpcProvider sysMsgRpcProvider;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private CrmCustAccountRpcService crmCustAccountRpcService;
    @Autowired
    private BatteryRepoProc batteryRepoProc;
    @Autowired
    private ItmWarrantyConfigRpcService itmWarrantyConfigRpcService;
    @Autowired
    private LmSaleDoRpcService lmSaleDoRpcService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> activate(CarMaintainCardParam carMaintainCardParam) {
        CarOwnerInfoDO byCarOwnerId = this.carOwnerInfoRepo.findByCarOwnerId(carMaintainCardParam.getCarOwnerId());
        if (null == byCarOwnerId) {
            throw new BusinessException("\u672a\u627e\u5230\u8f66\u4e3b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u8bef");
        }
        if (this.carMaintainCardRepo.countByVehicleNoAndDeleteFlag(carMaintainCardParam.getVehicleNo(), 0) > 0) {
            throw new BusinessException(ApiCode.FAIL, "\u8be5\u8f66\u8f86\u5df2\u6fc0\u6d3b");
        }
        ArrayList<String> vehicleNoList = new ArrayList<String>();
        vehicleNoList.add(carMaintainCardParam.getVehicleNo());
        CarMaintainCardDO cardDO = this.carMaintainCardRepo.findByVehicleNoAndDeleteFlag(carMaintainCardParam.getVehicleNo(), 1);
        SalemanCustDTO salemanCust = (SalemanCustDTO)this.salesmanRpcProvider.getSalemanCust(carMaintainCardParam.getSalesOutletsId()).getData();
        if (null != salemanCust) {
            List custCodeList = this.lmSaleDoRpcService.vehicleBelongCustList(carMaintainCardParam.getVehicleNo());
            if (CollectionUtils.isEmpty((Collection)custCodeList)) {
                if (null != carMaintainCardParam.getManufactureDate() && carMaintainCardParam.getManufactureDate().isAfter(LocalDateTime.of(2023, 1, 1, 0, 0))) {
                    throw new BusinessException("\u8f66\u67b6\u53f7" + carMaintainCardParam.getVehicleNo() + "\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7ecf\u9500\u5546" + salemanCust.getCustCode() + ",\u8bf7\u8054\u7cfb\u4e1a\u52a1\u4e3b\u7ba1");
                }
            } else {
                String joinStr = custCodeList.stream().collect(Collectors.joining("','"));
                String sql2 = "select relate_cust_code from lm_cust_relate where cust_code in ('" + joinStr + "')";
                List result = this.jdbcTemplate.queryForList(sql2, String.class);
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)result)) {
                    custCodeList.addAll(result);
                }
                if (StringUtils.isNotEmpty((CharSequence)salemanCust.getPid()) ? !custCodeList.contains(salemanCust.getCustCode()) && !custCodeList.contains(salemanCust.getPid()) : !custCodeList.contains(salemanCust.getCustCode())) {
                    throw new BusinessException("\u8f66\u67b6\u53f7" + carMaintainCardParam.getVehicleNo() + "\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7ecf\u9500\u5546" + salemanCust.getCustCode() + ",\u8bf7\u8054\u7cfb\u4e1a\u52a1\u4e3b\u7ba1");
                }
            }
        }
        if (cardDO != null) {
            List<MaintainCardInfoDO> byVehicleThreePackNo;
            cardDO.setCarOwnerId(carMaintainCardParam.getCarOwnerId());
            cardDO.setPurchaseTime(carMaintainCardParam.getPurchaseTime());
            cardDO.setDeleteFlag(0);
            cardDO.setSalesOutletsId(carMaintainCardParam.getSalesOutletsId());
            cardDO.setSalesOutletsCode(carMaintainCardParam.getSalesOutletsCode());
            cardDO.setSalesOutletsName(carMaintainCardParam.getSalesOutletsName());
            cardDO.setVehicleBuyPrice(carMaintainCardParam.getVehicleBuyPrice());
            cardDO.setUserIdCard(carMaintainCardParam.getUserIdCard());
            cardDO.setUserArea(carMaintainCardParam.getUserArea());
            cardDO.setUserSex(carMaintainCardParam.getUserSex());
            cardDO.setUserBirthday(carMaintainCardParam.getUserBirthday());
            cardDO.setPurchaseTime(carMaintainCardParam.getPurchaseTime());
            cardDO.setCreateTime(LocalDateTime.now());
            if (null != salemanCust) {
                cardDO.setRegion(salemanCust.getRegion());
                cardDO.setCustCode2(salemanCust.getCustCode2());
                cardDO.setCustName(salemanCust.getCustName());
            }
            this.carOwnerVehicleRepoProc.updateActivatFlag(byCarOwnerId.getUserPhone(), carMaintainCardParam.getVehicleNo(), true);
            CarMaintainCardDO save = (CarMaintainCardDO)this.carMaintainCardRepo.save(cardDO);
            if (!CollectionUtils.isEmpty(carMaintainCardParam.getPictureOrderParamList())) {
                ArrayList pictureOrderDOList = new ArrayList();
                carMaintainCardParam.getPictureOrderParamList().forEach(vo -> {
                    PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO((PictureOrderParam)vo);
                    pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
                    pictureOrderDO.setOrderId(save.getId());
                    pictureOrderDOList.add(pictureOrderDO);
                });
                this.pictureOrderRepo.saveAll(pictureOrderDOList);
            }
            if (null == (byVehicleThreePackNo = this.maintainCardInfoRepo.findByVehicleThreePackNo(cardDO.getId())) || CollectionUtils.isEmpty(byVehicleThreePackNo)) {
                ItmWarrantyConfigRpcQueryParam param = new ItmWarrantyConfigRpcQueryParam();
                param.setItemGroup2(carMaintainCardParam.getItemGroup2());
                param.setSpuCode(carMaintainCardParam.getSpuCode());
                List<ItmWarrantyConfigRpcDTO> config = this.getConfig(param);
                config.forEach(s -> {
                    String name = "";
                    MaintainCardInfoDO maintainCardInfoDO = new MaintainCardInfoDO();
                    if (!StringUtils.isEmpty((CharSequence)s.getItemType3Name())) {
                        name = s.getItemType3Name();
                    }
                    if (!StringUtils.isEmpty((CharSequence)s.getItemName2())) {
                        String string = name = name.equals("") ? s.getItemName2() : s.getItemName2() + "/" + name;
                    }
                    if (!StringUtils.isEmpty((CharSequence)s.getItemName())) {
                        name = name.equals("") ? s.getItemName() : s.getItemName() + "/" + name;
                    }
                    maintainCardInfoDO.setMountingsName(name);
                    maintainCardInfoDO.setVehicleThreePackNo(cardDO.getId());
                    maintainCardInfoDO.setConfigId(s.getId());
                    maintainCardInfoDO.setMaintainTime(s.getConsumerWarrantyTime().doubleValue());
                    maintainCardInfoDO.setConsumerWarrantyTimeUom(s.getConsumerWarrantyTimeUom());
                    maintainCardInfoDO.setContainThreePack(s.getWarrantyContent());
                    maintainCardInfoDO.setNotContainThreePack(s.getWarrantyExcluded());
                    maintainCardInfoDO.setRepairStartTime(carMaintainCardParam.getPurchaseTime());
                    maintainCardInfoDO.setRepairEndTime(MaintainCardServiceImpl.getTime2(maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTime().doubleValue(), maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTimeUom()));
                    this.maintainCardInfoRepo.save(maintainCardInfoDO);
                });
            }
        } else {
            int carCount = this.carMaintainCardRepo.countByCarOwnerId(carMaintainCardParam.getCarOwnerId());
            if (carCount > 2) {
                throw new BusinessException("\u6fc0\u6d3b\u5931\u8d25,\u4e00\u4e2a\u4f1a\u5458\u6700\u591a\u53ea\u80fd\u6fc0\u6d3b3\u53f0\u8f66\uff0c\u73b0\u5df2\u6fc0\u6d3b\u6570\u91cf:" + carCount);
            }
            CarParam carParam = new CarParam();
            carParam.setVehicleNo(carMaintainCardParam.getVehicleNo());
            CarMaintainCardDO vDO = new CarMaintainCardDO();
            vDO.setVehicleNo(carMaintainCardParam.getVehicleNo());
            vDO.setPurchaseTime(carMaintainCardParam.getPurchaseTime());
            vDO.setCarOwnerId(carMaintainCardParam.getCarOwnerId());
            vDO.setVehicleColor(carMaintainCardParam.getVehicleColor());
            vDO.setVehicleSpecs(carMaintainCardParam.getVehicleSpecs());
            vDO.setVehicleType(carMaintainCardParam.getVehicleType());
            vDO.setVehicleSource(carMaintainCardParam.getVehicleSource());
            vDO.setVehicleBuyPrice(carMaintainCardParam.getVehicleBuyPrice());
            vDO.setUserIdCard(carMaintainCardParam.getUserIdCard());
            vDO.setUserArea(carMaintainCardParam.getUserArea());
            vDO.setUserSex(carMaintainCardParam.getUserSex());
            vDO.setUserBirthday(carMaintainCardParam.getUserBirthday());
            vDO.setSourcePlatform(carMaintainCardParam.getSourcePlatform());
            vDO.setSalesOutletsId(carMaintainCardParam.getSalesOutletsId());
            vDO.setSalesOutletsCode(carMaintainCardParam.getSalesOutletsCode());
            vDO.setSalesOutletsName(carMaintainCardParam.getSalesOutletsName());
            if (null != salemanCust) {
                vDO.setRegion(salemanCust.getRegion());
                vDO.setCustCode2(salemanCust.getCustCode2());
                vDO.setCustName(salemanCust.getCustName());
            }
            CarMaintainCardDO save = (CarMaintainCardDO)this.carMaintainCardRepo.save(vDO);
            if (!CollectionUtils.isEmpty(carMaintainCardParam.getPictureOrderParamList())) {
                ArrayList pictureOrderDOList = new ArrayList();
                carMaintainCardParam.getPictureOrderParamList().forEach(vo -> {
                    PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO((PictureOrderParam)vo);
                    pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
                    pictureOrderDO.setOrderId(save.getId());
                    pictureOrderDOList.add(pictureOrderDO);
                });
                this.pictureOrderRepo.saveAll(pictureOrderDOList);
            }
            Long id = this.carMaintainCardRepo.findByVehicleNo(carMaintainCardParam.getVehicleNo()).getId();
            ItmWarrantyConfigRpcQueryParam param = new ItmWarrantyConfigRpcQueryParam();
            param.setItemGroup2(carMaintainCardParam.getItemGroup2());
            param.setSpuCode(carMaintainCardParam.getSpuCode());
            List<ItmWarrantyConfigRpcDTO> config = this.getConfig(param);
            config.forEach(s -> {
                String name = "";
                MaintainCardInfoDO maintainCardInfoDO = new MaintainCardInfoDO();
                if (!StringUtils.isEmpty((CharSequence)s.getItemType3Name())) {
                    name = s.getItemType3Name();
                }
                if (!StringUtils.isEmpty((CharSequence)s.getItemName2())) {
                    String string = name = name.equals("") ? s.getItemName2() : s.getItemName2() + "/" + name;
                }
                if (!StringUtils.isEmpty((CharSequence)s.getItemName())) {
                    name = name.equals("") ? s.getItemName() : s.getItemName() + "/" + name;
                }
                maintainCardInfoDO.setMountingsName(name);
                maintainCardInfoDO.setVehicleThreePackNo(id);
                maintainCardInfoDO.setConfigId(s.getId());
                maintainCardInfoDO.setMaintainTime(s.getConsumerWarrantyTime().doubleValue());
                maintainCardInfoDO.setConsumerWarrantyTimeUom(s.getConsumerWarrantyTimeUom());
                maintainCardInfoDO.setContainThreePack(s.getWarrantyContent());
                maintainCardInfoDO.setNotContainThreePack(s.getWarrantyExcluded());
                maintainCardInfoDO.setRepairStartTime(carMaintainCardParam.getPurchaseTime());
                maintainCardInfoDO.setRepairEndTime(MaintainCardServiceImpl.getTime2(maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTime().doubleValue(), maintainCardInfoDO.getRepairStartTime(), s.getConsumerWarrantyTimeUom()));
                this.maintainCardInfoRepo.save(maintainCardInfoDO);
            });
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> query(Long carOwnerId, int page, int pageSize) {
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)pageSize);
        log.info((Object)pageable);
        ArrayList<CarOwnerMaintainCardVO> CMCRS = new ArrayList<CarOwnerMaintainCardVO>();
        int total = this.carMaintainCardRepo.countByCarOwnerId(carOwnerId);
        List<CarMaintainCardDO> carMaintainCardDOS = this.carMaintainCardRepo.findByCarOwnerIdAndDeleteFlag(carOwnerId, (Pageable)pageable, 0);
        if (carMaintainCardDOS != null) {
            carMaintainCardDOS.stream().forEach(s -> {
                CarOwnerMaintainCardVO carMaintainCardRespVO = new CarOwnerMaintainCardVO();
                carMaintainCardRespVO.setCarName(s.getCarName());
                carMaintainCardRespVO.setVehicleSpecs(s.getVehicleSpecs());
                carMaintainCardRespVO.setVehicleColor(s.getVehicleColor());
                carMaintainCardRespVO.setVehicleNo(s.getVehicleNo());
                carMaintainCardRespVO.setMaintainCardInfoS(this.maintainCardInfoRepo.findByVehicleThreePackNo(s.getId()));
                carMaintainCardRespVO.setVehicleType(s.getVehicleType());
                CMCRS.add(carMaintainCardRespVO);
            });
            CarMaintainCardTotalVo totalVo = new CarMaintainCardTotalVo();
            totalVo.setTotal(total);
            totalVo.setCmcrs(CMCRS);
            return ApiResult.ok((Object)totalVo);
        }
        return ApiResult.fail((String)"\u672a\u7ed1\u5b9a\u7acb\u9a6c\u8f66\u8f86\uff01");
    }

    @Override
    public ApiResult<CarMaintainCardVO> queryById(String vehicleNo) {
        CarMaintainCardVO carMaintainCardVO = new CarMaintainCardVO();
        CarMaintainCardDO carMaintainCardDO = this.carMaintainCardRepo.findByVehicleNoAndDeleteFlag(vehicleNo, 0);
        if (this.carMaintainCardRepo.countByVehicleNo(vehicleNo) == 0) {
            return ApiResult.ok(null);
        }
        ArrayList<CarMaintainCardInfoVo> list = new ArrayList<CarMaintainCardInfoVo>();
        List<MaintainCardInfoDO> maintainCardInfoDOS = this.maintainCardInfoRepo.findByVehicleThreePackNo(carMaintainCardDO.getId());
        maintainCardInfoDOS.stream().forEach(s -> {
            CarMaintainCardInfoVo carMaintainCardInfoVo = new CarMaintainCardInfoVo();
            carMaintainCardInfoVo.setMountingsName(s.getMountingsName());
            carMaintainCardInfoVo.setRepairStartTime(s.getRepairStartTime());
            carMaintainCardInfoVo.setVehicleThreePackNo(s.getVehicleThreePackNo());
            carMaintainCardInfoVo.setContainThreePack(s.getContainThreePack());
            carMaintainCardInfoVo.setNotContainThreePack(s.getNotContainThreePack());
            carMaintainCardInfoVo.setRemark(s.getRemark());
            carMaintainCardInfoVo.setConfigId(s.getConfigId());
            Double d = new Double(s.getMaintainTime());
            if (99 == d.intValue() && "Y".equals(s.getConsumerWarrantyTimeUom())) {
                carMaintainCardInfoVo.setMaintainTime(null);
                carMaintainCardInfoVo.setConsumerUom("\u7ec8\u8eab");
                carMaintainCardInfoVo.setRepairEndTime(null);
            } else {
                carMaintainCardInfoVo.setMaintainTime(s.getMaintainTime());
                carMaintainCardInfoVo.setConsumerUom(s.getConsumerWarrantyTimeUom());
                carMaintainCardInfoVo.setRepairEndTime(s.getRepairEndTime());
            }
            list.add(carMaintainCardInfoVo);
        });
        carMaintainCardVO.setCarName(carMaintainCardDO.getCarName());
        carMaintainCardVO.setPurchaseTime(carMaintainCardDO.getPurchaseTime());
        carMaintainCardVO.setVehicleType(carMaintainCardDO.getVehicleType());
        carMaintainCardVO.setVehicleSpecs(carMaintainCardDO.getVehicleSpecs());
        carMaintainCardVO.setVehicleColor(carMaintainCardDO.getVehicleColor());
        carMaintainCardVO.setMaintainCardInfoS(list);
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(List.of(carMaintainCardDO.getId()));
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            for (PictureOrderVO pictureOrderVO : data) {
                if (!pictureOrderVO.getUrl().startsWith("http")) {
                    pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                    continue;
                }
                pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
            }
        }
        carMaintainCardVO.setImgs(data);
        return ApiResult.ok((Object)carMaintainCardVO);
    }

    @Override
    public ApiResult delByVehicleNo(CarMaintainCardDO cardDO) {
        CarMaintainCardDO aDo = this.carMaintainCardRepo.findByVehicleNo(cardDO.getVehicleNo());
        if (aDo != null) {
            aDo.setDeleteFlag(1);
            this.carMaintainCardRepo.save(aDo);
            return ApiResult.ok();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delMaintainCard(String vehicleNo) {
        CarMaintainCardDO aDo = this.carMaintainCardRepo.findByVehicleNo(vehicleNo);
        if (aDo != null) {
            this.carMaintainCardRepo.delMaintainCard(aDo.getId(), LocalDateTime.now());
            this.maintainCardInfoRepoProc.delMaintainCard(aDo.getId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean activateThreePackage2(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform) {
        int count;
        block12: {
            carOwnerVehicleParam.setSourcePlatform(sourcePlatform);
            String vehicleNo = carOwnerVehicleParam.getVehicleNo();
            RLock rLock = this.redissonClient.getLock(ACTIVE_THREE_PACKAGE_LOCK + vehicleNo);
            try {
                if (!rLock.tryLock(5L, 300L, TimeUnit.SECONDS)) {
                    throw new BusinessException("\u4e09\u5305\u6fc0\u6d3b\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                String key = ACTIVE_THREE_PACKAGE + vehicleNo;
                if (this.redissonClient.getBucket(key).get() == null) {
                    this.redissonClient.getBucket(key).set((Object)"1", 3L, TimeUnit.SECONDS);
                    break block12;
                }
                throw new BusinessException("\u76f8\u540c\u65f6\u95f4\u5185\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u4e09\u5305\u6fc0\u6d3b");
            }
            catch (BusinessException | InterruptedException e) {
                throw new BusinessException("\u4e09\u5305\u6fc0\u6d3b\u5931\u8d25,\u8f66\u67b6\u53f7" + vehicleNo + "\u5f02\u5e38\u539f\u56e0:" + (Exception)e);
            }
            finally {
                if (rLock.isHeldByCurrentThread()) {
                    rLock.unlock();
                }
            }
        }
        CarMaintainCardParam carMaintainCardParam = new CarMaintainCardParam();
        carMaintainCardParam.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carMaintainCardParam.setPurchaseTime(carOwnerVehicleParam.getPurchaseTime());
        carMaintainCardParam.setProductionDate(carOwnerVehicleParam.getProductionDate());
        carMaintainCardParam.setVehicleNo(carOwnerVehicleParam.getVehicleNo());
        carMaintainCardParam.setPictureOrderParamList(carOwnerVehicleParam.getPictureOrderParamList());
        carMaintainCardParam.setVehicleSource(carOwnerVehicleParam.getVehicleSource());
        carMaintainCardParam.setVehicleBuyPrice(carOwnerVehicleParam.getVehicleBuyPrice());
        carMaintainCardParam.setUserIdCard(carOwnerVehicleParam.getUserIdCard());
        carMaintainCardParam.setUserArea(carOwnerVehicleParam.getUserArea());
        carMaintainCardParam.setUserSex(carOwnerVehicleParam.getUserSex());
        carMaintainCardParam.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
        carMaintainCardParam.setSourcePlatform(sourcePlatform);
        carMaintainCardParam.setVehicleType(carOwnerVehicleParam.getVehicleType());
        carMaintainCardParam.setSalesOutletsId(carOwnerVehicleParam.getSalesOutletsId());
        carMaintainCardParam.setSalesOutletsCode(carOwnerVehicleParam.getSalesOutletsCode());
        carMaintainCardParam.setSalesOutletsName(carOwnerVehicleParam.getSalesOutletsName());
        carMaintainCardParam.setVehicleColor(carOwnerVehicleParam.getVehicleColor());
        carMaintainCardParam.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());
        carMaintainCardParam.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
        carMaintainCardParam.setSpuCode(carOwnerVehicleParam.getSpuCode());
        carMaintainCardParam.setManufactureDate(carOwnerVehicleParam.getManufactureDate());
        if (carOwnerVehicleParam.getUserIdCard() != null && (count = this.carMaintainCardRepoProc.existByPhoneAId(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getUserIdCard())) == 3) {
            throw new BusinessException("\u4e00\u4e2a\u8eab\u4efd\u8bc1\u53ea\u80fd\u6fc0\u6d3b\u4e09\u8f86\u8f66,\u8bf7\u52ff\u91cd\u590d\u6fc0\u6d3b");
        }
        int carCount = this.carMaintainCardRepo.countByCarOwnerId(carMaintainCardParam.getCarOwnerId());
        if (carCount == 3) {
            throw new BusinessException("\u4e00\u4e2a\u624b\u673a\u53f7\u53ea\u80fd\u6fc0\u6d3b\u4e09\u8f86\u8f66,\u8bf7\u52ff\u91cd\u590d\u6fc0\u6d3b");
        }
        ApiResult<Object> activate = this.activate(carMaintainCardParam);
        Boolean isExist = this.carOwnerVehicleService.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
        if (isExist.booleanValue()) {
            this.carOwnerVehicleService.updateActivatFlag(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo(), true);
            return true;
        }
        ApiResult<Long> res = this.carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam, sourcePlatform);
        if (CollectionUtils.isNotEmpty(carOwnerVehicleParam.getBatteryCodes())) {
            this.bindBattery(carOwnerVehicleParam);
        }
        return true;
    }

    public boolean containsDuplicates(Collection<?> collection) {
        HashSet set = new HashSet(collection);
        return set.size() < collection.size();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean activateThreePackage2Mn(CarOwnerVehicleParam carOwnerVehicleParam, String sourcePlatform) {
        int count;
        block15: {
            if (null == carOwnerVehicleParam.getManufactureDate() || carOwnerVehicleParam.getManufactureDate().getYear() < 2023) {
                throw new BusinessException("\u6b64\u8f66\u4e0d\u53ef\u88ab\u8f66\u4e3b\u81ea\u4e3b\u6fc0\u6d3b\uff0c\u9700\u8054\u7cfb\u7ecf\u9500\u5546\uff08\u95e8\u5e97\uff09\u8fdb\u884c\u5904\u7406");
            }
            String vehicleNo = carOwnerVehicleParam.getVehicleNo();
            RLock rLock = this.redissonClient.getLock(ACTIVE_THREE_PACKAGE_LOCK + vehicleNo);
            try {
                if (!rLock.tryLock(5L, 300L, TimeUnit.SECONDS)) {
                    throw new BusinessException("\u4e09\u5305\u6fc0\u6d3b\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                String key = ACTIVE_THREE_PACKAGE + vehicleNo;
                if (this.redissonClient.getBucket(key).get() == null) {
                    this.redissonClient.getBucket(key).set((Object)"1", 30L, TimeUnit.SECONDS);
                    break block15;
                }
                throw new BusinessException("\u76f8\u540c\u65f6\u95f4\u5185\u5b58\u5728\u7591\u4f3c\u91cd\u590d\u4e09\u5305\u6fc0\u6d3b");
            }
            catch (BusinessException | InterruptedException e) {
                throw new BusinessException("\u4e09\u5305\u6fc0\u6d3b\u5931\u8d25,\u8f66\u67b6\u53f7" + vehicleNo + "\u5f02\u5e38\u539f\u56e0:" + (Exception)e);
            }
            finally {
                if (rLock.isHeldByCurrentThread()) {
                    rLock.unlock();
                }
            }
        }
        CarMaintainCardParam carMaintainCardParam = new CarMaintainCardParam();
        carMaintainCardParam.setCarOwnerId(carOwnerVehicleParam.getCarOwnerId());
        carMaintainCardParam.setPurchaseTime(carOwnerVehicleParam.getPurchaseTime());
        carMaintainCardParam.setProductionDate(carOwnerVehicleParam.getProductionDate());
        carMaintainCardParam.setVehicleNo(carOwnerVehicleParam.getVehicleNo());
        carMaintainCardParam.setPictureOrderParamList(carOwnerVehicleParam.getPictureOrderParamList());
        carMaintainCardParam.setVehicleSource(carOwnerVehicleParam.getVehicleSource());
        carMaintainCardParam.setVehicleBuyPrice(carOwnerVehicleParam.getVehicleBuyPrice());
        carMaintainCardParam.setUserIdCard(carOwnerVehicleParam.getUserIdCard());
        carMaintainCardParam.setUserArea(carOwnerVehicleParam.getUserArea());
        carMaintainCardParam.setUserSex(carOwnerVehicleParam.getUserSex());
        carMaintainCardParam.setUserBirthday(carOwnerVehicleParam.getUserBirthday());
        carMaintainCardParam.setSourcePlatform(sourcePlatform);
        carMaintainCardParam.setVehicleType(carOwnerVehicleParam.getVehicleType());
        carMaintainCardParam.setSalesOutletsId(carOwnerVehicleParam.getSalesOutletsId());
        carMaintainCardParam.setSalesOutletsCode(carOwnerVehicleParam.getSalesOutletsCode());
        carMaintainCardParam.setSalesOutletsName(carOwnerVehicleParam.getSalesOutletsName());
        carMaintainCardParam.setVehicleColor(carOwnerVehicleParam.getVehicleColor());
        carMaintainCardParam.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());
        carMaintainCardParam.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
        carMaintainCardParam.setSpuCode(carOwnerVehicleParam.getSpuCode());
        carMaintainCardParam.setManufactureDate(carOwnerVehicleParam.getManufactureDate());
        if (carOwnerVehicleParam.getUserIdCard() != null && (count = this.carMaintainCardRepoProc.existByPhoneAId(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getUserIdCard())) == 3) {
            throw new BusinessException("\u4e00\u4e2a\u8eab\u4efd\u8bc1\u53ea\u80fd\u6fc0\u6d3b\u4e09\u8f86\u8f66,\u8bf7\u52ff\u91cd\u590d\u6fc0\u6d3b");
        }
        int carCount = this.carMaintainCardRepo.countByCarOwnerId(carMaintainCardParam.getCarOwnerId());
        if (carCount == 3) {
            throw new BusinessException("\u4e00\u4e2a\u624b\u673a\u53f7\u53ea\u80fd\u6fc0\u6d3b\u4e09\u8f86\u8f66,\u8bf7\u52ff\u91cd\u590d\u6fc0\u6d3b");
        }
        ApiResult<Object> activate = this.activate(carMaintainCardParam);
        Boolean isExist = this.carOwnerVehicleService.existBy(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo());
        if (isExist.booleanValue()) {
            this.carOwnerVehicleService.updateActivatFlag(carOwnerVehicleParam.getUserPhone(), carOwnerVehicleParam.getVehicleNo(), true);
            return true;
        }
        ApiResult<Long> res = this.carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam, sourcePlatform);
        if (CollectionUtils.isNotEmpty(carOwnerVehicleParam.getBatteryCodes()) || CollectionUtils.isNotEmpty(carOwnerVehicleParam.getChargerCodes())) {
            this.bindBattery(carOwnerVehicleParam);
        }
        try {
            this.sendActiveMsg(carOwnerVehicleParam);
        }
        catch (Exception e) {
            log.error("\u6fc0\u6d3b\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object)e.getMessage());
        }
        return true;
    }

    public void bindBattery(CarOwnerVehicleParam carOwnerVehicleParam) {
        ArrayList<String> allCodes = new ArrayList<String>();
        allCodes.addAll(carOwnerVehicleParam.getBatteryCodes());
        allCodes.addAll(carOwnerVehicleParam.getChargerCodes());
        if (this.containsDuplicates(allCodes)) {
            throw new BusinessException("\u5b58\u5728\u7535\u6c60\u6216\u7535\u5145\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u7535\u6c60,\u7535\u5145\u4fe1\u606f");
        }
        List<BatteryQueryVO> list = this.batteryRepoProc.findBatteryCodes(allCodes);
        if (list.isEmpty() || list.size() < allCodes.size()) {
            List exitCodes = list.stream().map(BatteryQueryVO::getCode).collect(Collectors.toList());
            List str = allCodes.stream().filter(x -> !exitCodes.contains(x)).collect(Collectors.toList());
            throw new BusinessException(str + "\u672a\u627e\u5230\u7535\u6c60\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u7535\u6c60\u4fe1\u606f\u6216\u8054\u7cfb\u4e1a\u52a1\u5458");
        }
        Map<String, String> typeMap = list.stream().collect(Collectors.toMap(BatteryQueryVO::getCode, BatteryQueryVO::getType));
        carOwnerVehicleParam.getBatteryCodes().forEach(code -> {
            String type = (String)typeMap.get(code);
            if (!"\u7535\u6c60".equals(type)) {
                throw new BusinessException("\u7f16\u7801\u4e3a" + code + "\u7684\u7c7b\u578b\u4e0d\u662f\u7535\u6c60\uff0c\u8bf7\u68c0\u67e5");
            }
            BatteryGuaranteesDO batteryGuaranteesDO = new BatteryGuaranteesDO();
            batteryGuaranteesDO.setIdCard(carOwnerVehicleParam.getUserIdCard());
            batteryGuaranteesDO.setCode((String)code);
            batteryGuaranteesDO.setType("\u7535\u6c60");
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName());
            batteryGuaranteesDO.setOwnerMobile(carOwnerVehicleParam.getUserPhone());
            batteryGuaranteesDO.setOwnerName(carOwnerVehicleParam.getUserName());
            batteryGuaranteesDO.setGuaranteesTime(LocalDateTime.now());
            batteryGuaranteesDO.setVehicleType(carOwnerVehicleParam.getVehicleType());
            batteryGuaranteesDO.setSpuCode(carOwnerVehicleParam.getSpuCode());
            if (carOwnerVehicleParam.getSpuName() == null) {
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getVehicleModel());
            } else {
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getSpuName());
            }
            batteryGuaranteesDO.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());
            batteryGuaranteesDO.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
            batteryGuaranteesDO.setMtnrv(carOwnerVehicleParam.getMtnrv());
            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode());
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName());
            batteryGuaranteesDO.setStoreCode(carOwnerVehicleParam.getSalesOutletsCode());
            batteryGuaranteesDO.setStoreName(carOwnerVehicleParam.getSalesOutletsName());
            batteryGuaranteesDO.setStoreId(String.valueOf(carOwnerVehicleParam.getSalesOutletsId()));
            batteryGuaranteesDO.setProvince(carOwnerVehicleParam.getProvince());
            batteryGuaranteesDO.setProvinceName(carOwnerVehicleParam.getProvinceName());
            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode());
            batteryGuaranteesDO.setCustCode2(carOwnerVehicleParam.getCustCode2());
            batteryGuaranteesDO.setSaleRegion(carOwnerVehicleParam.getSaleRegion());
            batteryGuaranteesDO.setSaleRegionName(carOwnerVehicleParam.getSaleRegionName());
            batteryGuaranteesDO.setVehicleNo(carOwnerVehicleParam.getVehicleNo());
            batteryGuaranteesDO.setStoreCode2(carOwnerVehicleParam.getStoreCode2());
            this.batteryGuaranteesRepoProc.save((Serializable)((Object)batteryGuaranteesDO));
        });
        carOwnerVehicleParam.getChargerCodes().forEach(code -> {
            String type = (String)typeMap.get(code);
            if (!"\u5145\u7535\u5668".equals(type)) {
                throw new BusinessException("\u7f16\u7801\u4e3a" + code + "\u7684\u7c7b\u578b\u4e0d\u662f\u5145\u7535\u5668\uff0c\u8bf7\u68c0\u67e5");
            }
            BatteryGuaranteesDO batteryGuaranteesDO = new BatteryGuaranteesDO();
            batteryGuaranteesDO.setIdCard(carOwnerVehicleParam.getUserIdCard());
            batteryGuaranteesDO.setCode((String)code);
            batteryGuaranteesDO.setType("\u5145\u7535\u5668");
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName());
            batteryGuaranteesDO.setOwnerMobile(carOwnerVehicleParam.getUserPhone());
            batteryGuaranteesDO.setOwnerName(carOwnerVehicleParam.getUserName());
            batteryGuaranteesDO.setGuaranteesTime(LocalDateTime.now());
            batteryGuaranteesDO.setVehicleType(carOwnerVehicleParam.getVehicleType());
            batteryGuaranteesDO.setSpuCode(carOwnerVehicleParam.getSpuCode());
            if (carOwnerVehicleParam.getSpuName() == null) {
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getVehicleModel());
            } else {
                batteryGuaranteesDO.setSpuName(carOwnerVehicleParam.getSpuName());
            }
            batteryGuaranteesDO.setVehicleSpecs(carOwnerVehicleParam.getVehicleSpecs());
            batteryGuaranteesDO.setItemGroup2(carOwnerVehicleParam.getItemGroup2());
            batteryGuaranteesDO.setMtnrv(carOwnerVehicleParam.getMtnrv());
            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode());
            batteryGuaranteesDO.setDealerName(carOwnerVehicleParam.getDealerName());
            batteryGuaranteesDO.setStoreCode(carOwnerVehicleParam.getSalesOutletsCode());
            batteryGuaranteesDO.setStoreName(carOwnerVehicleParam.getSalesOutletsName());
            batteryGuaranteesDO.setStoreId(String.valueOf(carOwnerVehicleParam.getSalesOutletsId()));
            batteryGuaranteesDO.setProvince(carOwnerVehicleParam.getProvince());
            batteryGuaranteesDO.setProvinceName(carOwnerVehicleParam.getProvinceName());
            batteryGuaranteesDO.setCustCode(carOwnerVehicleParam.getCustCode());
            batteryGuaranteesDO.setCustCode2(carOwnerVehicleParam.getCustCode2());
            batteryGuaranteesDO.setSaleRegion(carOwnerVehicleParam.getSaleRegion());
            batteryGuaranteesDO.setSaleRegionName(carOwnerVehicleParam.getSaleRegionName());
            batteryGuaranteesDO.setVehicleNo(carOwnerVehicleParam.getVehicleNo());
            batteryGuaranteesDO.setStoreCode2(carOwnerVehicleParam.getStoreCode2());
            this.batteryGuaranteesRepoProc.save((Serializable)((Object)batteryGuaranteesDO));
        });
    }

    @Override
    public void sendActiveMsg(CarOwnerVehicleParam param) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode("WXB0005");
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("msgType", "");
            dto.setMesJoinParamMap(objectObjectHashMap);
            ArrayList<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<TemplateAssignRecipientUserDTO>();
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = this.orgStoreRpcService.getByCode(param.getSalesOutletsCode());
            if (null != orgStoreDetailRpcDTO) {
                ArrayList<String> codes = new ArrayList<String>();
                codes.add(orgStoreDetailRpcDTO.getPcode());
                List custAccountVOS = this.crmCustAccountRpcService.getCustAccountBycustCode(codes);
                if (!custAccountVOS.isEmpty()) {
                    CustAccountVO custAccountVO = (CustAccountVO)custAccountVOS.get(0);
                    HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
                    map3.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(custAccountVO.getMobile()).build());
                    TemplateAssignRecipientUserDTO recipient3 = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map3).userName(custAccountVO.getUserName()).build();
                    recipientUserList.add(recipient3);
                }
            }
            HashMap interiorMap = Maps.newHashMap();
            interiorMap.put("carUser", param.getUserName());
            interiorMap.put("vehicleType", param.getVehicleType());
            this.sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    @SysCodeProc
    public PagingVO<CarMaintainCardVO> page(CarOwnerMaintainCardPageParam car) {
        PagingVO<CarMaintainCardVO> page = this.carMaintainCardRepoProc.page(car);
        Map regionMap = this.udcProvider.getValueMapByUdcCode(YST_SUPPORT, REGION);
        if (!CollectionUtils.isEmpty((Collection)page.getRecords())) {
            page.getRecords().forEach(item -> {
                if (item.getPlanName() == null) {
                    item.setIsSignedInsurance("\u5426");
                } else {
                    item.setIsSignedInsurance("\u662f");
                }
            });
            List<Long> ids = page.getRecords().stream().map(BaseModelVO::getId).collect(Collectors.toList());
            PictureOrderParam pictureOrderParam = new PictureOrderParam();
            pictureOrderParam.setOrderList(ids);
            pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
            List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
            if (!CollectionUtils.isEmpty((Collection)data)) {
                for (PictureOrderVO pictureOrderVO : data) {
                    if (!pictureOrderVO.getUrl().startsWith("http")) {
                        pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                        continue;
                    }
                    pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
                }
            }
            Map<Long, List<PictureOrderVO>> collect = data.stream().collect(Collectors.groupingBy(PictureOrderVO::getOrderId));
            page.getRecords().stream().forEach(x -> {
                if (!CollectionUtils.isEmpty((Collection)((Collection)collect.get(x.getId())))) {
                    x.setImgs((List)collect.get(x.getId()));
                }
                x.setSalesOutletsRegionName((String)regionMap.get(x.getRegion()));
            });
            List<String> vehicleList = page.getRecords().stream().map(CarMaintainCardVO::getVehicleNo).collect(Collectors.toList());
            Map<String, String> batteryMap = this.carMaintainCardRepoProc.findBattery(vehicleList);
            Map<String, String> chargerMap = this.carMaintainCardRepoProc.findCharger(vehicleList);
            page.getRecords().forEach(x -> {
                x.setBatteryCodes((String)batteryMap.get(x.getVehicleNo()));
                x.setChargerCode((String)chargerMap.get(x.getVehicleNo()));
            });
        }
        return page;
    }

    private void fillCustInfo(List<CarMaintainCardVO> records) {
        List<String> vehicleNoList = records.stream().map(CarMaintainCardVO::getVehicleNo).filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.toList());
        List<BindSoldVehicleVO> bindSoldVehicleVOList = this.carOwnerVehicleService.findCustByVehicleNo(vehicleNoList);
        if (org.springframework.util.CollectionUtils.isEmpty(bindSoldVehicleVOList)) {
            return;
        }
        List<Long> ids = records.stream().map(BaseModelVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(ids);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            for (PictureOrderVO pictureOrderVO : data) {
                if (!pictureOrderVO.getUrl().startsWith("http")) {
                    pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                    continue;
                }
                pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
            }
        }
        Map<Long, List<PictureOrderVO>> collect = data.stream().collect(Collectors.groupingBy(PictureOrderVO::getOrderId));
        Map<String, List<BindSoldVehicleVO>> bindSoldVehicleVOMap = bindSoldVehicleVOList.stream().collect(Collectors.groupingBy(BindSoldVehicleVO::getVehicleNo));
        records.forEach(x -> {
            List bindSoldVehicleVOList1;
            BindSoldVehicleVO bindSoldVehicleVO;
            if (!CollectionUtils.isEmpty((Collection)((Collection)collect.get(x.getId())))) {
                x.setImgs((List)collect.get(x.getId()));
            }
            if (bindSoldVehicleVOMap.containsKey(x.getVehicleNo()) && null != (bindSoldVehicleVO = (BindSoldVehicleVO)(bindSoldVehicleVOList1 = (List)bindSoldVehicleVOMap.get(x.getVehicleNo())).stream().filter(s -> StringUtils.isEmpty((CharSequence)x.getSalesOutletsCode()) || s.getSalesOutletsCode().equals(x.getSalesOutletsCode())).findAny().orElse(null))) {
                x.setCustCode2(bindSoldVehicleVO.getCustCode2());
                x.setCustName(bindSoldVehicleVO.getCustName());
                x.setSalesOutletsRegionName(bindSoldVehicleVO.getSalesOutletsRegionName());
            }
        });
    }

    @Override
    @SysCodeProc
    public PagingVO<CarMaintainCardVO> pageSaleMan(CarOwnerMaintainCardPageParam car) {
        ApiResult result = this.employeeRpcService.getByUserId(this.userService.getUserId());
        if (result.getData() == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((SysEmployeeBasicDTO)result.getData()).getCode())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u83b7\u53d6\u5458\u5de5code\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        if (!"SALESMAN".equals(((SysEmployeeBasicDTO)result.getData()).getType())) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u975e\u4e1a\u52a1\u5458\u65e0\u6cd5\u4f7f\u7528\u6b64\u9875\u9762");
        }
        String empCode = ((SysEmployeeBasicDTO)result.getData()).getCode();
        List<Long> storeIdList = this.crmSaleService.querySaleManStoreIds(empCode);
        if (org.springframework.util.CollectionUtils.isEmpty(storeIdList)) {
            return PagingVO.builder().total(0L).build();
        }
        car.setSalesOutletsIds2(storeIdList);
        PagingVO<CarMaintainCardVO> page = this.carMaintainCardRepoProc.page(car);
        Map regionMap = this.udcProvider.getValueMapByUdcCode(YST_SUPPORT, REGION);
        if (!CollectionUtils.isEmpty((Collection)page.getRecords())) {
            page.getRecords().stream().forEach(x -> x.setSalesOutletsRegionName((String)regionMap.get(x.getRegion())));
        }
        return page;
    }

    @Override
    @SysCodeProc
    public CarMaintainCardVO get(Long id) {
        CarMaintainCardVO res = this.carMaintainCardRepoProc.get(id);
        if (res.getIsCancel() != null) {
            res.setIsCancelStr(res.getIsCancel() == 0 ? "\u662f" : "\u5426");
        } else {
            res.setIsCancelStr("\u5426");
        }
        this.fillCustInfo(Lists.newArrayList((Object[])new CarMaintainCardVO[]{res}));
        ArrayList<CarMaintainCardInfoVo> resList = new ArrayList<CarMaintainCardInfoVo>();
        List<MaintainCardInfoDO> byVehicleThreePackNo = this.maintainCardInfoRepo.findByVehicleThreePackNo(res.getId());
        for (MaintainCardInfoDO maintainCardInfoDO : byVehicleThreePackNo) {
            CarMaintainCardInfoVo cardInfoVo = new CarMaintainCardInfoVo();
            cardInfoVo.setId(maintainCardInfoDO.getId());
            cardInfoVo.setMountingsName(maintainCardInfoDO.getMountingsName());
            cardInfoVo.setMaintainTime(maintainCardInfoDO.getMaintainTime());
            cardInfoVo.setConsumerUom(maintainCardInfoDO.getConsumerWarrantyTimeUom());
            cardInfoVo.setRepairEndTime(maintainCardInfoDO.getRepairEndTime());
            cardInfoVo.setRepairStartTime(maintainCardInfoDO.getRepairStartTime());
            cardInfoVo.setVehicleThreePackNo(maintainCardInfoDO.getVehicleThreePackNo());
            cardInfoVo.setContainThreePack(maintainCardInfoDO.getContainThreePack());
            cardInfoVo.setNotContainThreePack(maintainCardInfoDO.getNotContainThreePack());
            cardInfoVo.setConfigId(maintainCardInfoDO.getConfigId());
            resList.add(cardInfoVo);
        }
        res.setMaintainCardInfoS(resList);
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(List.of(res.getId()));
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_5.getValueCode());
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            for (PictureOrderVO pictureOrderVO : data) {
                if (!pictureOrderVO.getUrl().startsWith("http")) {
                    pictureOrderVO.setFullUrl(pictureOrderVO.getUrl());
                    continue;
                }
                pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
            }
        }
        res.setImgs(data);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delAllByVehicleNo(List<String> vehicleNos) {
        log.info("\u8f66\u8f86\u4e09\u5305\u5220\u9664\u5165\u53c2 vehicleNos:{}", (Object)vehicleNos.toString());
        for (String vehicleNo : vehicleNos) {
            this.carOwnerVehicleRepoProc.deletearOwnerVehicleInfoByNo(vehicleNo);
            log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u6210\u529f\u8f66\u67b6\u53f7: {}", (Object)vehicleNo);
            List<Long> byNos = this.carOwnerVehicleRepoProc.getByNo(vehicleNo);
            this.carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateByVids(byNos);
            log.info("\u8f66\u4e3b\u4e0e\u8f66\u8f86\u5173\u7cfb\u8868\u5220\u9664\u6210\u529f {}", byNos);
            this.delMaintainCard(vehicleNo);
            log.info("\u4e09\u5305\u4fe1\u606f\u8868\u5220\u9664\u6210\u529f\uff1a\u8f66\u67b6\u53f7: {}", (Object)vehicleNo);
        }
        return true;
    }

    public void delBatteryGuaranteesByVehicleNo(List<String> vehicleNos) {
        List<BatteryGuaranteesVO> list = this.batteryGuaranteesRepoProc.findByVehicleNo(vehicleNos);
        List codes = list.stream().map(it -> "battery" + it.getCode()).collect(Collectors.toList());
        if (!list.isEmpty()) {
            this.batteryGuaranteesRepoProc.deletearBatteryGuaranteesByVehicleNo(vehicleNos);
            log.info("\u7535\u6c60\u6fc0\u6d3b\u8868\u5220\u9664\u6210\u529f\uff0c\u8f66\u67b6\u53f7: {}", vehicleNos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delAllByVehicleNoApp(List<String> vehicleNos, List<Long> sids) {
        log.info("\u8f66\u8f86\u4e09\u5305\u5220\u9664\u5165\u53c2 vehicleNos:{}", (Object)vehicleNos.toString());
        log.info("\u8f66\u8f86\u4e09\u5305\u9500\u552e\u95e8\u5e97ids\u5165\u53c2 sids:{}", (Object)sids.toString());
        if (CollectionUtils.isEmpty(vehicleNos)) {
            throw new BusinessException("\u8fdb\u884c\u4e09\u5305\u89e3\u7ed1\u65f6\uff0c\u8f66\u67b6\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(sids)) {
            return true;
        }
        List<String> vNoList = this.carOwnerVehicleRepoProc.findBySaleOutsIds(sids);
        if (CollectionUtils.isEmpty(vNoList)) {
            return true;
        }
        for (String vehicleNo : vehicleNos) {
            if (vNoList.contains(vehicleNo)) {
                this.carOwnerVehicleRepoProc.deletearOwnerVehicleInfoByNo(vehicleNo);
                log.info("\u8f66\u8f86\u89e3\u9664\u7ed1\u5b9a\u6210\u529f\u8f66\u67b6\u53f7: {}", (Object)vehicleNo);
                List<Long> byNos = this.carOwnerVehicleRepoProc.getByNo(vehicleNo);
                this.carOwnerVehicleRelateRepoProc.deleteCarOwnerVehicleRelateByVids(byNos);
                log.info("\u8f66\u4e3b\u4e0e\u8f66\u8f86\u5173\u7cfb\u8868\u5220\u9664\u6210\u529f {}", byNos);
                this.delMaintainCard(vehicleNo);
                log.info("\u4e09\u5305\u4fe1\u606f\u8868\u5220\u9664\u6210\u529f\uff1a\u8f66\u67b6\u53f7: {}", (Object)vehicleNo);
                continue;
            }
            throw new BusinessException("\u8f66\u67b6\u53f7:" + vehicleNo + "\u672a\u5728\u95e8\u5e97\u4e0b\uff0c\u4e0d\u80fd\u8fdb\u884c\u89e3\u7ed1\u4e09\u5305");
        }
        return true;
    }

    @Override
    public PagingVO<CarMaintainCardVO> pageApp(CarOwnerMaintainCardPageParam car, List<Long> collect) {
        car.setSalesOutletsIds(collect);
        PagingVO<CarMaintainCardVO> page = this.carMaintainCardRepoProc.page(car);
        this.fillCustInfo(page.getRecords());
        return page;
    }

    private static LocalDate getTime2(LocalDate buyDate, Double time, LocalDate d, String uom) {
        int timeVal = time.intValue();
        if (uom.equals("Y")) {
            LocalDate localDate = buyDate.plusYears(timeVal);
            return localDate;
        }
        LocalDate localDate1 = buyDate.plusMonths(timeVal);
        return localDate1;
    }

    private static void getTime3(LocalDate date, Double time, LocalDate d, String uom) {
    }

    private List<ItmWarrantyConfigRpcDTO> getConfig(ItmWarrantyConfigRpcQueryParam param) {
        List<ItmWarrantyConfigRpcDTO> config = this.itmWarrantyConfigRpcProvider.getConfig(param);
        if (!org.springframework.util.CollectionUtils.isEmpty(config)) {
            Map<String, List<ItmWarrantyConfigRpcDTO>> map = config.stream().collect(Collectors.groupingBy(ItmWarrantyConfigRpcDTO::getItemType3));
            ArrayList<ItmWarrantyConfigRpcDTO> finalList = new ArrayList<ItmWarrantyConfigRpcDTO>();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)param.getSpuCode()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)param.getItemGroup2())) {
                map.keySet().forEach(x -> {
                    List list1 = (List)map.get(x);
                    List list2 = list1.stream().filter(y -> param.getSpuCode().equals(y.getSpuCode()) && param.getItemGroup2().equals(y.getItemGroup2())).collect(Collectors.toList());
                    if (org.springframework.util.CollectionUtils.isEmpty(list2)) {
                        Optional<ItmWarrantyConfigRpcDTO> op = list1.stream().filter(y -> null == y.getItemGroup2() && param.getSpuCode().equals(y.getSpuCode())).findAny();
                        if (op.isPresent()) {
                            finalList.add(op.get());
                        } else {
                            Optional<ItmWarrantyConfigRpcDTO> op2 = list1.stream().filter(y -> null == y.getItemGroup2() && null == y.getSpuCode()).findAny();
                            op2.ifPresent(finalList::add);
                        }
                    } else {
                        finalList.add((ItmWarrantyConfigRpcDTO)list2.get(0));
                    }
                });
            } else if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)param.getSpuCode())) {
                map.keySet().forEach(x -> {
                    List list1 = (List)map.get(x);
                    List list2 = list1.stream().filter(y -> param.getSpuCode().equals(y.getSpuCode()) && null == y.getItemGroup2()).collect(Collectors.toList());
                    if (org.springframework.util.CollectionUtils.isEmpty(list2)) {
                        Optional<ItmWarrantyConfigRpcDTO> op = list1.stream().filter(y -> null == y.getItemGroup2() && null == y.getSpuCode()).findAny();
                        op.ifPresent(finalList::add);
                    } else {
                        finalList.add((ItmWarrantyConfigRpcDTO)list2.get(0));
                    }
                });
            } else {
                map.keySet().forEach(x -> {
                    List list1 = (List)map.get(x);
                    Optional<ItmWarrantyConfigRpcDTO> op = list1.stream().filter(y -> null == y.getSpuCode() && null == y.getItemGroup2()).findAny();
                    op.ifPresent(finalList::add);
                });
            }
            return finalList;
        }
        return config;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updIdCard(CarOwnverCardUpdParam updParam) {
        int countByUserIdCard;
        Optional op = this.carMaintainCardRepo.findById(updParam.getId());
        if (op.isEmpty()) {
            throw new BusinessException("\u4e09\u5305\u4fe1\u606f\u672a\u67e5\u8be2\u5230");
        }
        CarMaintainCardDO carMain = (CarMaintainCardDO)op.get();
        if (StringUtils.isNotBlank((String)carMain.getUserIdCard())) {
            throw new BusinessException("\u5f53\u524d\u4e09\u5305\u4fe1\u606f\u8eab\u4efd\u8bc1\u53f7\u7801\u4e0d\u4e3a\u7a7a");
        }
        String idcard = updParam.getIdcard();
        if (updParam.getIdcard() != null && (countByUserIdCard = this.carOwnerVehicleRepo.findCountByUserIdCard(updParam.getIdcard())) == 1) {
            throw new BusinessException("\u6b64\u7528\u6237\u8eab\u4efd\u8bc1\u53f7\u5df2\u7ed1\u5b9a\u4e00\u8f86\u8f66\uff0c\u8bf7\u5148\u89e3\u7ed1\u518d\u7ed1\u5b9a");
        }
        carMain.setUserIdCard(idcard);
        this.carMaintainCardRepo.save(carMain);
        CarOwnerVehicleInfoDO vehicleInfo = this.carOwnerVehicleRepo.findByVehicleNo(carMain.getVehicleNo());
        if (vehicleInfo != null) {
            vehicleInfo.setUserIdCard(idcard);
            this.carOwnerVehicleRepo.save((Object)vehicleInfo);
        }
    }
}

