/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserService {
    private static final Logger log = LogManager.getLogger(UserService.class);
    @Autowired
    private UdcProvider udcProvider;

    public Long getUserId() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Optional.ofNullable(userDetails).isEmpty()) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u672a\u8ba4\u8bc1\u6216\u8eab\u4efd\u8ba4\u8bc1\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", null);
        }
        Long userId = userDetails.getUserId();
        log.info("\u8f66\u4e3bid {}", (Object)userId);
        return userId;
    }

    public SysUserDTO getUserDetail() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Optional.ofNullable(userDetails).isEmpty()) {
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u672a\u8ba4\u8bc1\u6216\u8eab\u4efd\u8ba4\u8bc1\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", null);
        }
        return userDetails.getUser();
    }

    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map codeMap = this.udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap;
        }
        catch (Exception e) {
            log.error("findCodeBatch error:{}", (Throwable)e);
            return new HashMap<String, String>();
        }
    }
}

