package com.elitesland.yst.production.aftersale.provider.sale;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;

import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.service.SalesmanRpcService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author wang.xl
 * @version V1.0
 * @package com.elitesland.yst.production.aftersale.provider.sale
 * @date 2023/4/26 17:06
 */
@Component
@Log4j2
public class SalesmanRpcProvider {

    @Autowired
    private SalesmanRpcService salesmanRpcService;


    public ApiResult<SalemanCustDTO> getSalemanCust(Long id) {
        ApiResult<SalemanCustDTO> salemanCustResult = null;
        try {
            salemanCustResult = salesmanRpcService.getSalemanCust(id);
        } catch (Exception e) {
            log.error(e);
            throw new BusinessException("调用sale域失败:" + e.getMessage());
        }
        if (salemanCustResult.getCode() != ApiCode.SUCCESS.getCode()) {
            throw new BusinessException("调用sale域失败:" + salemanCustResult.getMsg());
        }
        return salemanCustResult;
    }

}
