package com.elitesland.yst.production.aftersale.service.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.*;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehiclePhonePageParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarAndVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.model.vo.VehicleSaleStatisticsVO;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.wrappers.BooleanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleRepoProc
 * @Date2023/2/9 11:19
 */
@Repository
public class CarOwnerVehicleRepoProc extends BaseRepoProc<CarOwnerVehicleInfoDO> {

    private static final QCarOwnerVehicleInfoDO Q_CAR_OWNER_VEHICLE_INFO_DO = QCarOwnerVehicleInfoDO.carOwnerVehicleInfoDO;
    private static final QCarOwnerVehicleRelateDO carOwnerVehicleRelateDO = QCarOwnerVehicleRelateDO.carOwnerVehicleRelateDO;
    private static final QCarOwnerInfoDO carOwnerInfoDO = QCarOwnerInfoDO.carOwnerInfoDO;

    private static final QCarMaintainCardDO Q_CAR_MAINTAIN_CARD_DO = QCarMaintainCardDO.carMaintainCardDO;

    @Autowired
    private CarOwnerVehicleRepo carOwnerVehicleRepo;

    protected CarOwnerVehicleRepoProc() {
        super(Q_CAR_OWNER_VEHICLE_INFO_DO);
    }

    public void deletearOwnerVehicleInfoDO(Long id) {
        super.updateDeleteFlagByValue(Q_CAR_OWNER_VEHICLE_INFO_DO.id, id);
    }


    public void deletearOwnerVehicleInfoByNo(String no) {
        super.updateDeleteFlagByValue(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo, no);
    }


    public PagingVO<BindSoldVehicleVO> bindSoldVehicleQuery(BindSoldVehicleParam param) {

        JPAQuery<BindSoldVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                BindSoldVehicleVO.class,
                Q_CAR_OWNER_VEHICLE_INFO_DO.id,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleType,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleColor,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSpecs,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSource,
                Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime,
                Q_CAR_OWNER_VEHICLE_INFO_DO.purchaseTime,
                Q_CAR_OWNER_VEHICLE_INFO_DO.brandName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId,
                Q_CAR_OWNER_VEHICLE_INFO_DO.maintainCardNo,
                Q_CAR_OWNER_VEHICLE_INFO_DO.manufactureDate,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userIdCard,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userSex,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userArea,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userBirthday,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleBuyPrice,
                Q_CAR_OWNER_VEHICLE_INFO_DO.updater,
                Q_CAR_OWNER_VEHICLE_INFO_DO.secUserId,
                Q_CAR_OWNER_VEHICLE_INFO_DO.secBuId,
                Q_CAR_OWNER_VEHICLE_INFO_DO.secOuId,
                Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag,
                Q_CAR_OWNER_VEHICLE_INFO_DO.creator,
                Q_CAR_OWNER_VEHICLE_INFO_DO.createTime,
                Q_CAR_OWNER_VEHICLE_INFO_DO.createUserId,
                Q_CAR_OWNER_VEHICLE_INFO_DO.remark,
                Q_CAR_OWNER_VEHICLE_INFO_DO.custCode2,
                Q_CAR_OWNER_VEHICLE_INFO_DO.custName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsRegionName
        )).from(Q_CAR_OWNER_VEHICLE_INFO_DO);
        if (Objects.nonNull(param)) {
            jpaQuery.where(whereParam(param));
            param.fillOrders(jpaQuery, Q_CAR_OWNER_VEHICLE_INFO_DO);
            param.setPaging(jpaQuery);
        }

        return PagingVO.<BindSoldVehicleVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();

    }

    private Predicate whereParam(BindSoldVehicleParam param) {

        Predicate predicate = Q_CAR_OWNER_VEHICLE_INFO_DO.isNotNull();
        if (!StringUtils.isEmpty(param.getCustInfo())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.userName.like("%" + param.getCustInfo() + "%").or(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.like("%" + param.getCustInfo() + "%")));
        }
        if (!StringUtils.isEmpty(param.getAppInfo())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.like("%" + param.getAppInfo() + "%").or(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.like("%" + param.getAppInfo() + "%")));
        }
        if (!StringUtils.isEmpty(param.getVehicleNo())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.like("%" + param.getVehicleNo() + "%"));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty(param.getSalesOutletsCode())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode.eq(param.getSalesOutletsCode()));
        }
        if (!StringUtils.isEmpty(param.getVehicleType())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleType.like("%" + param.getVehicleType() + "%"));
        }
        if (param.getVehicleSource() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSource.eq(param.getVehicleSource()));
        }
        if (param.getStartTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime.goe(param.getStartTime()));
        }
        if (param.getEndTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime.loe(param.getEndTime()));
        }
        if (!CollectionUtils.isEmpty(param.getSalesOutletsIdS())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId.in(param.getSalesOutletsIdS()));
        }
        if (!CollectionUtils.isEmpty(param.getSalesOutletsIds2())) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId.in(param.getSalesOutletsIds2()));
        }
        if (param.getVehicleSource() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSource.eq(param.getVehicleSource()));
        }
        if (param.getSalesOutletsId() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId.eq(param.getSalesOutletsId()));
        }
        if (param.getKeyword() != null) {
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.like("%" + param.getKeyword() + "%").or(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.like("%" + param.getKeyword() + "%")).or(Q_CAR_OWNER_VEHICLE_INFO_DO.userName.like("%" + param.getKeyword() + "%")));
        }
        if(StringUtils.isNotEmpty(param.getCustCode2())){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.custCode2.eq(param.getCustCode2()));
        }
        if(StringUtils.isNotEmpty(param.getSalesOutletsRegion())){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsRegion.eq(param.getSalesOutletsRegion()));
        }
        if(StringUtils.isNotEmpty(param.getCustName())){
            predicate = ExpressionUtils.and(predicate, Q_CAR_OWNER_VEHICLE_INFO_DO.custName.eq(param.getCustName()));
        }
        return predicate;
    }


    public CarAndVehicleVO findByVehicleNo(String vehicleNo, String phone) {

        JPAQuery<CarAndVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                CarAndVehicleVO.class,
                Q_CAR_OWNER_VEHICLE_INFO_DO.id,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone
        )).from(Q_CAR_OWNER_VEHICLE_INFO_DO)

                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.eq(vehicleNo))
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(phone))
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(0));
        return jpaQuery.fetchOne();
    }

    public List<CarOwnerVehicleInfoDO> bindVehicleQuery2(BindSoldVehicleParam param) {
        Iterable<CarOwnerVehicleInfoDO> all = carOwnerVehicleRepo.findAll(whereParam(param));
        if (!IterUtil.isEmpty(all)) {
            return Lists.newArrayList(all);
        }
        return null;

    }


    public void updateCarowner(CarOwnerInfoDO carOwnerInfoDO) {

        if (StringUtils.isBlank(carOwnerInfoDO.getUserPhone())) {
            return;
        }
        if (StringUtils.isBlank(carOwnerInfoDO.getUserName())) {
            return;
        }
        jpaQueryFactory.update(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .set(Q_CAR_OWNER_VEHICLE_INFO_DO.userName, carOwnerInfoDO.getUserName())
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(carOwnerInfoDO.getUserPhone()))
                .execute();

    }

    public List<CarOwnerVehicleInfoVO> findCarByUserPhone(String phone) {

        if (StringUtils.isBlank(phone)) {
            return new ArrayList<>();
        }
        List<CarOwnerVehicleInfoVO> res = jpaQueryFactory.select(Projections.bean(
                CarOwnerVehicleInfoVO.class,
                Q_CAR_OWNER_VEHICLE_INFO_DO.id,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleType,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleColor,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSpecs,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSource,
                Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime,
                Q_CAR_OWNER_VEHICLE_INFO_DO.purchaseTime,
                Q_CAR_OWNER_VEHICLE_INFO_DO.brandName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId,
                Q_CAR_OWNER_VEHICLE_INFO_DO.maintainCardNo,
                Q_CAR_OWNER_VEHICLE_INFO_DO.manufactureDate,
                Q_CAR_OWNER_VEHICLE_INFO_DO.userArea,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleBuyPrice,
                Q_CAR_OWNER_VEHICLE_INFO_DO.remark))

                .from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(phone))
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public PagingVO<CarOwnerVehicleInfoVO> findCarByUserPhonePage(CarOwnerVehiclePhonePageParam param) {
        JPAQuery<CarOwnerVehicleInfoVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                        CarOwnerVehicleInfoVO.class,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.id,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.userName,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleType,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleColor,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSpecs,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleSource,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.purchaseTime,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.brandName,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsName,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.maintainCardNo,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.manufactureDate,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.userArea,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleBuyPrice,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.remark))
                .from(Q_CAR_OWNER_VEHICLE_INFO_DO);
        if (Objects.nonNull(param)) {
            jpaQuery.where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(param.getUserPhone()))
                            .where(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(0));
            param.fillOrders(jpaQuery, Q_CAR_OWNER_VEHICLE_INFO_DO);
            param.setPaging(jpaQuery);
        }
        return PagingVO.<CarOwnerVehicleInfoVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }


    public int existByPhoneAId(String userPhone, String userIdcard) {
        int res = 0;
        if(userIdcard != null) {
            res = jpaQueryFactory.select(Q_CAR_OWNER_VEHICLE_INFO_DO.id)
                    .from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                    .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userIdCard.eq(userIdcard))
                    .where(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(0))
                    .fetch().size();
            if(res > 0) return res;
        }
        if(userPhone != null) {
            res = jpaQueryFactory.select(Q_CAR_OWNER_VEHICLE_INFO_DO.id)
                    .from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                    .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(userPhone))
                    .where(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(0))
                    .fetch().size();
        }
        return res;
    }

    public int existBy(String userPhone, String vehicleNo) {
        int res = jpaQueryFactory.select(Q_CAR_OWNER_VEHICLE_INFO_DO.id)
                .from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(userPhone))
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.eq(vehicleNo))
                .fetch().size();

        return res;
    }

    public List<Long> getByNo(String vehicleNo) {
        List<Long> res = jpaQueryFactory.select(Q_CAR_OWNER_VEHICLE_INFO_DO.id)
                .from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.eq(vehicleNo))
                .fetch();
        return res;

    }

    public List<String> findBySaleOutsIds(List<Long> sids) {
        List<String> res = jpaQueryFactory.select(Q_CAR_MAINTAIN_CARD_DO.vehicleNo)
                .from(Q_CAR_MAINTAIN_CARD_DO)
                .where(Q_CAR_MAINTAIN_CARD_DO.salesOutletsId.in(sids))
                .fetch();

        return res;

    }

    public void updateActivatFlag(String userPhone, String vehicleNo, boolean b) {
        jpaQueryFactory.update(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .set(Q_CAR_OWNER_VEHICLE_INFO_DO.activatFlag, b)
                .set(Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime, LocalDateTime.now())
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.eq(vehicleNo))
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.userPhone.eq(userPhone))
                .execute();

    }

    public CarOwnerVehicleInfoVO getByVerNo(String vehicleNo) {

        CarOwnerVehicleInfoVO carOwnerVehicleInfoVO = jpaQueryFactory.select(
                Projections.bean(
                        CarOwnerVehicleInfoVO.class,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsName,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsId,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleType,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleColor,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.itemCode,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.manufactureDate,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.activatTime
                )
        ).from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.eq(vehicleNo))
                .limit(1)
                .fetchOne();

        return carOwnerVehicleInfoVO;
    }

    public List<BindSoldVehicleVO> findCustByVehicleNo(List<String> vehicleNoList) {
        JPAQuery<BindSoldVehicleVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                BindSoldVehicleVO.class,
                Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo,
                Q_CAR_OWNER_VEHICLE_INFO_DO.custCode2,
                Q_CAR_OWNER_VEHICLE_INFO_DO.custName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsRegionName,
                Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode
        )).from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleNo.in(vehicleNoList));
        return jpaQuery.fetch();
    }

    public List<CarOwnerVehicleInfoVO> findAllByStoreCode(List<String> codes) {
        List<Predicate> predicate = new ArrayList<>();
        if (CollUtil.isNotEmpty(codes)){
            predicate.add(Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode.in(codes));
        }
        predicate.add(Q_CAR_OWNER_VEHICLE_INFO_DO.id.in(JPAExpressions
                .select(Q_CAR_OWNER_VEHICLE_INFO_DO.id.max().as("id"))
                .from(Q_CAR_OWNER_VEHICLE_INFO_DO).groupBy(Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode)));
        JPAQuery<CarOwnerVehicleInfoVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                        CarOwnerVehicleInfoVO.class,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode,
                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesmanName
                )).from(Q_CAR_OWNER_VEHICLE_INFO_DO)
                .where(ExpressionUtils.allOf(predicate));
        return jpaQuery.fetch();
    }


//    public List<VehicleSaleStatisticsVO> vehicleSaleStatistics(AfterSaleVehicleDTO afterSaleVehicleDTO) {
//        List<VehicleSaleStatisticsVO> saleNums = jpaQueryFactory
//                .select(Projections.bean(
//                        VehicleSaleStatisticsVO.class,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsCode,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsName,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.custCode,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.custCode2,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.custName,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesOutletsRegionName,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.salesmanName,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.vehicleType,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime,
//                        Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag
//
//                ))
//                .from(Q_CAR_OWNER_VEHICLE_INFO_DO)
//                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime.goe(afterSaleVehicleDTO.getStartTime()))
//                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.bindingTime.loe(afterSaleVehicleDTO.getEndTime()))
//                .where(Q_CAR_OWNER_VEHICLE_INFO_DO.deleteFlag.eq(1))
//                .fetch();
//
//
//        return saleNums;
//    }
}
