package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.OrderEvaluationDO;
import com.elitesland.yst.production.aftersale.model.entity.QComplaintOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.QOrderEvaluationDO;
import com.elitesland.yst.production.aftersale.model.entity.QRepairOrderDO;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @author RYH
 * @date 2023/2/14
 */
@Repository
public class OrderEvaluationRepoProc extends BaseRepoProc<OrderEvaluationDO> {
    private static final QOrderEvaluationDO Q_ORDER_EVALUATION_DO = QOrderEvaluationDO.orderEvaluationDO;
    private static final QComplaintOrderDO Q_COMPLAINT_ORDER_DO = QComplaintOrderDO.complaintOrderDO;
    private static final QRepairOrderDO Q_REPAIR_ORDER_DO = QRepairOrderDO.repairOrderDO;

    protected OrderEvaluationRepoProc() {
        super(Q_ORDER_EVALUATION_DO);
    }

    public OrderEvaluationVO query(OrderEvaluationParam queryDTO) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(queryDTO.getId() != null, Q_ORDER_EVALUATION_DO.id, queryDTO.getId())
                .andEq(queryDTO.getOrderId() != null, Q_ORDER_EVALUATION_DO.orderId, queryDTO.getOrderId())
                .andEq(queryDTO.getOrderType() != null, Q_ORDER_EVALUATION_DO.orderType, queryDTO.getOrderType())
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_ORDER_EVALUATION_DO)
                .where(predicate)
                .limit(1L)
                .fetchOne();
    }

    public List<OrderEvaluationVO> queryList(OrderEvaluationParam param) {
        Predicate predicate = PredicateBuilder.builder()
                .andIn(param.getOrderIdList() != null, Q_ORDER_EVALUATION_DO.orderId, param.getOrderIdList())
                .andEq(param.getOrderType() != null, Q_ORDER_EVALUATION_DO.orderType, param.getOrderType())
                .build();
        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_ORDER_EVALUATION_DO)
                .where(predicate)
                .fetch();
    }


    private QBean<OrderEvaluationVO> fieldsOfYstDemoDTO() {
        return Projections.bean(OrderEvaluationVO.class,
                Q_ORDER_EVALUATION_DO.id,
                Q_ORDER_EVALUATION_DO.updater,
                Q_ORDER_EVALUATION_DO.secUserId,
                Q_ORDER_EVALUATION_DO.secBuId,
                Q_ORDER_EVALUATION_DO.secOuId,
                Q_ORDER_EVALUATION_DO.deleteFlag,
                Q_ORDER_EVALUATION_DO.creator,
                Q_ORDER_EVALUATION_DO.createTime,
                Q_ORDER_EVALUATION_DO.createUserId,
                Q_ORDER_EVALUATION_DO.evaluationContent,
                Q_ORDER_EVALUATION_DO.evaluationLevel,
                Q_ORDER_EVALUATION_DO.returnAdvice,
                Q_ORDER_EVALUATION_DO.returnReply,
                Q_ORDER_EVALUATION_DO.returnLevel,
                Q_ORDER_EVALUATION_DO.orderId,
                Q_ORDER_EVALUATION_DO.orderType,
                Q_ORDER_EVALUATION_DO.modifyTime
        );
    }

    public void deleteOrderEvaluation(List<Long> ids) {
        Predicate predicate = Q_ORDER_EVALUATION_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_ORDER_EVALUATION_DO);
        jpaUpdateClause.set(Q_ORDER_EVALUATION_DO.deleteFlag, 1);
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.id.in(ids)));
        jpaUpdateClause.execute();
    }

    public void solve(OrderEvaluationParam saveVO) {
        Predicate predicate = Q_ORDER_EVALUATION_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_ORDER_EVALUATION_DO);
        if(saveVO.getReturnLevel() != null){
            jpaUpdateClause.set(Q_ORDER_EVALUATION_DO.returnLevel, saveVO.getReturnLevel());
        }
        if(saveVO.getReturnAdvice() != null){
            jpaUpdateClause.set(Q_ORDER_EVALUATION_DO.returnAdvice, saveVO.getReturnAdvice());
        }
        if(saveVO.getReturnReply() != null){
            jpaUpdateClause.set(Q_ORDER_EVALUATION_DO.returnReply, saveVO.getReturnReply());
        }
        jpaUpdateClause.where(ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.id.eq(saveVO.getId())));
        jpaUpdateClause.execute();
    }

    public PagingVO<OrderEvaluationVO> complaintPageQuery(OrderEvaluationPageParam param) {
        Predicate onCondition = Q_ORDER_EVALUATION_DO.orderId.eq(Q_COMPLAINT_ORDER_DO.id);
        Predicate predicate = Q_ORDER_EVALUATION_DO.orderType.eq(param.getOrderType());
        if(!StringUtils.isEmpty(param.getComplaintType())){
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderType.eq(param.getComplaintType()));
        }
        if(!StringUtils.isEmpty(param.getOrderNo())){
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderNo.like("%" + param.getOrderNo() + "%"));
        }
        if(!StringUtils.isEmpty(param.getOrderTel())){
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderTel.like("%" + param.getOrderTel() + "%"));
        }
        if(!StringUtils.isEmpty(param.getOrderPerson())){
            predicate = ExpressionUtils.and(predicate, Q_COMPLAINT_ORDER_DO.orderPerson.like("%" + param.getOrderPerson() + "%"));
        }
        if (param.getStartTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.createTime.after(param.getStartTime()));
        }
        if (param.getEndTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.createTime.before(param.getEndTime()));
        }
        if(!StringUtils.isEmpty(param.getEvaluationLevel())){
            predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.evaluationLevel.eq(param.getEvaluationLevel()));
        }
        if(!StringUtils.isEmpty(param.getReturnStatus())){
            if("1".equals(param.getReturnStatus())) {
                predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.returnLevel.isNotNull());
            }else if("0".equals(param.getReturnStatus())){
                predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.returnLevel.isNull());
            }
        }

        JPAQuery<OrderEvaluationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                OrderEvaluationVO.class,
                Q_ORDER_EVALUATION_DO.id,
                Q_ORDER_EVALUATION_DO.orderType,
                Q_ORDER_EVALUATION_DO.evaluationLevel,
                Q_ORDER_EVALUATION_DO.evaluationContent,
                Q_ORDER_EVALUATION_DO.createTime,
                Q_ORDER_EVALUATION_DO.returnLevel,
                Q_ORDER_EVALUATION_DO.returnAdvice,
                Q_ORDER_EVALUATION_DO.returnReply,
                Q_COMPLAINT_ORDER_DO.id.as("orderId"),
                Q_COMPLAINT_ORDER_DO.orderNo,
                Q_COMPLAINT_ORDER_DO.orderTel,
                Q_COMPLAINT_ORDER_DO.orderPerson,
                Q_COMPLAINT_ORDER_DO.issueDescription,
                Q_COMPLAINT_ORDER_DO.orderType.as("complaintType")
        )).from(Q_ORDER_EVALUATION_DO).leftJoin(Q_COMPLAINT_ORDER_DO).on(onCondition);
        jpaQuery.where(predicate);
        param.fillOrders(jpaQuery, Q_ORDER_EVALUATION_DO);
        param.setPaging(jpaQuery);

        jpaQuery.where(Q_ORDER_EVALUATION_DO.deleteFlag.eq(0).or(Q_ORDER_EVALUATION_DO.deleteFlag.isNull()));

        return PagingVO.<OrderEvaluationVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<OrderEvaluationVO> repairPageQuery(OrderEvaluationPageParam param) {
        Predicate onCondition = Q_ORDER_EVALUATION_DO.orderId.eq(Q_REPAIR_ORDER_DO.id);
        Predicate predicate = Q_ORDER_EVALUATION_DO.orderType.eq(param.getOrderType());
        if(!StringUtils.isEmpty(param.getOrderNo())){
            predicate = ExpressionUtils.and(predicate, Q_REPAIR_ORDER_DO.orderNo.like("%" + param.getOrderNo() + "%"));
        }
        if(!StringUtils.isEmpty(param.getOrderTel())){
            predicate = ExpressionUtils.and(predicate, Q_REPAIR_ORDER_DO.orderTel.like("%" + param.getOrderTel() + "%"));
        }
        if(!StringUtils.isEmpty(param.getOrderPerson())){
            predicate = ExpressionUtils.and(predicate, Q_REPAIR_ORDER_DO.orderPerson.like("%" + param.getOrderPerson() + "%"));
        }
        if(!StringUtils.isEmpty(param.getRepairStoreName())){
            predicate = ExpressionUtils.and(predicate, Q_REPAIR_ORDER_DO.repairStoreName.like("%" + param.getRepairStoreName() + "%"));
        }
        if(param.getStoreIds() != null && !param.getStoreIds().isEmpty()){
            predicate = ExpressionUtils.and(predicate, Q_REPAIR_ORDER_DO.repairStoreId.in(param.getStoreIds()));
        }
        if (param.getStartTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.createTime.after(param.getStartTime()));
        }
        if (param.getEndTime() != null) {
            predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.createTime.before(param.getEndTime()));
        }
        if(!StringUtils.isEmpty(param.getEvaluationLevel())){
            predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.evaluationLevel.eq(param.getEvaluationLevel()));
        }
        if(!StringUtils.isEmpty(param.getReturnStatus())){
            if("1".equals(param.getReturnStatus())) {
                predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.returnLevel.isNotNull());
            }else if("0".equals(param.getReturnStatus())){
                predicate = ExpressionUtils.and(predicate, Q_ORDER_EVALUATION_DO.returnLevel.isNull());
            }
        }

        JPAQuery<OrderEvaluationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(
                OrderEvaluationVO.class,
                Q_ORDER_EVALUATION_DO.id,
                Q_ORDER_EVALUATION_DO.orderType,
                Q_ORDER_EVALUATION_DO.evaluationLevel,
                Q_ORDER_EVALUATION_DO.evaluationContent,
                Q_ORDER_EVALUATION_DO.createTime,
                Q_ORDER_EVALUATION_DO.returnLevel,
                Q_ORDER_EVALUATION_DO.returnAdvice,
                Q_ORDER_EVALUATION_DO.returnReply,
                Q_REPAIR_ORDER_DO.id.as("orderId"),
                Q_REPAIR_ORDER_DO.orderNo,
                Q_REPAIR_ORDER_DO.orderTel,
                Q_REPAIR_ORDER_DO.orderPerson,
                Q_REPAIR_ORDER_DO.repairStoreId,
                Q_REPAIR_ORDER_DO.repairStoreName
        )).from(Q_ORDER_EVALUATION_DO).leftJoin(Q_REPAIR_ORDER_DO).on(onCondition);
        jpaQuery.where(predicate);
        param.fillOrders(jpaQuery, Q_ORDER_EVALUATION_DO);
        param.setPaging(jpaQuery);

        jpaQuery.where(Q_ORDER_EVALUATION_DO.deleteFlag.eq(0).or(Q_ORDER_EVALUATION_DO.deleteFlag.isNull()));

        return PagingVO.<OrderEvaluationVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }


}
