/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.util.AsyncExcelUtils;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pc/threePackage"}, produces={"application/json"})
@Validated
@Api(value="\u4e09\u5305", tags={"\u4e09\u5305"})
public class MaintainCardController {
    @Autowired
    private MaintainCardService maintainCardService;
    @Autowired
    private ExportExcelService<CarOwnerMaintainCardPageParam, CarMaintainCardVO, Serializable> exportExcelService;

    @PostMapping(value={"/activateThreePackage"})
    @ApiOperation(value="\u4e09\u5305\u6fc0\u6d3b")
    public ApiResult<Object> activateThreePackage(@RequestBody @Valid CarMaintainCardParam carMaintainCardParam) {
        carMaintainCardParam.setSourcePlatform("PC");
        ApiResult<Object> activate = this.maintainCardService.activate(carMaintainCardParam);
        return activate;
    }

    @PostMapping(value={"/threePackageQuery"})
    @ApiOperation(value="\u4e09\u5305\u67e5\u8be2")
    public ApiResult<Object> threePackageQuery(@RequestBody CarOwnerMaintainCardParam car) {
        ApiResult<Object> query = this.maintainCardService.query(car.getCarOwnerId(), car.getPage(), car.getPageSize());
        return query;
    }

    @PostMapping(value={"/threePackageQueryById"})
    @ApiOperation(value="\u901a\u8fc7\u8f66\u67b6\u53f7\u67e5\u8be2\u4e09\u5305\u4fe1\u606f")
    public ApiResult<CarMaintainCardVO> threePackageQueryById(@RequestBody CarMaintainCardParam car) {
        ApiResult<CarMaintainCardVO> query = this.maintainCardService.queryById(car.getVehicleNo());
        return query;
    }

    @PostMapping(value={"/activateThreePackage2"})
    @ApiOperation(value="\u4e09\u5305\u6fc0\u6d3b-\u7ed1\u5b9a\u8f66\u8f86")
    public ApiResult<Object> activateThreePackage2(@RequestBody @Valid CarOwnerVehicleParam carOwnerVehicleParam) {
        if (null == carOwnerVehicleParam.getCarOwnerId()) {
            throw new BusinessException("carOwnerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        carOwnerVehicleParam.setActivatFlag(true);
        carOwnerVehicleParam.setActivatTime(LocalDateTime.now());
        Boolean res = null;
        try {
            res = this.maintainCardService.activateThreePackage2(carOwnerVehicleParam, "PC");
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u4e09\u5305\u67e5\u8be2\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO> page(@RequestBody CarOwnerMaintainCardPageParam car) {
        PagingVO<CarMaintainCardVO> res = this.maintainCardService.page(car);
        return ApiResult.ok(res);
    }

    @PostMapping(value={"/pageSaleMan"})
    @ApiOperation(value="\u4e09\u5305\u67e5\u8be2\u5206\u9875\u67e5\u8be2(\u4e1a\u52a1)")
    public ApiResult<PagingVO> pageSaleMan(@RequestBody CarOwnerMaintainCardPageParam car) {
        PagingVO<CarMaintainCardVO> res = this.maintainCardService.pageSaleMan(car);
        return ApiResult.ok(res);
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u8be6\u60c5-\u8f66\u8f86\u4e09\u5305\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    public ApiResult<CarMaintainCardVO> get(@PathVariable Long id) {
        CarMaintainCardVO res = this.maintainCardService.get(id);
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664-\u6839\u636e\u8f66\u67b6\u53f7\u5220\u9664\u8be5\u8f66\u8f86\u4e0b\u4e09\u5305\u4fe1\u606f\u548c\u6240\u6709\u7ed1\u5b9a\u5173\u7cfb")
    public ApiResult<Boolean> del(@RequestBody List<String> vehicleNos) {
        Boolean res = this.maintainCardService.delAllByVehicleNo(vehicleNos);
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"/export"}, produces={"application/octet-stream"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u5bfc\u51fa\u6570\u636e")
    public ApiResult<?> export(HttpServletResponse response, @RequestBody CarOwnerMaintainCardPageParam queryVO) {
        try {
            AsyncExcelUtils.export(response, "\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u5bfc\u51fa\u6570\u636e", AsyncExcelUtils.buildExportColumn(CarMaintainCardVO.class), this.maintainCardService::page, queryVO);
            return null;
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @PostMapping(value={"/exportSaleMan"}, produces={"application/octet-stream"})
    @ApiOperation(value="\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u5bfc\u51fa\u6570\u636e(\u4e1a\u52a1)")
    public ApiResult<?> exportSaleMan(HttpServletResponse response, @RequestBody CarOwnerMaintainCardPageParam queryVO) {
        try {
            AsyncExcelUtils.export(response, "\u8f66\u4e3b\u4fe1\u606f\u7ba1\u7406\u5bfc\u51fa\u6570\u636e(\u4e1a\u52a1)", AsyncExcelUtils.buildExportColumn(CarMaintainCardVO.class), this.maintainCardService::pageSaleMan, queryVO);
            return null;
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

