/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.yst.production.aftersale.convert.ComplaintSetConvert;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.model.entity.ComplaintSetDO;
import com.elitesland.yst.production.aftersale.model.param.BusinessComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.elitesland.yst.production.aftersale.service.ComplaintSetService;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepo;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepoProc;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ComplaintSetServiceImpl
implements ComplaintSetService {
    private static final Logger log = LogManager.getLogger(ComplaintSetServiceImpl.class);
    @Autowired
    private ComplaintSetRepo complaintSetRepo;
    @Autowired
    private ComplaintSetRepoProc complaintSetRepoProc;
    @Autowired
    private SeqNumProvider seqNumProvider;

    @Override
    @SysCodeProc
    public List<ComplaintSetVO> complaintSetQuery(ComplaintSetPageParam complaintSetPageParam) {
        List<ComplaintSetVO> complaintSetList = this.complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);
        return complaintSetList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long complaintSetSave(ComplaintSetParam complaintSetParam) {
        List<ComplaintSetVO> complaintSetList;
        Assert.notBlank((CharSequence)complaintSetParam.getClassifyCode(), (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)complaintSetParam.getClassifyName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (complaintSetParam.getId() == null && !CollUtil.isEmpty(complaintSetList = this.complaintSetRepoProc.complaintSetExist(complaintSetParam))) {
            throw new BusinessException("\u5206\u7c7b\u7f16\u7801\uff0c\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        ComplaintSetDO complaintSetDO = ComplaintSetConvert.INSTANCE.complaintSetSaveVOToDO(complaintSetParam);
        Long id = ((ComplaintSetDO)((Object)this.complaintSetRepo.save((Object)complaintSetDO))).getId();
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintSetDelete(List<Long> ids) {
        this.complaintSetRepoProc.complaintSetDelete(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintSetEnabledToC(String enableFlag) {
        this.complaintSetRepoProc.complaintSetEnabledToC(enableFlag, "3", UdcEnum.BASIC_SET_ENABLE.getValueCode());
    }

    @Override
    public String complaintSetFlagByC(String complaintType) {
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        complaintSetPageParam.setComplaintType(complaintType);
        complaintSetPageParam.setClassifyCode(UdcEnum.BASIC_SET_ENABLE.getValueCode());
        List<ComplaintSetVO> complaintSetList = this.complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);
        if (!CollUtil.isEmpty(complaintSetList)) {
            return complaintSetList.get(0).getEnableFlag();
        }
        ComplaintSetParam complaintSetParam = new ComplaintSetParam();
        complaintSetParam.setClassifyCode(UdcEnum.BASIC_SET_ENABLE.getValueCode());
        complaintSetParam.setClassifyName(UdcEnum.BASIC_SET_ENABLE.getValueCodeName());
        complaintSetParam.setComplaintType("3");
        complaintSetParam.setEnableFlag("1");
        this.complaintSetSave(complaintSetParam);
        return "1";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long basicSetSave(List<ComplaintSetParam> complaintSetParamList) {
        Long id = null;
        if (!CollectionUtils.isEmpty(complaintSetParamList)) {
            for (ComplaintSetParam complaintSetParam : complaintSetParamList) {
                Assert.notBlank((CharSequence)complaintSetParam.getClassifyCode(), (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Assert.notBlank((CharSequence)complaintSetParam.getClassifyName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (complaintSetParam.getComplaintType().equals("3") && !this.isNumeric(complaintSetParam.getMaxHandle())) {
                    throw new BusinessException("\u7cfb\u7edf\u8fdb\u884c\u9ed8\u8ba4\u8bc4\u4ef7\u7684\u6700\u957f\u65f6\u95f4 \u4ec5\u652f\u6301\u6574\u6570\uff01");
                }
                ComplaintSetDO complaintSetDO = ComplaintSetConvert.INSTANCE.complaintSetSaveVOToDO(complaintSetParam);
                id = ((ComplaintSetDO)((Object)this.complaintSetRepo.save((Object)complaintSetDO))).getId();
            }
        }
        return id;
    }

    public boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ComplaintSetVO> businessComplaintSetQueryBase() {
        List<ComplaintSetVO> complaintSetList = this.complaintSetRepoProc.businessComplaintSetQueryBase();
        for (ComplaintSetVO rootCategory : complaintSetList) {
            List<ComplaintSetVO> subCategories = this.businessComplaintSetQuerySub(rootCategory.getId());
            rootCategory.setUnder(subCategories);
            rootCategory.setHasUnder(subCategories != null && !subCategories.isEmpty());
        }
        ComplaintSetVO complaintSetVO = new ComplaintSetVO();
        return complaintSetList;
    }

    @Override
    public List<ComplaintSetVO> businessComplaintSetQuerySub(Long id) {
        List<ComplaintSetVO> complaintSetList = this.complaintSetRepoProc.businessComplaintSetQuerySub(id);
        return complaintSetList;
    }

    private List<ComplaintSetVO> getAllSubCategories(Long pid) {
        List<ComplaintSetVO> categories = this.complaintSetRepoProc.businessComplaintSetQuerySub(pid);
        for (ComplaintSetVO category : categories) {
            List<ComplaintSetVO> subCategories = this.getAllSubCategories(category.getId());
            category.setUnder(subCategories);
            category.setHasUnder(subCategories != null && !subCategories.isEmpty());
        }
        return categories;
    }

    private List<ComplaintSetVO> flattenSubCategories(Long pid) {
        ArrayList<ComplaintSetVO> flatList = new ArrayList<ComplaintSetVO>();
        List<ComplaintSetVO> categories = this.complaintSetRepoProc.businessComplaintSetQuerySub(pid);
        for (ComplaintSetVO category : categories) {
            flatList.add(category);
            flatList.addAll(this.flattenSubCategories(category.getId()));
        }
        return flatList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long businessComplaintSetCreate(BusinessComplaintSetParam businessComplaintSetParam) {
        Assert.notBlank((CharSequence)businessComplaintSetParam.getClassifyName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Assert.notNull((Object)businessComplaintSetParam.getPid(), (String)"\u4e0a\u7ea7id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (this.complaintSetRepo.existsByClassifyNameAndPid(businessComplaintSetParam.getClassifyName(), businessComplaintSetParam.getPid())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.isNumeric(businessComplaintSetParam.getMaxHandle()) || !this.isNumeric(businessComplaintSetParam.getMaxResp())) {
            throw new BusinessException("\u6700\u5927\u54cd\u5e94\u65f6\u95f4\uff0c\u6700\u5927\u5904\u7406\u65f6\u95f4 \u4ec5\u652f\u6301\u6574\u6570\uff01");
        }
        ComplaintSetDO complaintSetDO = ComplaintSetConvert.INSTANCE.businessComplaintSetSaveVOToDO(businessComplaintSetParam);
        complaintSetDO.setClassifyCode(this.seqNumProvider.generateCode("yst-after-sale", "complainSetClsCode", new ArrayList()));
        Long id = ((ComplaintSetDO)((Object)this.complaintSetRepo.save((Object)complaintSetDO))).getId();
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long businessComplaintSetUpdate(BusinessComplaintSetParam businessComplaintSetParam) {
        Assert.notBlank((CharSequence)businessComplaintSetParam.getClassifyName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Assert.notNull((Object)businessComplaintSetParam.getPid(), (String)"\u4e0a\u7ea7id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional optional = this.complaintSetRepo.findById(businessComplaintSetParam.getId());
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u5206\u7c7b\uff1a" + businessComplaintSetParam.getClassifyName());
        }
        if (businessComplaintSetParam.getId() != null) {
            List<ComplaintSetVO> complaintSetVOS = this.flattenSubCategories(businessComplaintSetParam.getId());
            List ids = complaintSetVOS.stream().map(BaseModelVO::getId).collect(Collectors.toList());
            ids.add(businessComplaintSetParam.getId());
            if (ids.contains(businessComplaintSetParam.getPid())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u5141\u8bb8\u5c06\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u5b50\u96c6\u9009\u4e3a\u81ea\u5df1\u7684\u4e0a\u7ea7");
            }
        }
        if (this.complaintSetRepo.existsByClassifyNameAndPidAndIdNot(businessComplaintSetParam.getClassifyName(), businessComplaintSetParam.getPid(), businessComplaintSetParam.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.isNumeric(businessComplaintSetParam.getMaxHandle()) || !this.isNumeric(businessComplaintSetParam.getMaxResp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6700\u5927\u54cd\u5e94\u65f6\u95f4\uff0c\u6700\u5927\u5904\u7406\u65f6\u95f4 \u4ec5\u652f\u6301\u6574\u6570\uff01");
        }
        ComplaintSetDO complaintSetDO = ComplaintSetConvert.INSTANCE.businessComplaintSetSaveVOToDO(businessComplaintSetParam);
        Long id = ((ComplaintSetDO)((Object)this.complaintSetRepo.save((Object)complaintSetDO))).getId();
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void businessComplaintSetDelete(List<Long> ids) {
        List allById = this.complaintSetRepo.findAllById(ids);
        if (CollUtil.isEmpty((Collection)allById)) {
            throw new BusinessException("\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        if (this.complaintSetRepo.existsByPidIn(ids).booleanValue()) {
            throw new BusinessException("\u8be5\u5206\u7c7b\u4e0b\u5b58\u5728\u5b50\u5206\u7c7b\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.complaintSetRepoProc.complaintSetDelete(ids);
    }

    @Override
    public List<ComplaintSetVO> query() {
        List<ComplaintSetDO> complaintSetDOS = this.complaintSetRepo.findByComplaintType("2");
        if (CollUtil.isEmpty(complaintSetDOS)) {
            return Collections.emptyList();
        }
        List<ComplaintSetVO> complaintSetVOs = ComplaintSetConvert.INSTANCE.businessComplaintSetSaveDOToVOs(complaintSetDOS);
        Map<Long, List<ComplaintSetVO>> groupedByParentId = complaintSetVOs.stream().collect(Collectors.groupingBy(ComplaintSetVO::getPid));
        List<ComplaintSetVO> rootCategories = this.buildCategoryTree(0L, groupedByParentId);
        return rootCategories;
    }

    private List<ComplaintSetVO> buildCategoryTree(Long parentId, Map<Long, List<ComplaintSetVO>> groupedByParentId) {
        List<ComplaintSetVO> categories = groupedByParentId.getOrDefault(parentId, Collections.emptyList()).stream().sorted(Comparator.comparing(ComplaintSetVO::getSortNo).reversed()).collect(Collectors.toList());
        for (ComplaintSetVO category : categories) {
            List<ComplaintSetVO> subCategories = this.buildCategoryTree(category.getId(), groupedByParentId);
            if (!subCategories.isEmpty()) {
                category.setUnder(subCategories);
                category.setHasUnder(true);
                continue;
            }
            category.setHasUnder(false);
        }
        return categories;
    }
}

