/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepoProc;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PictureOrderServiceImpl
implements PictureOrderService {
    private static final Logger log = LogManager.getLogger(PictureOrderServiceImpl.class);
    @Autowired
    private PictureOrderRepoProc pictureOrderRepoProc;
    @Autowired
    private SystemService systemService;

    @Override
    @SysCodeProc
    public ApiResult<List<PictureOrderVO>> query(PictureOrderParam queryDTO) {
        List<PictureOrderVO> pictureOrderVOS = this.pictureOrderRepoProc.query(queryDTO);
        this.udcTranslate(pictureOrderVOS);
        return ApiResult.ok(pictureOrderVOS);
    }

    public void udcTranslate(List<PictureOrderVO> pictureOrderVOS) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.PICTURE_ORDER_TYPE_2.getModel(), UdcEnum.PICTURE_ORDER_TYPE_2.getCode());
        pictureOrderVOS.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(t.getOrderType())) {
                t.setOrderTypeName((String)ajStatusMap.get(t.getOrderType()));
            }
        });
    }
}

