/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.search.service.impl;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.yst.production.aftersale.convert.ComplaintOrderConvert;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.search.bean.BasicsBean;
import com.elitesland.yst.production.aftersale.search.bean.ComplaintOrderAndOrderEvaluationSearchBean;
import com.elitesland.yst.production.aftersale.search.bean.ComplaintOrderSearchBean;
import com.elitesland.yst.production.aftersale.search.service.ComplaintOrderSearchBeanService;
import com.elitesland.yst.production.aftersale.search.service.SearchBeanService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepoProc;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.order.rpc.LmVehicleNoRpcService;
import com.elitesland.yst.production.order.rpc.param.LmAfterSaleTimeParam;
import com.elitesland.yst.production.order.rpc.param.resp.LmVehicleNoTimeDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ComplaintOrderSearchBeanServiceImpl
implements ComplaintOrderSearchBeanService {
    private static final Logger log = LogManager.getLogger(ComplaintOrderSearchBeanServiceImpl.class);
    private final SearchBeanService searchBeanService;
    @Autowired
    private PictureOrderService pictureOrderService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private OrderEvaluationService orderEvaluationService;
    @Autowired
    private UserService userService;
    @Autowired
    private ComplaintSetRepoProc complaintSetRepoProc;
    @Autowired
    private LmVehicleNoRpcService vehicleNoRpcService;
    @Value(value="${file.upload.url}")
    private String pictureURL;
    private static final String SYSTEM_ROLE_CODE = "ROLE_admin";
    private final JdbcTemplate jdbcTemplate;

    @Override
    public PagingVO<ComplaintOrderVO> query(ComplaintOrderPageParam param) {
        Long userId = this.userService.getUserId();
        PagingVO<ComplaintOrderVO> complaintOrderVOS = null;
        if (UdcEnum.COMPLAINT_ORDER_KSS005.getValueCode().equals(param.getOrderStatus())) {
            param.setOrderStatus(UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
            complaintOrderVOS = this.unEvaluationQuery(param);
        } else {
            complaintOrderVOS = this.evaluationQuery(param);
        }
        this.docTimeQuery(complaintOrderVOS, param);
        this.pictureQuery(complaintOrderVOS.getRecords());
        this.evaluationQuery(complaintOrderVOS.getRecords());
        this.setQueryAll(complaintOrderVOS.getRecords());
        this.udcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    @Override
    public PagingVO<ComplaintOrderVO> export(ComplaintOrderExlParam complaintOrderExlParam) {
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setOrderType(complaintOrderExlParam.getOrderType());
        complaintOrderPageParam.setIdList(complaintOrderExlParam.getIdList());
        complaintOrderPageParam.setOrderNo(complaintOrderExlParam.getOrderNo());
        complaintOrderPageParam.setOrderStatus(complaintOrderExlParam.getOrderStatus());
        complaintOrderPageParam.setOrderTel(complaintOrderExlParam.getOrderTel());
        complaintOrderPageParam.setOrderPerson(complaintOrderExlParam.getOrderPerson());
        complaintOrderPageParam.setIssueType(complaintOrderExlParam.getIssueType());
        complaintOrderPageParam.setStartTime(complaintOrderExlParam.getStartTime());
        complaintOrderPageParam.setEndTime(complaintOrderExlParam.getEndTime());
        complaintOrderPageParam.setCurrent(complaintOrderExlParam.getCurrent() + 1);
        complaintOrderPageParam.setSize(complaintOrderExlParam.getSize());
        complaintOrderPageParam.setOrders(complaintOrderExlParam.getOrders());
        PagingVO<ComplaintOrderVO> complaintOrderVOS = this.exportQuery(complaintOrderPageParam);
        this.setQuery(complaintOrderVOS.getRecords());
        complaintOrderVOS.getRecords().forEach(x -> {
            if (StringUtils.isNotEmpty((CharSequence)x.getEvaluationLevel())) {
                x.setEvaluationStatus("\u5df2\u8bc4\u4ef7");
            } else {
                x.setEvaluationStatus("\u5f85\u8bc4\u4ef7");
            }
            x.setFeedbackPerson(x.getOrderPerson());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(x.getOrderType())) {
                x.setSource("\u8f66\u4e3b");
            }
            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(x.getOrderType())) {
                x.setSource("\u7ecf\u9500\u5546");
            }
        });
        this.udcTranslate(complaintOrderVOS.getRecords());
        this.evaluationUdcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    private PagingVO<ComplaintOrderVO> exportQuery(ComplaintOrderPageParam param) {
        MapBuilder whereSqlMapBuilder = this.setMapBuilder(param);
        this.setParamsOrderBy(param.getOrders(), whereSqlMapBuilder);
        SearchResult searchResult = this.searchBeanService.getBeanSearcher().search(ComplaintOrderAndOrderEvaluationSearchBean.class, whereSqlMapBuilder.build());
        PagingVO complaintOrderVOPagingVO = new PagingVO();
        complaintOrderVOPagingVO.setRecords(searchResult.getDataList().stream().map(ComplaintOrderConvert.INSTANCE::searchBeanToRespVO).collect(Collectors.toList()));
        complaintOrderVOPagingVO.setTotal(searchResult.getTotalCount().longValue());
        return complaintOrderVOPagingVO;
    }

    public void evaluationUdcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_LEVEL_1.getModel(), UdcEnum.EVALUATION_LEVEL_1.getCode());
        Map<String, String> ajStatusMap2 = this.systemService.sysUdcGetCodeMap(UdcEnum.RETURN_LEVEL_1.getModel(), UdcEnum.RETURN_LEVEL_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(t.getEvaluationLevel())) {
                t.setEvaluationLevelName((String)ajStatusMap.get(t.getEvaluationLevel()));
            }
            if (!CollectionUtils.isEmpty((Map)ajStatusMap2) && ajStatusMap2.containsKey(t.getEvaluationLevel())) {
                t.setReturnLevelName((String)ajStatusMap2.get(t.getReturnLevel()));
            }
        });
    }

    @Override
    public PagingVO<ComplaintOrderVO> unEvaluationQuery(ComplaintOrderPageParam param) {
        MapBuilder whereSqlMapBuilder = this.setMapBuilder(param);
        ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, new FieldFns.FieldFn[0])).op((FieldOp)FieldOps.IsNull);
        this.setParamsOrderBy(param.getOrders(), whereSqlMapBuilder);
        SearchResult searchResult = this.searchBeanService.getBeanSearcher().search(ComplaintOrderAndOrderEvaluationSearchBean.class, whereSqlMapBuilder.build());
        PagingVO complaintOrderVOPagingVO = new PagingVO();
        complaintOrderVOPagingVO.setRecords(searchResult.getDataList().stream().map(ComplaintOrderConvert.INSTANCE::searchBeanToRespVO).collect(Collectors.toList()));
        complaintOrderVOPagingVO.setTotal(searchResult.getTotalCount().longValue());
        return complaintOrderVOPagingVO;
    }

    @Override
    public PagingVO<ComplaintOrderVO> evaluationQuery(ComplaintOrderPageParam param) {
        MapBuilder whereSqlMapBuilder = this.setMapBuilder(param);
        this.setParamsOrderBy(param.getOrders(), whereSqlMapBuilder);
        SearchResult searchResult = this.searchBeanService.getBeanSearcher().search(ComplaintOrderSearchBean.class, whereSqlMapBuilder.build());
        PagingVO complaintOrderVOPagingVO = new PagingVO();
        complaintOrderVOPagingVO.setRecords(searchResult.getDataList().stream().map(ComplaintOrderConvert.INSTANCE::searchBeanToRespVO).collect(Collectors.toList()));
        complaintOrderVOPagingVO.setTotal(searchResult.getTotalCount().longValue());
        return complaintOrderVOPagingVO;
    }

    public PagingVO<ComplaintOrderVO> docTimeQuery(PagingVO<ComplaintOrderVO> complaintOrderVOS, ComplaintOrderPageParam param) {
        List dtos;
        List vehicles = complaintOrderVOS.stream().map(ComplaintOrderVO::getVehicleNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (vehicles.isEmpty()) {
            return complaintOrderVOS;
        }
        HashMap<String, LmVehicleNoTimeDTO> vehicleInfoMap = new HashMap<String, LmVehicleNoTimeDTO>();
        LmAfterSaleTimeParam lmAfterSaleTimeParam = new LmAfterSaleTimeParam();
        lmAfterSaleTimeParam.setVehicles(vehicles);
        ApiResult docTimeByListVehicles = this.vehicleNoRpcService.getDocTimeByListVehicles(lmAfterSaleTimeParam);
        if (docTimeByListVehicles != null && (dtos = (List)docTimeByListVehicles.getData()) != null) {
            for (LmVehicleNoTimeDTO dto : dtos) {
                vehicleInfoMap.put(dto.getVehicleNo(), dto);
            }
        }
        complaintOrderVOS.getRecords().forEach(x -> {
            String vehicleNo = x.getVehicleNo();
            LmVehicleNoTimeDTO vehicleNoInfo = (LmVehicleNoTimeDTO)vehicleInfoMap.get(vehicleNo);
            if (vehicleNoInfo != null) {
                x.setDocTime(vehicleNoInfo.getDocTime());
                x.setManufactureDate(vehicleNoInfo.getOfflineTime());
                x.setItemCode(vehicleNoInfo.getItemCode());
            }
        });
        return complaintOrderVOS;
    }

    public void pictureQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(BaseModelVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(collect);
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
        }
        complaintOrderVOS.stream().forEach(t -> {
            List respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
            t.setPictureOrderVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
            t.setCompletePictureVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
        });
    }

    public void evaluationQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(BaseModelVO::getId).collect(Collectors.toList());
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderIdList(collect);
        orderEvaluationParam.setOrderType(UdcEnum.EVALUATION_ORDER_TYPE_2.getValueCode());
        List<OrderEvaluationVO> data = this.orderEvaluationService.queryList(orderEvaluationParam);
        complaintOrderVOS.forEach(t -> {
            List evaluationVOList = data.stream().filter(item -> item.getOrderId().equals(t.getId())).collect(Collectors.toList());
            if (!evaluationVOList.isEmpty()) {
                t.setOrderEvaluationVO((OrderEvaluationVO)evaluationVOList.get(0));
            }
        });
    }

    public void setQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        if (complaintOrderVOS.isEmpty()) {
            return;
        }
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        List<ComplaintSetVO> complaintSetVOS = this.complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);
        complaintOrderVOS.forEach(t -> complaintSetVOS.forEach(set -> {
            List<ComplaintSetVO> complaintOrders;
            if (t.getIssueType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null && String.valueOf(set.getId()).equals(t.getIssueType()) && set.getComplaintType().equals(t.getOrderType())) {
                complaintOrders = this.getAllItems(complaintSetVOS, set.getId());
                t.setIssueTypeName(this.getAllClassifyName(complaintOrders));
            }
            if (t.getConfirmType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("2")) {
                    complaintOrders = this.getAllItems(complaintSetVOS, set.getId());
                    t.setConfirmTypeName(this.getAllClassifyName(complaintOrders));
                } else if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("1")) {
                    t.setConfirmTypeName(set.getClassifyName());
                }
            }
        }));
    }

    public void setQueryAll(List<ComplaintOrderVO> complaintOrderVOS) {
        if (complaintOrderVOS.isEmpty()) {
            return;
        }
        String sql = "SELECT * FROM complaint_set";
        List complaintSetVOS = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(ComplaintSetVO.class));
        complaintOrderVOS.forEach(t -> complaintSetVOS.forEach(set -> {
            List<ComplaintSetVO> complaintOrders;
            if (t.getIssueType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null && String.valueOf(set.getId()).equals(t.getIssueType()) && set.getComplaintType().equals(t.getOrderType())) {
                complaintOrders = this.getAllItems(complaintSetVOS, set.getId());
                t.setIssueTypeName(this.getAllClassifyName(complaintOrders));
            }
            if (t.getConfirmType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("2")) {
                    complaintOrders = this.getAllItems(complaintSetVOS, set.getId());
                    t.setConfirmTypeName(this.getAllClassifyName(complaintOrders));
                } else if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("1")) {
                    t.setConfirmTypeName(set.getClassifyName());
                }
            }
        }));
    }

    public List<ComplaintSetVO> getAllItems(List<ComplaintSetVO> complaintSetVOS, Long id) {
        ArrayList<ComplaintSetVO> complaintOrders = new ArrayList<ComplaintSetVO>();
        while (id != 0L) {
            Long finalId = id;
            Optional<ComplaintSetVO> op = complaintSetVOS.stream().filter(x -> x.getId().equals(finalId)).findFirst();
            if (op.isEmpty()) {
                throw new BusinessException("");
            }
            complaintOrders.add(op.get());
            id = op.get().getPid();
        }
        return complaintOrders;
    }

    public String getAllClassifyName(List<ComplaintSetVO> complaintOrders) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = complaintOrders.size() - 1; i >= 0; --i) {
            if (i != 0) {
                stringBuilder.append(complaintOrders.get(i).getClassifyName()).append("->");
                continue;
            }
            stringBuilder.append(complaintOrders.get(i).getClassifyName());
        }
        return stringBuilder.toString();
    }

    public void udcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_ORDER_KSS001.getModel(), UdcEnum.COMPLAINT_ORDER_KSS001.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(t.getOrderStatus())) {
                t.setOrderStatusName((String)ajStatusMap.get(t.getOrderStatus()));
            }
        });
        Map<String, String> ajStatusMap2 = this.systemService.sysUdcGetCodeMap(UdcEnum.TIMEOUT_STATUS_1.getModel(), UdcEnum.TIMEOUT_STATUS_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap2) && ajStatusMap2.containsKey(t.getTimeoutStatus())) {
                t.setTimeoutStatusName((String)ajStatusMap2.get(t.getTimeoutStatus()));
            }
        });
        Map<String, String> ajStatusMap3 = this.systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_TYPE_1.getModel(), UdcEnum.COMPLAINT_TYPE_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap3) && ajStatusMap3.containsKey(t.getOrderType())) {
                t.setOrderTypeName((String)ajStatusMap3.get(t.getOrderType()));
            }
        });
        Map<String, String> ajStatusMap4 = this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap4) && ajStatusMap4.containsKey(t.getCancelReasonC())) {
                t.setCancelReasonCName((String)ajStatusMap4.get(t.getCancelReasonC()));
            }
        });
        Map<String, String> ajStatusMap5 = this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap5) && ajStatusMap5.containsKey(t.getCancelReasonB())) {
                t.setCancelReasonBName((String)ajStatusMap5.get(t.getCancelReasonB()));
            }
        });
    }

    private MapBuilder setMapBuilder(ComplaintOrderPageParam param) {
        MapBuilder whereSqlMapBuilder = MapUtils.builder().page((long)param.getPageRequest().getPageNumber(), param.getPageRequest().getPageSize());
        ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getDeleteFlag, new FieldFns.FieldFn[0])).sql("($1 = ? or $1 is null)", new Object[]{0});
        if (!StringUtils.isEmpty((CharSequence)param.getOrderType())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderType, new Object[]{param.getOrderType()})).op((FieldOp)FieldOps.Equal);
        }
        if (param.getId() != null && param.getId() != 0L) {
            ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, new Object[]{param.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (param.getIdList() != null && !param.getIdList().isEmpty()) {
            ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, param.getIdList())).op((FieldOp)FieldOps.InList);
        }
        if (param.getCarOwnerId() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getCarOwnerId, new Object[]{param.getCarOwnerId()})).op((FieldOp)FieldOps.Equal);
        }
        if (param.getHandlePersonId() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getHandlePersonId, new Object[]{param.getHandlePersonId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderStatus())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderStatus, new Object[]{param.getOrderStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderTel())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderTel, new Object[]{param.getOrderTel()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderPerson())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderPerson, new Object[]{param.getOrderPerson()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getIssueType())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getIssueType, new Object[]{param.getIssueType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getOrderNo())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderNo, new Object[]{param.getOrderNo()})).op((FieldOp)FieldOps.Contain);
        }
        if (param.getStartTime() != null && param.getEndTime() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getCreateTime, new Object[]{param.getStartTime(), param.getEndTime()})).op((FieldOp)FieldOps.Between);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getSearchContent())) {
            String searchContent = "%" + param.getSearchContent() + "%";
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getOrderNo, new Object[]{param.getSearchContent()})).sql("($1 like ? or issue_description like ?)", new Object[]{searchContent, searchContent});
        }
        if (!StringUtils.isEmpty((CharSequence)param.getTimeoutStatus())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getTimeoutStatus, new Object[]{param.getTimeoutStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getVehicleType())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getVehicleType, new Object[]{param.getVehicleType()})).op((FieldOp)FieldOps.Equal);
        }
        if (param.getBindingTimeStart() != null && param.getBindingTimeEnd() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getBindingTime, new Object[]{param.getBindingTimeStart(), param.getBindingTimeEnd()})).op((FieldOp)FieldOps.Between);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getVehicleNo())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getVehicleNo, new Object[]{param.getVehicleNo()})).op((FieldOp)FieldOps.Equal);
        }
        if (param.getActivatTimeStart() != null && param.getActivatTimeEnd() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getActivatTime, new Object[]{param.getActivatTimeStart(), param.getActivatTimeEnd()})).op((FieldOp)FieldOps.Between);
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCustName())) {
            ((MapBuilder)whereSqlMapBuilder.field(ComplaintOrderSearchBean::getCustName, new Object[]{param.getCustName()})).op((FieldOp)FieldOps.Contain);
        }
        return whereSqlMapBuilder;
    }

    private void setParamsOrderBy(List<OrderItem> orders, MapBuilder whereSqlMapBuilder) {
        for (OrderItem orderItem : orders) {
            if (orderItem != null && !orderItem.getColumn().isBlank()) {
                if (orderItem.isAsc()) {
                    whereSqlMapBuilder.orderBy(orderItem.getColumn()).asc();
                    continue;
                }
                whereSqlMapBuilder.orderBy(orderItem.getColumn()).desc();
                continue;
            }
            whereSqlMapBuilder.orderBy(orderItem.getColumn()).desc();
        }
    }

    public ComplaintOrderSearchBeanServiceImpl(SearchBeanService searchBeanService, JdbcTemplate jdbcTemplate) {
        this.searchBeanService = searchBeanService;
        this.jdbcTemplate = jdbcTemplate;
    }
}

