/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.config.AuthorizationServiceConfiguration;
import com.elitesland.yst.production.aftersale.constant.Constant;
import com.elitesland.yst.production.aftersale.convert.OrderLogConvert;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.convert.RepairOrderConvert;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerInfoDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairPartsServiceDO;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairOrderParam;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceExlParam;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarAndVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairPartsServiceVO;
import com.elitesland.yst.production.aftersale.model.vo.StoreVO;
import com.elitesland.yst.production.aftersale.out.sale.CrmSaleService;
import com.elitesland.yst.production.aftersale.out.support.OrgStoreService;
import com.elitesland.yst.production.aftersale.out.support.lm.OrgStoreLmService;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.provider.sale.VinOrderRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysMsgRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.aftersale.service.RepairPartsService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerInfoRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepo;
import com.elitesland.yst.production.aftersale.service.repo.OrderLogRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairOrderRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairOrderRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.RepairPartsServiceRepo;
import com.elitesland.yst.production.aftersale.service.repo.RepairPartsServiceRepoProc;
import com.elitesland.yst.production.aftersale.util.NumSendEnum;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RepaiOrderServiceImpl
implements RepairOrderService {
    private static final Logger log = LogManager.getLogger(RepaiOrderServiceImpl.class);
    private final RepairOrderRepoProc repairOrderRepoProc;
    private final RepairPartsServiceRepo repairPartsServiceRepo;
    private final RepairPartsService repairPartsService;
    private final CarOwnerVehicleService carOwnerVehicleService;
    private final CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    private final OrderEvaluationService orderEvaluationService;
    private final RepairPartsServiceRepoProc repairPartsServiceRepoProc;
    private final RepairOrderRepo repairOrderRepo;
    private final PictureOrderRepo pictureOrderRepo;
    private final UserService userService;
    private final SystemService systemService;
    private final PictureOrderService pictureOrderService;
    private final OrderLogRepo orderLogRepo;
    private final OrderLogRepoProc orderLogRepoProc;
    private final CarOwnerInfoRepo carOwnerInfoRepo;
    private final OrgStoreService orgStoreService;
    private final SysUdcProxyService sysUdcProxyService;
    private Constant constant;
    private final CrmSaleService crmSaleService;
    private final OrgStoreLmService orgStoreLmService;
    private final MaintainCardService maintainCardService;
    private final CrmCustAccountRpcService crmCustAccountRpcService;
    private final SysMsgRpcProvider sysMsgRpcProvider;
    private final AuthorizationServiceConfiguration authorizationServiceConfiguration;
    private final OrgStoreRpcService orgStoreRpcService;
    private final VinOrderRpcProvider vinOrderRpcProvider;
    @Value(value="${file.upload.url}")
    private String pictureURL;
    private static final String COMPLETE = "\u5b8c\u6210";
    private static final String PLAC_EORDER = "\u4e0b\u5355";
    private static final String DISPATCH = "\u5f00\u59cb\u7ef4\u4fee";
    private static final String CANCEL_EORDER = "\u53d6\u6d88";

    @Override
    @SysCodeProc
    public PagingVO<RepairOrderVO> query(RepairOrderExlParam queryDTO) {
        PagingVO<RepairOrderVO> repairOrderVOS = this.repairOrderRepoProc.query(queryDTO);
        this.vehicleQuery(repairOrderVOS.getRecords());
        this.storeQuery(repairOrderVOS.getRecords());
        this.pictoreQuery(repairOrderVOS.getRecords());
        this.udcTranslate(repairOrderVOS.getRecords());
        return repairOrderVOS;
    }

    @Override
    public PagingVO<RepairOrderVO> pcQuery(RepairOrderExlParam queryDTO) {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairStoreQuery();
        ArrayList<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<Long>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        queryDTO.setRepairStoreIdS(collect);
        if (CollectionUtils.isEmpty(queryDTO.getRepairStoreIdS())) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        return this.query(queryDTO);
    }

    @Override
    public PagingVO<RepairOrderVO> bcPcQuery(RepairOrderExlParam queryDTO) {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.bcRepairStoreQuery();
        ArrayList<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<Long>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        queryDTO.setRepairStoreIdS(collect);
        if (CollectionUtils.isEmpty(queryDTO.getRepairStoreIdS())) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        return this.query(queryDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(RepairOrderParam saveVO, String source) {
        log.info("\u7ef4\u4fee\u5de5\u5355\u4fdd\u5b58\u5165\u53c2:" + JSON.toJSONString((Object)saveVO));
        String orderNo = null;
        Long aLong = null;
        this.check(saveVO);
        this.queryStore(saveVO);
        this.queryCarOwnerInfo(saveVO);
        if (saveVO.getId() != null && saveVO.getId() != 0L) {
            this.pictureOrderRepo.deleteByOrderId(saveVO.getId());
        } else {
            aLong = this.checkBindVehicle(saveVO, source);
            orderNo = this.systemService.sysNumberRuleGenerateCode(NumSendEnum.LMW.getCode(), new ArrayList<String>());
            log.info("\u7ef4\u4fee\u5de5\u5355\u53d1\u53f7\uff1a" + JSON.toJSONString((Object)orderNo));
        }
        saveVO.setOrderNo(orderNo == null ? saveVO.getOrderNo() : orderNo);
        saveVO.setPersonalVehicelId(aLong == null ? saveVO.getPersonalVehicelId() : aLong);
        saveVO.setOrderStatus(UdcEnum.REPAIR_ORDER_JSS001.getValueCode());
        saveVO.setRepairMode("1");
        RepairOrderDO repairOrderDO = RepairOrderConvert.INSTANCE.saveVoTODO(saveVO);
        Long id = ((RepairOrderDO)this.repairOrderRepo.save(repairOrderDO)).getId();
        List<PictureOrderParam> pictureOrderParamList = saveVO.getPictureOrderParamList();
        if (!CollectionUtils.isEmpty(pictureOrderParamList)) {
            List collect = pictureOrderParamList.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO((PictureOrderParam)t);
                pictureOrderDO.setOrderId(id);
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_1.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            this.pictureOrderRepo.saveAll(collect);
        }
        this.saveOrderLog(saveVO, id, source, PLAC_EORDER);
        if (null == saveVO.getId() || 0L == saveVO.getId()) {
            saveVO.setId(id);
            this.sendCreateMsg(saveVO);
        }
        return id;
    }

    private void saveOrderLog(RepairOrderParam saveVO, Long id, String source, String status) {
        if (saveVO.getId() != null && saveVO.getId() != 0L) {
            return;
        }
        SysUserDTO user = this.userService.getUserDetail();
        String operationUser = null;
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)user));
        String remark = null;
        switch (source) {
            case "PC": {
                remark = "\u7ecf\u9500\u5546\uff08" + user.getPrettyName() + ")\u4ee3\u5ba2\uff08" + saveVO.getOrderPerson() + ")" + status;
                operationUser = user.getUsername();
                break;
            }
            case "APP": {
                remark = "\u7ecf\u9500\u5546\uff08" + user.getPrettyName() + ")\u4ee3\u5ba2\uff08" + saveVO.getOrderPerson() + ")" + status;
                operationUser = user.getUsername();
                break;
            }
            case "MINIAPP": {
                remark = "\u8f66\u4e3b\uff08" + user.getUsername() + ")" + status;
                operationUser = user.getMobile();
                break;
            }
            default: {
                throw new BusinessException("\u6570\u636e\u6765\u6e90\u5f02\u5e38");
            }
        }
        this.orderLogAdd(id, UdcEnum.ORDER_TYPE_1.getValueCode(), status, operationUser, saveVO.getCreateUserId(), remark);
    }

    private void queryCarOwnerInfo(RepairOrderParam saveVO) {
        CarOwnerInfoDO carOwnerInfoDO = this.carOwnerInfoRepo.findByUserPhone(saveVO.getOrderTel());
        if (Optional.ofNullable(carOwnerInfoDO).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8f66\u4e3b\u4fe1\u606f");
        }
        saveVO.setPersonalId(carOwnerInfoDO.getCarOwnerId());
        saveVO.setCasUserId(carOwnerInfoDO.getCasUserId());
    }

    private void queryStore(RepairOrderParam saveVO) {
        if (saveVO.getRepairStoreId() == 0L || saveVO.getRepairStoreId() == null) {
            return;
        }
        OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = this.orgStoreService.orgStoreGet(saveVO.getRepairStoreId());
        if (Optional.ofNullable(orgStoreDetailRpcDTO).isEmpty()) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u95e8\u5e97\u4fe1\u606f");
        }
        saveVO.setRepairStoreName(saveVO.getRepairStoreName() == null ? orgStoreDetailRpcDTO.getStoreName() : saveVO.getRepairStoreName());
        saveVO.setRepairStoreCode(saveVO.getRepairStoreCode() == null ? orgStoreDetailRpcDTO.getStoreCode() : saveVO.getRepairStoreCode());
        saveVO.setSalesman(orgStoreDetailRpcDTO.getStoreManager());
        saveVO.setSalesmanId(null);
    }

    @Override
    public ApiResult<Long> repairOrderCancel(RepairOrderParam saveVO) {
        if (!(StringUtils.isEmpty((Object)saveVO.getOrderStatus()) || UdcEnum.REPAIR_ORDER_JSS001.getValueCode().equals(saveVO.getOrderStatus()) || UdcEnum.REPAIR_ORDER_JSS002.getValueCode().equals(saveVO.getOrderStatus()))) {
            throw new BusinessException("\u7ef4\u4fee\u72b6\u6001\u5f02\u5e38");
        }
        if (saveVO.getId() == null || saveVO.getId() == 0L) {
            throw new BusinessException("\u5de5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.repairOrderRepoProc.cancel(saveVO);
        Object content = "\u53d6\u6d88\u539f\u56e0\uff1a";
        if (null != saveVO.getCancelReasonC()) {
            content = (String)content + this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode()).get(saveVO.getCancelReasonC());
        } else if (null != saveVO.getCancelReasonB()) {
            content = (String)content + this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode()).get(saveVO.getCancelReasonB());
        }
        if (null != saveVO.getCancelRemark()) {
            content = (String)content + " \u8be6\u7ec6\u4fe1\u606f\uff1a" + saveVO.getCancelRemark();
        }
        this.saveOrderLog(saveVO, saveVO.getId(), "PC", CANCEL_EORDER);
        this.sendMsg(saveVO, "WXC0005");
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @SysCodeProc
    public RepairOrderVO detail(RepairOrderExlParam param) {
        List<RepairOrderVO> repairOrderVOS = this.repairOrderRepoProc.detail(param);
        if (CollectionUtils.isEmpty(repairOrderVOS)) {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
        }
        this.vehicleQuery(repairOrderVOS);
        this.storeQuery(repairOrderVOS);
        this.pictoreQuery(repairOrderVOS);
        this.partsQuery(repairOrderVOS);
        this.orderEcaluationQuery(repairOrderVOS);
        this.orderLogQuery(repairOrderVOS);
        this.udcTranslate(repairOrderVOS);
        return repairOrderVOS.get(0);
    }

    @Override
    public ApiResult repairOrderDelete(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            throw new BusinessException("\u7ef4\u4fee\u5de5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.repairOrderRepoProc.deleteList(idList);
        return ApiResult.ok();
    }

    @Override
    public PagingVO<RepairOrderVO> export(RepairOrderExlParam param) {
        PagingVO<RepairOrderVO> page = this.query(param);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        List<Long> idList = page.getRecords().stream().map(RepairOrderVO::getId).collect(Collectors.toList());
        RepairPartsServiceExlParam repairPartsServiceExlParam = new RepairPartsServiceExlParam();
        repairPartsServiceExlParam.setRepairIdList(idList);
        List<RepairPartsServiceVO> repairPartsServiceVOS = this.repairPartsServiceRepoProc.query(repairPartsServiceExlParam);
        this.fillVehicleVoType(page.getRecords());
        ArrayList repairOrderVOS = new ArrayList();
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.PARTS_SERVICE_TYPE_1.getModel(), UdcEnum.PARTS_SERVICE_TYPE_1.getCode());
        page.getRecords().forEach(item -> {
            List<RepairPartsServiceVO> patVo = repairPartsServiceVOS.stream().filter(x -> x.getRepairId().equals(item.getId())).collect(Collectors.toList());
            if (!patVo.isEmpty()) {
                patVo.forEach(s -> {
                    RepairOrderVO repairOrderVO = new RepairOrderVO();
                    BeanUtils.copyProperties((Object)item, (Object)repairOrderVO);
                    repairOrderVO.setRepairPartName(s.getPartsName());
                    if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(s.getServiceType())) {
                        repairOrderVO.setRepairPartType((String)ajStatusMap.get(s.getServiceType()));
                    }
                    repairOrderVO.setPartsPrice(s.getPartsPrice());
                    repairOrderVO.setServicePrice(s.getServicePrice());
                    repairOrderVOS.add(repairOrderVO);
                });
            } else {
                repairOrderVOS.add(item);
            }
        });
        PagingVO repairPage = new PagingVO();
        repairPage.setRecords(repairOrderVOS);
        repairPage.setTotal((long)repairOrderVOS.size());
        return repairPage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long confirm(RepairOrderParam saveVO) {
        List<RepairPartsServiceParam> partsServiceSaveVO;
        if (!StringUtils.isEmpty((Object)saveVO.getOrderStatus()) && !UdcEnum.REPAIR_ORDER_JSS002.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("\u8ba2\u5355\u7ef4\u4fee\u72b6\u6001\u5f02\u5e38");
        }
        this.startCheck(saveVO);
        this.repairOrderRepoProc.updateStatus(saveVO.getId(), UdcEnum.REPAIR_ORDER_JSS003.getValueCode(), saveVO.getRepairRemark());
        List<RepairPartsServiceDO> repairPartsServiceDOS = this.repairPartsServiceRepo.findByRepairId(saveVO.getId());
        if (!CollectionUtils.isEmpty(repairPartsServiceDOS)) {
            this.repairPartsServiceRepo.deleteByRepairId(saveVO.getId());
        }
        if (!CollectionUtils.isEmpty(partsServiceSaveVO = saveVO.getPartsServiceSaveVO())) {
            partsServiceSaveVO.stream().forEach(t -> {
                t.setId(null);
                t.setRepairId(saveVO.getId());
            });
            this.repairPartsService.saveList(partsServiceSaveVO);
        }
        this.saveOrderLog(saveVO, saveVO.getId(), "PC", COMPLETE);
        this.sendMsg(saveVO, "WXC0006");
        return saveVO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long start(RepairOrderParam saveVO) {
        if (!StringUtils.isEmpty((Object)saveVO.getOrderStatus()) && !UdcEnum.REPAIR_ORDER_JSS001.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("\u53ea\u6709\u5f85\u7ef4\u4fee\u5355\u636e\u53ef\u4ee5\u70b9\u51fb\u5f00\u59cb");
        }
        this.startCheck(saveVO);
        this.repairOrderRepoProc.updateStatus(saveVO.getId(), UdcEnum.REPAIR_ORDER_JSS002.getValueCode(), saveVO.getRepairRemark());
        List<RepairPartsServiceParam> partsServiceSaveVO = saveVO.getPartsServiceSaveVO();
        if (!CollectionUtils.isEmpty(partsServiceSaveVO)) {
            partsServiceSaveVO.stream().forEach(t -> {
                t.setId(null);
                t.setRepairId(saveVO.getId());
            });
            this.repairPartsService.saveList(partsServiceSaveVO);
        }
        this.saveOrderLog(saveVO, saveVO.getId(), "PC", DISPATCH);
        this.sendMsg(saveVO, "WXC0004");
        return saveVO.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long supply(RepairOrderParam saveVO) {
        List<RepairPartsServiceParam> partsServiceSaveVO;
        log.info("\u7ef4\u4fee\u5de5\u5355\u4fe1\u606f\u8865\u5145\u5165\u53c2\uff1a" + JSON.toJSONString((Object)saveVO));
        if (!StringUtils.isEmpty((Object)saveVO.getOrderStatus()) && !UdcEnum.REPAIR_ORDER_JSS002.getValueCode().equals(saveVO.getOrderStatus())) {
            throw new BusinessException("\u53ea\u6709\u7ef4\u4fee\u4e2d\u5355\u636e\u53ef\u4ee5\u4fe1\u606f\u8865\u5145");
        }
        this.startCheck(saveVO);
        this.repairOrderRepoProc.updateSupplyStatus(saveVO.getId(), saveVO.getRepairRemark());
        List<RepairPartsServiceDO> repairPartsServiceDOS = this.repairPartsServiceRepo.findByRepairId(saveVO.getId());
        if (!CollectionUtils.isEmpty(repairPartsServiceDOS)) {
            this.repairPartsServiceRepo.deleteByRepairId(saveVO.getId());
        }
        if (!CollectionUtils.isEmpty(partsServiceSaveVO = saveVO.getPartsServiceSaveVO())) {
            partsServiceSaveVO.stream().forEach(t -> {
                t.setId(null);
                t.setRepairId(saveVO.getId());
            });
            this.repairPartsService.saveList(partsServiceSaveVO);
        }
        return saveVO.getId();
    }

    @Override
    public List<OrgStoreRpcDTO> repairStoreQuery() {
        SysUserDTO user = this.userService.getUserDetail();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)user));
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = new ArrayList<OrgStoreRpcDTO>();
        CrmCustSimpleVO custSimple = this.crmSaleService.getCustSimple(user.getId());
        if (Optional.ofNullable(custSimple).isEmpty()) {
            orgStoreRpcDTOS.add(this.filterStore(user.getUsername()));
            return orgStoreRpcDTOS;
        }
        if (StringUtils.isEmpty((Object)custSimple.getCorOu())) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4eba\u5bf9\u5e94\u516c\u53f8\uff0c\u8bf7\u624b\u52a8\u6dfb\u52a0\u5bf9\u5e94\u516c\u53f8");
        }
        log.info("\u7ecf\u9500\u5546\u6240\u5c5e\u516c\u53f8\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)custSimple));
        orgStoreRpcDTOS = this.orgStoreLmService.orgStoreGet(custSimple.getCorOu());
        if (CollectionUtils.isEmpty(orgStoreRpcDTOS)) {
            return orgStoreRpcDTOS;
        }
        log.info("\u7ecf\u9500\u5546\u6240\u5c5e\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(orgStoreRpcDTOS));
        return orgStoreRpcDTOS;
    }

    @Override
    public List<OrgStoreRpcDTO> bcRepairStoreQuery() {
        SysUserDTO user = this.userService.getUserDetail();
        log.info("\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)user));
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = new ArrayList<OrgStoreRpcDTO>();
        CrmCustSimpleVO custSimple = this.crmSaleService.bcGetCustSimple(user.getUsername());
        if (Optional.ofNullable(custSimple).isEmpty()) {
            orgStoreRpcDTOS.add(this.filterStore(user.getUsername()));
            return orgStoreRpcDTOS;
        }
        if (StringUtils.isEmpty((Object)custSimple.getCorOu())) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u4eba\u5bf9\u5e94\u516c\u53f8");
        }
        log.info("\u7ecf\u9500\u5546\u6240\u5c5e\u516c\u53f8\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)custSimple));
        orgStoreRpcDTOS = this.orgStoreLmService.orgStoreGet(custSimple.getCorOu());
        if (CollectionUtils.isEmpty(orgStoreRpcDTOS)) {
            return orgStoreRpcDTOS;
        }
        log.info("\u7ecf\u9500\u5546\u6240\u5c5e\u95e8\u5e97\u4fe1\u606f\uff1a" + JSON.toJSONString(orgStoreRpcDTOS));
        return orgStoreRpcDTOS;
    }

    public OrgStoreRpcDTO filterStore(String userName) {
        OrgStoreDetailRpcDTO byCode = this.orgStoreService.getByCode(userName);
        if (!Optional.ofNullable(byCode).isEmpty()) {
            OrgStoreRpcDTO orgStoreRpcDTO = new OrgStoreRpcDTO();
            BeanCopyUtil.beanCopy((Object)byCode, (Object)orgStoreRpcDTO);
            return orgStoreRpcDTO;
        }
        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u767b\u5f55\u8d26\u53f7\u95e8\u5e97\u4fe1\u606f");
    }

    public void check(RepairOrderParam saveVO) {
        log.info("\u7ef4\u4fee\u5de5\u5355\u63d0\u4ea4\u5165\u53c2", (Object)JSON.toJSONString((Object)saveVO));
        if (saveVO.getOrderTel() == null) {
            throw new BusinessException("\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getQuestionRemark() == null) {
            throw new BusinessException("\u95ee\u9898\u63cf\u8ff0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getCreator() == null) {
            throw new BusinessException("\u521b\u5efa\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getCreateUserId() == null || saveVO.getCreateUserId() == 0L) {
            throw new BusinessException("\u521b\u5efa\u4ebaid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getVehicleSource() == null) {
            throw new BusinessException("\u8f66\u8f86\u6765\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getRepairStoreId() == null || saveVO.getRepairStoreId() == 0L) {
            throw new BusinessException("\u95e8\u5e97id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    public void startCheck(RepairOrderParam saveVO) {
        log.info("\u7ef4\u4fee\u5de5\u5355\u5f00\u59cb\u7ef4\u4fee\u5165\u53c2", (Object)JSON.toJSONString((Object)saveVO));
        if (saveVO.getId() == null || saveVO.getId() == 0L) {
            throw new BusinessException("\u5de5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty(saveVO.getPartsServiceSaveVO())) {
            saveVO.getPartsServiceSaveVO().forEach(t -> {
                if (StringUtils.isEmpty((Object)t.getServiceType())) {
                    throw new BusinessException("\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (StringUtils.isEmpty((Object)saveVO.getCreator())) {
            throw new BusinessException("\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (saveVO.getCreateUserId() == null || saveVO.getCreateUserId() == 0L) {
            throw new BusinessException("\u521b\u5efa\u4ebaId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void vehicleQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getPersonalVehicelId() != null && t.getPersonalVehicelId() != 0L).map(RepairOrderVO::getPersonalVehicelId).collect(Collectors.toList());
        BindSoldVehicleParam bindSoldVehicleParam = new BindSoldVehicleParam();
        bindSoldVehicleParam.setIdList(collect);
        List records = this.carOwnerVehicleRepoProc.bindSoldVehicleQuery(bindSoldVehicleParam).getRecords();
        repairOrderVOS.stream().forEach(t -> {
            Optional<BindSoldVehicleVO> first = records.stream().filter(vehicle -> vehicle.getId() != null && vehicle.getId().equals(t.getPersonalVehicelId())).findFirst();
            if (first.isPresent()) {
                t.setBindSoldVehicleVO(first.get());
            }
        });
    }

    public void fillVehicleVoType(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getPersonalVehicelId() != null && t.getPersonalVehicelId() != 0L).map(RepairOrderVO::getPersonalVehicelId).collect(Collectors.toList());
        BindSoldVehicleParam bindSoldVehicleParam = new BindSoldVehicleParam();
        bindSoldVehicleParam.setIdList(collect);
        List records = this.carOwnerVehicleRepoProc.bindSoldVehicleQuery(bindSoldVehicleParam).getRecords();
        repairOrderVOS.stream().forEach(t -> {
            Optional<BindSoldVehicleVO> first = records.stream().filter(vehicle -> vehicle.getId() != null && vehicle.getId().equals(t.getPersonalVehicelId())).findFirst();
            if (first.isPresent()) {
                t.setVehicleType(first.get().getVehicleType());
            }
        });
    }

    public void storeQuery(List<RepairOrderVO> repairOrderVOS) {
        repairOrderVOS.stream().forEach(t -> {
            StoreVO storeVO = new StoreVO();
            storeVO.setStoreCode(t.getRepairStoreCode());
            storeVO.setStoreName(t.getRepairStoreName());
            storeVO.setId(t.getRepairStoreId());
            t.setStoreVO(storeVO);
        });
    }

    public void orderLogQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(RepairOrderVO::getId).collect(Collectors.toList());
        OrderLogPageParam orderLogPageParam = new OrderLogPageParam();
        orderLogPageParam.setOrderIdList(collect);
        orderLogPageParam.setOrderType(UdcEnum.ORDER_TYPE_1.getValueCode());
        List<OrderLogVO> orderLogVOS = this.orderLogRepoProc.query(orderLogPageParam);
        repairOrderVOS.stream().forEach(t -> {
            List<OrderLogVO> orderLogVOList = orderLogVOS.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
            t.setOrderLogVOS(orderLogVOList);
        });
    }

    public void pictoreQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(RepairOrderVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(collect);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_1.getValueCode());
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
        }
        if (!CollectionUtils.isEmpty((Collection)data)) {
            repairOrderVOS.stream().forEach(t -> {
                List<PictureOrderVO> respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
                t.setPictureOrderVOS(respVOList);
            });
        }
    }

    @SysCodeProc
    public void partsQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(RepairOrderVO::getId).collect(Collectors.toList());
        RepairPartsServiceExlParam pictureOrderQueryVO = new RepairPartsServiceExlParam();
        pictureOrderQueryVO.setRepairIdList(collect);
        List<RepairPartsServiceVO> query = this.repairPartsServiceRepoProc.query(pictureOrderQueryVO);
        this.sysUdcProxyService.translate(query);
        repairOrderVOS.stream().forEach(t -> {
            List<RepairPartsServiceVO> respVOList = query.stream().filter(pic -> pic.getRepairId().equals(t.getId())).collect(Collectors.toList());
            t.setRepairPartsServiceVOS(respVOList);
        });
    }

    public void orderEcaluationQuery(List<RepairOrderVO> repairOrderVOS) {
        List<Long> collect = repairOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(RepairOrderVO::getId).collect(Collectors.toList());
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderIdList(collect);
        orderEvaluationParam.setOrderType("1");
        List<OrderEvaluationVO> records = this.orderEvaluationService.queryList(orderEvaluationParam);
        this.evaluationPic(records);
        repairOrderVOS.stream().forEach(t -> {
            Optional<OrderEvaluationVO> first = records.stream().filter(order -> order.getOrderId().equals(t.getId())).findFirst();
            if (first.isPresent()) {
                t.setOrderEvaluationVO(first.get());
            }
        });
    }

    public void evaluationPic(List<OrderEvaluationVO> records) {
        List<Long> idList = records.stream().filter(t -> t.getOrderId() != null && t.getOrderId() != 0L).map(OrderEvaluationVO::getOrderId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(idList);
        pictureOrderParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_3.getValueCode());
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
        }
        if (!CollectionUtils.isEmpty((Collection)data)) {
            records.stream().forEach(t -> {
                List<PictureOrderVO> respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getOrderId())).collect(Collectors.toList());
                t.setPictureOrderVOS(respVOList);
            });
        }
    }

    public void udcTranslate(List<RepairOrderVO> repairOrderVOS) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.REPAIR_ORDER_JSS001.getModel(), UdcEnum.REPAIR_ORDER_JSS001.getCode());
        repairOrderVOS.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(t.getOrderStatus())) {
                t.setOrderStatusName((String)ajStatusMap.get(t.getOrderStatus()));
            }
            if (t.getRepairMode() != null && "1".equals(t.getRepairMode())) {
                t.setRepairModeName("\u5230\u5e97\u7ef4\u4fee");
            }
        });
    }

    public void orderLogAdd(Long id, String orderType, String operationContent, String operationUser, Long operationUserId, String remark) {
        OrderLogSaveParam orderLogSaveParam = new OrderLogSaveParam(id, orderType, operationContent, LocalDateTime.now(), operationUser, operationUserId);
        orderLogSaveParam.setRemark(remark);
        OrderLogDO orderLogDO = OrderLogConvert.INSTANCE.saveVoTODO(orderLogSaveParam);
        this.orderLogRepo.save((Object)orderLogDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long checkBindVehicle(RepairOrderParam saveVO, String source) {
        Long data = null;
        log.info("\u8f66\u8f86\u7ed1\u5b9a\u6821\u9a8c\uff1a" + JSON.toJSONString((Object)saveVO));
        if (null == saveVO.getPersonalVehicelId()) {
            throw new BusinessException("PersonalVehicelId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (saveVO.getVehicleSource().equals(1)) {
            CarAndVehicleVO byVehicleNo = this.carOwnerVehicleRepoProc.findByVehicleNo(saveVO.getVehicleNo(), saveVO.getOrderTel());
            log.info("\u8f66\u67b6\u53f7\u6570\u636e\u67e5\u8be2\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)byVehicleNo));
            if (null == byVehicleNo) {
                throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u8be5\u8f66\u8f86\uff0c\u8bf7\u5148\u8fdb\u884c\u8f66\u8f86\u7ed1\u5b9a");
            }
            return byVehicleNo.getId();
        }
        if (saveVO.getVehicleSource().equals(0)) {
            data = saveVO.getPersonalVehicelId();
        }
        return data;
    }

    public Long saveVehicle(RepairOrderParam saveVO, String sourcePlatform) {
        CarOwnerVehicleParam carOwnerVehicleParam = new CarOwnerVehicleParam();
        carOwnerVehicleParam.setVehicleNo(saveVO.getVehicleNo());
        carOwnerVehicleParam.setBindingTime(LocalDateTime.now().toString());
        carOwnerVehicleParam.setVehicleSource(saveVO.getVehicleSource());
        carOwnerVehicleParam.setVehicleType(saveVO.getVehicleType());
        carOwnerVehicleParam.setUserName(saveVO.getOrderPerson());
        carOwnerVehicleParam.setUserPhone(saveVO.getOrderTel());
        carOwnerVehicleParam.setBrandName(saveVO.getBrandName());
        carOwnerVehicleParam.setPurchaseTime(saveVO.getPurchaseTime());
        carOwnerVehicleParam.setMaintainCardNo(saveVO.getMaintainCardNo());
        carOwnerVehicleParam.setActivityNum(saveVO.getActivityNum());
        carOwnerVehicleParam.setVehicleSpecs(saveVO.getVehicleSpecs());
        carOwnerVehicleParam.setVehicleColor(saveVO.getVehicleColor());
        carOwnerVehicleParam.setSalesOutletsId(saveVO.getRepairStoreId());
        log.info("\u4fdd\u5b58\u63a5\u53e3\u8c03\u7528\u7ed1\u5b9a\u8f66\u8f86\u5165\u53c2\uff1a", (Object)JSON.toJSONString((Object)carOwnerVehicleParam));
        Long data = (Long)this.carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam, sourcePlatform).getData();
        return data;
    }

    public void vehicleActivate(RepairOrderParam saveVO) {
        log.info("vehicleActivate\u6fc0\u6d3b\u4e09\u5305\u4fe1\u606f\uff1a" + saveVO);
        CarMaintainCardParam carMaintainCardParam = new CarMaintainCardParam();
        carMaintainCardParam.setVehicleNo(saveVO.getVehicleNo());
        carMaintainCardParam.setCarOwnerId(saveVO.getPersonalId());
        carMaintainCardParam.setPurchaseTime(saveVO.getPurchaseTime() == null ? null : saveVO.getPurchaseTime());
        carMaintainCardParam.setProductionDate(saveVO.getManufactureDate() == null ? null : saveVO.getManufactureDate().toLocalDate());
        this.maintainCardService.activate(carMaintainCardParam);
    }

    private void sendMsg(RepairOrderParam saveVO, String templateCode) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode(templateCode);
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("msgType", "c_repair_order_detail");
            objectObjectHashMap.put("orderNo", saveVO.getOrderNo());
            objectObjectHashMap.put("orderId", saveVO.getId().toString());
            dto.setMesJoinParamMap(objectObjectHashMap);
            String receiveUser = "";
            UserTransferHelper userTransferHelper = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer());
            Result result = userTransferHelper.getUserByMobile(saveVO.getOrderTel());
            if (null != result) {
                receiveUser = ((AuthUserDTO)result.getData()).getUsername();
            }
            HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
            map3.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(receiveUser).build());
            ArrayList<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<TemplateAssignRecipientUserDTO>();
            TemplateAssignRecipientUserDTO custRecipient = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map3).userName(saveVO.getOrderPerson()).build();
            recipientUserList.add(custRecipient);
            HashMap interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", saveVO.getOrderNo());
            this.sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void sendCreateMsg(RepairOrderParam saveVO) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode("WXB0004");
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("msgType", "b_repair_order_list");
            objectObjectHashMap.put("orderNo", saveVO.getOrderNo());
            objectObjectHashMap.put("orderId", saveVO.getId().toString());
            dto.setMesJoinParamMap(objectObjectHashMap);
            ArrayList<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<TemplateAssignRecipientUserDTO>();
            HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
            map.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(saveVO.getRepairStoreCode()).build());
            TemplateAssignRecipientUserDTO recipient = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map).userName(saveVO.getRepairStoreName()).build();
            recipientUserList.add(recipient);
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = this.orgStoreRpcService.getByCode(saveVO.getRepairStoreCode());
            if (null != orgStoreDetailRpcDTO) {
                ArrayList<String> codes = new ArrayList<String>();
                codes.add(orgStoreDetailRpcDTO.getOuCode());
                List custAccountVOS = this.crmCustAccountRpcService.getCustAccountBycustCode(codes);
                if (!custAccountVOS.isEmpty()) {
                    CustAccountVO custAccountVO = (CustAccountVO)custAccountVOS.get(0);
                    HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
                    map3.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(custAccountVO.getMobile()).build());
                    TemplateAssignRecipientUserDTO recipient3 = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map3).userName(custAccountVO.getUserName()).build();
                    recipientUserList.add(recipient3);
                }
            }
            HashMap interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", saveVO.getOrderNo());
            this.sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public void receiveTimeOut() {
        log.info("\u5f00\u59cb\u7ef4\u4fee\u5de5\u5355\u63a5\u5355\u8d85\u65f6\u5b9a\u65f6\u4efb\u52a1");
        int current = 1;
        RepairOrderExlParam param = new RepairOrderExlParam();
        param.setCurrent(current);
        param.setSize(1000);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        ArrayList<OrderItem> itemList = new ArrayList<OrderItem>();
        itemList.add(orderItem);
        param.setOrders(itemList);
        LocalDateTime time = LocalDateTime.now().minusHours(12L);
        param.setCreateTimeTo(time);
        param.setOrderStatus(UdcEnum.REPAIR_ORDER_JSS001.getValueCode());
        PagingVO<RepairOrderVO> repairOrderVOS = this.repairOrderRepoProc.query(param);
        HashMap codeMap = new HashMap();
        while (!CollectionUtils.isEmpty((Collection)repairOrderVOS.getRecords())) {
            repairOrderVOS.getRecords().forEach(x -> {
                try {
                    if (!codeMap.containsKey(x.getRepairStoreCode())) {
                        codeMap.put(x.getRepairStoreCode(), x.getRepairStoreName());
                        OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = this.orgStoreRpcService.getByCode(x.getRepairStoreCode());
                        if (null != orgStoreDetailRpcDTO) {
                            CustAccountVO custAccountVO;
                            ArrayList<String> codes = new ArrayList<String>();
                            codes.add(orgStoreDetailRpcDTO.getOuCode());
                            List custAccountVOS = this.crmCustAccountRpcService.getCustAccountBycustCode(codes);
                            if (!custAccountVOS.isEmpty() && !codeMap.containsKey((custAccountVO = (CustAccountVO)custAccountVOS.get(0)).getMobile())) {
                                codeMap.put(custAccountVO.getMobile(), custAccountVO.getUserName());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            });
            param.setCurrent(++current);
            repairOrderVOS = this.repairOrderRepoProc.query(param);
        }
        if (!CollectionUtils.isEmpty(codeMap)) {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            dto.setTemplateCode("WXB0001");
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("msgType", "b_repair_order_list");
            dto.setMesJoinParamMap(objectObjectHashMap);
            ArrayList<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<TemplateAssignRecipientUserDTO>();
            codeMap.keySet().forEach(x -> {
                HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
                map.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(x).build());
                TemplateAssignRecipientUserDTO recipient = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map).userName((String)codeMap.get(x)).build();
                recipientUserList.add(recipient);
            });
            HashMap interiorMap = Maps.newHashMap();
            this.sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        }
        log.info("\u7ef4\u4fee\u5de5\u5355\u63a5\u5355\u8d85\u65f6\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
    }

    public RepaiOrderServiceImpl(RepairOrderRepoProc repairOrderRepoProc, RepairPartsServiceRepo repairPartsServiceRepo, RepairPartsService repairPartsService, CarOwnerVehicleService carOwnerVehicleService, CarOwnerVehicleRepoProc carOwnerVehicleRepoProc, OrderEvaluationService orderEvaluationService, RepairPartsServiceRepoProc repairPartsServiceRepoProc, RepairOrderRepo repairOrderRepo, PictureOrderRepo pictureOrderRepo, UserService userService, SystemService systemService, PictureOrderService pictureOrderService, OrderLogRepo orderLogRepo, OrderLogRepoProc orderLogRepoProc, CarOwnerInfoRepo carOwnerInfoRepo, OrgStoreService orgStoreService, SysUdcProxyService sysUdcProxyService, CrmSaleService crmSaleService, OrgStoreLmService orgStoreLmService, MaintainCardService maintainCardService, CrmCustAccountRpcService crmCustAccountRpcService, SysMsgRpcProvider sysMsgRpcProvider, AuthorizationServiceConfiguration authorizationServiceConfiguration, OrgStoreRpcService orgStoreRpcService, VinOrderRpcProvider vinOrderRpcProvider) {
        this.repairOrderRepoProc = repairOrderRepoProc;
        this.repairPartsServiceRepo = repairPartsServiceRepo;
        this.repairPartsService = repairPartsService;
        this.carOwnerVehicleService = carOwnerVehicleService;
        this.carOwnerVehicleRepoProc = carOwnerVehicleRepoProc;
        this.orderEvaluationService = orderEvaluationService;
        this.repairPartsServiceRepoProc = repairPartsServiceRepoProc;
        this.repairOrderRepo = repairOrderRepo;
        this.pictureOrderRepo = pictureOrderRepo;
        this.userService = userService;
        this.systemService = systemService;
        this.pictureOrderService = pictureOrderService;
        this.orderLogRepo = orderLogRepo;
        this.orderLogRepoProc = orderLogRepoProc;
        this.carOwnerInfoRepo = carOwnerInfoRepo;
        this.orgStoreService = orgStoreService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.crmSaleService = crmSaleService;
        this.orgStoreLmService = orgStoreLmService;
        this.maintainCardService = maintainCardService;
        this.crmCustAccountRpcService = crmCustAccountRpcService;
        this.sysMsgRpcProvider = sysMsgRpcProvider;
        this.authorizationServiceConfiguration = authorizationServiceConfiguration;
        this.orgStoreRpcService = orgStoreRpcService;
        this.vinOrderRpcProvider = vinOrderRpcProvider;
    }
}

