package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


@EqualsAndHashCode(callSuper = true)
@Entity
@Table(name = "repair_parts_service")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "repair_parts_service", comment = "维修配件服务")
@Data
@Accessors(chain = true)
@ApiModel(value = "维修配件服务", description = "维修配件服务")
@Where(clause = "delete_flag = 0")
public class RepairPartsServiceDO extends BaseModel  implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("配件id")
    @Column(name = "parts_id", columnDefinition = "bigint default 0  comment '配件id'")
    Long partsId;

    @ApiModelProperty("所属维修工单id")
    @Column(name = "repair_id", columnDefinition = "bigint default 0  comment '所属维修工单id'")
    Long repairId;

    @ApiModelProperty("配件名称")
    @Column(name = "parts_name", columnDefinition = "varchar(255)  comment '配件名称'")
    String partsName;

    @ApiModelProperty("配件分类")
    @Column(name = "parts_type", columnDefinition = "varchar(100)  comment '配件分类'")
    String partsType;

    @ApiModelProperty("配件售价")
    @Column(name = "parts_price", columnDefinition = "NUMERIC(20,6)  comment '配件售价'")
    BigDecimal partsPrice;

    @ApiModelProperty("配件数量")
    @Column(name = "parts_num", columnDefinition = "int  comment '配件数量'")
    Integer partsNum;

    @ApiModelProperty("服务价格")
    @Column(name = "service_price", columnDefinition = "NUMERIC(20,6)  comment '服务价格'")
    BigDecimal servicePrice;

    @ApiModelProperty("服务类型")
    @Column(name = "service_type", columnDefinition = "varchar(100)  comment '（修件0/换件1/增值服务2）'")
    String serviceType;

    @ApiModelProperty("三包类型")
    @Column(name = "is_three_package", columnDefinition = "varchar(100)  comment '（保内0/保外1）'")
    String isThreePackage;

    @ApiModelProperty("故障类型id")
    @Column(name = "breakdown_maintenance_id ", columnDefinition = "bigint(20) default 0 comment '故障问题分类表id'")
    private Long breakdownMaintenanceId;

    @ApiModelProperty("故障类型名称")
    @Column(name = "breakdown_maintenance_name ", columnDefinition = "varchar(100) comment '故障问题名称'")
    private String breakdownMaintenanceName;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairPartsServiceDO;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
