package com.elitesland.yst.production.aftersale.model.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
@ApiModel(description = "pc售出车辆绑定分页查询返回参数")
public class BindSoldVehicleVO implements Serializable {

    @ApiModelProperty("账号唯一ID")
    private Long id;

    @ApiModelProperty("车辆来源")
    @SysCode(sys = "yst-after-sale", mod = "VEHICLE_SOURCE")
    private Integer vehicleSource;
    @ExcelProperty("车辆来源")
    private String vehicleSourceName;

    @ApiModelProperty("车架号")
    @ExcelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("车辆类型")
    @ExcelProperty("车辆信息")
    private String vehicleType;

    @ApiModelProperty("销售门店编码")
    @ExcelProperty("门店id")
    private String salesOutletsCode;

    @ApiModelProperty("销售门店名称")
    @ExcelProperty("绑定门店")
    private String salesOutletsName;

    @ApiModelProperty("客户号")
    @ExcelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("所属经销商")
    @ExcelProperty("所属经销商")
    private String custName;

    @ApiModelProperty("所属区域")
    @ExcelProperty("所属区域")
    private String salesOutletsRegionName;

    @ApiModelProperty("销售门店ID")
    private Long salesOutletsId;

    @ApiModelProperty("车主手机号")
    @ExcelProperty("车主手机号")
    private String userPhone;

    @ApiModelProperty("车主姓名")
    @ExcelProperty("车主名称")
    private String userName;

    @ApiModelProperty("车辆车型")
    private String vehicleModel;

    @ApiModelProperty("车辆名称")
    private String vehicleName;

    @ApiModelProperty("车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    private String vehicleColor;

    @ApiModelProperty("生产日期")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("车辆信息")
    private String vehicleInfo;

    @ApiModelProperty("购买日期")
    @ExcelProperty("购买时间")
    private LocalDateTime purchaseTime;

    @ApiModelProperty("绑定时间")
    @ExcelProperty("绑定时间")
    private LocalDateTime bindingTime;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("车主身份证号")
    private String userIdCard;

    @ApiModelProperty("车主性别")
    @SysCode(sys = "yst-after-sale", mod = "SEX")
    private String userSex;
    private String userSexName;

    @ApiModelProperty("车主地区")
    private String userArea;

    @ApiModelProperty("车主生日")
    private LocalDate userBirthday;

    @ApiModelProperty("购买金额")
    private BigDecimal vehicleBuyPrice;

    @ApiModelProperty("车辆三包信息")
    private CarOwnerMaintainCardVO carMaintainCardRespVO;
}
