package com.elitesland.yst.production.aftersale.constant;

import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

/**aftersale域常用常量及方法
 * @author Danny.Wang
 * @title Constant
 * @Date2023/1/17 17:13
 */
@Component
public class Constant {
    private Constant() {
    }
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final LocalTime MAX = LocalTime.of(23,59,59);
    static final String familyName = "赵钱孙李周吴郑王冯陈褚卫蒋沈韩杨朱秦尤许何吕施张孔曹严华金魏陶姜戚谢邹喻水云苏潘葛奚范彭郎鲁韦昌马苗凤花方俞任袁柳鲍史唐费岑薛雷贺倪汤滕殷罗毕郝邬安常乐于时傅卞齐康伍余元卜顾孟平"
            + "黄和穆萧尹姚邵湛汪祁毛禹狄米贝明臧计成戴宋茅庞熊纪舒屈项祝董粱杜阮席季麻强贾路娄危江童颜郭梅盛林刁钟徐邱骆高夏蔡田胡凌霍万柯卢莫房缪干解应宗丁宣邓郁单杭洪包诸左石崔吉"
            + "龚程邢滑裴陆荣翁荀羊甄家封芮储靳邴松井富乌焦巴弓牧隗山谷车侯伊宁仇祖武符刘景詹束龙叶幸司韶黎乔苍双闻莘劳逄姬冉宰桂牛寿通边燕冀尚农温庄晏瞿茹习鱼容向古戈终居衡步都耿满弘国文东殴沃曾关红游盖益桓公晋楚闫";
    static final String firstName2 = "欧阳太史端木上官司马东方独孤南宫万俟闻人夏侯诸葛尉迟公羊赫连澹台皇甫宗政濮阳公冶太叔申屠公孙慕容仲孙钟离长孙宇文司徒鲜于司空闾丘子车亓官司寇巫马公西颛孙壤驷公良漆雕乐正宰父谷梁拓跋夹谷轩辕令狐段干百里呼延东郭南门羊舌微生公户公玉公仪梁丘公仲公上公门公山公坚左丘公伯西门公祖第五公乘贯丘公皙南荣东里东宫仲长子书子桑即墨达奚褚师吴铭";


    public LocalDateTime swapTimeMin(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(Constant.DATE_FORMAT);
        try {
            LocalDate localDate = LocalDate.parse(date, dtf);
            LocalDateTime localDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
            return localDateTime;
        } catch (Exception e) {
            return null;
        }
    }

    public LocalDateTime swapTimeMax(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(Constant.DATE_FORMAT);
        LocalDate localDate = LocalDate.parse(date, dtf);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, MAX);
        return localDateTime;
    }

    //生成随机名字
    public String randFamilyName() {
        String str2 = "";
        int strLen;
        int index;

        strLen = familyName.length();
        index = new Random().nextInt(strLen);
        String str1 = String.valueOf(familyName.charAt(index));
        strLen = firstName2.length();
        index = new Random().nextInt(strLen);
        if (index % 2 == 0) {
            str2 = firstName2.substring(index, index + 3);
        } else {
            str2 = firstName2.substring(index - 1, index + 1);
        }

        return str1.concat(str2);
    }

    /**
     * @param digit 位数
     * @return 随机生成digit位数的数字
     */
    public long getRandomNum(int digit) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < digit; i++) {
            if (i == 0 && digit > 1)
                str.append(new Random().nextInt(9) + 1);
            else
                str.append(new Random().nextInt(10));
        }
        return Long.valueOf(str.toString());
    }
}
