package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * @author Danny.Wang
 * @title CarOwnerInfoDO
 * @Date2023/2/8 10:43
 */
@Entity
@Table(name = "car_owner_info",indexes = {@Index(name = "idx_car_owner_id",columnList = "car_owner_id,tenantId",unique = true)})
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "car_owner_info", comment = "车主信息表")
@Where(clause = "delete_flag = 0")
@Data
@Accessors(chain = true)
@ApiModel(value = "car_owner_info", description = "车主信息表")
public class CarOwnerInfoDO extends BaseModel {

    @ApiModelProperty("车主id")
    @Column(name = "car_owner_id ", columnDefinition = "bigint(30) default 0 comment '车主id'")
    private Long carOwnerId;

    @ApiModelProperty("统一认证中心的用户ID")
    @Column(name = "cas_user_id ", columnDefinition = "bigint(30) default 0 comment '统一认证中心的用户ID'")
    private Long casUserId;

    @ApiModelProperty("open_id")
    @Column(name = "open_id", columnDefinition = "varchar(40) comment 'openId'")
    private String openId;

    @ApiModelProperty("头像文件编码")
    @Column(name = "file_code", columnDefinition = "varchar(40) comment '头像文件编码'")
    private String fileCode;

    @ApiModelProperty("车主姓名")
    @Column(name = "user_name", columnDefinition = "varchar(25) comment '车主姓名'")
    private String userName;

    @ApiModelProperty("性别")
    @Column(name = "sex", columnDefinition = "int(1) comment '性别 1-男 0-女'")
    private Integer sex;

    @ApiModelProperty("生日")
    @Column(name = "birthday_time", columnDefinition = "datetime default null comment '生日'")
    private LocalDateTime birthdayTime;

    @ApiModelProperty("城市")
    @Column(name = "city", columnDefinition = "varchar(100) comment '城市'")
    private String city;

    @ApiModelProperty("职业")
    @Column(name = "occupation", columnDefinition = "varchar(25) comment '职业'")
    private String occupation;

    @ApiModelProperty("个性签名")
    @Column(name = "personal_signature", columnDefinition = "varchar(100) comment '个性签名'")
    private String personalSignature;

    @ApiModelProperty("车主手机号")
    @Column(name = "user_phone", columnDefinition = "varchar(20) comment '车主手机号'")
    private String userPhone;

    @ApiModelProperty("启用状态")
    @Comment(value = "启用状态", defaultValue = "1")
    @Column(name = "enabled_flag", columnDefinition = "int(1) comment '启用状态 1-启用 0-禁用'")
    private Integer enabledFlag = 1;

    @ApiModelProperty("头像完整路径")
    @Column(name = "url", columnDefinition = "varchar(255) comment '头像完整路径'")
    private String url;
}
