package com.elitesland.yst.production.aftersale.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@Data
@ApiModel("400电话记录返回参数")
public class PhoneRecClsRespVO implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    /** 上级ID */

    @ApiModelProperty(value = "上级ID")
    private Long pid = 0L;

    /** 排序号 */
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    @ApiModelProperty(value = "分类编码")
    private String code;

    @ApiModelProperty(value = "分类名称")
    private String name;

    /** 简介 */
    @ApiModelProperty(value = "简介描述")
    private String descr;

    /** 下级分类 */
    @ApiModelProperty(value = "下级分类")
    private List<PhoneRecClsRespVO> under;

    /** 是否拥有下级 */
    @ApiModelProperty(value = "是否拥有下级")
    private Boolean hasUnder;

}
