package com.elitesland.yst.production.aftersale.service.export;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author RYH
 * @date 2023/8/18
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class MaintainCardExportServiceImpl implements DataExport<CarMaintainCardVO, CarOwnerMaintainCardPageParam> {
    private final MaintainCardService maintainCardService;

    @Override
    public String getTmplCode() {
        return "maintain_card_export";
    }

    @Override
    public PagingVO<CarMaintainCardVO> execute(CarOwnerMaintainCardPageParam param, int page, int pageSize) {
        param.setSize(800);
        return maintainCardService.page(param);
    }

    @Override
    public String exportFileName() {
        return "车辆激活信息导出";
    }
}
