package com.elitesland.yst.production.aftersale.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.ComplaintSetDO;
import com.elitesland.yst.production.aftersale.model.entity.QComplaintSetDO;
import com.elitesland.yst.production.aftersale.model.param.BusinessComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetParam;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Arrays;
import java.util.List;


/**
 * @author elvis.hong
 * @title ComplaintSetRepoProc
 * @Date 2023/3/1 16:44
 */
@Repository
public class ComplaintSetRepoProc extends BaseRepoProc<ComplaintSetDO> {

    private static final QComplaintSetDO Q_COMPLAINT_SET_DO = QComplaintSetDO.complaintSetDO;

    protected ComplaintSetRepoProc() {
        super(Q_COMPLAINT_SET_DO);
    }

    public List<ComplaintSetVO> complaintSetQuery(ComplaintSetPageParam complaintSetPageParam) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(!StringUtils.isEmpty(complaintSetPageParam.getComplaintType()), Q_COMPLAINT_SET_DO.complaintType, complaintSetPageParam.getComplaintType())
                .andEq(!StringUtils.isEmpty(complaintSetPageParam.getClassifyCode()), Q_COMPLAINT_SET_DO.classifyCode, complaintSetPageParam.getClassifyCode())
                .andEq(!StringUtils.isEmpty(complaintSetPageParam.getEnableFlag()), Q_COMPLAINT_SET_DO.enableFlag, complaintSetPageParam.getEnableFlag())
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_COMPLAINT_SET_DO)
                .where(predicate)
                .orderBy(Q_COMPLAINT_SET_DO.sortNo.desc())
                .fetch();
    }

    public List<ComplaintSetVO> complaintSetQueryAll(ComplaintSetPageParam complaintSetPageParam) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(!StringUtils.isEmpty(complaintSetPageParam.getComplaintType()), Q_COMPLAINT_SET_DO.complaintType, complaintSetPageParam.getComplaintType())
                .andEq(!StringUtils.isEmpty(complaintSetPageParam.getClassifyCode()), Q_COMPLAINT_SET_DO.classifyCode, complaintSetPageParam.getClassifyCode())
                .andEq(!StringUtils.isEmpty(complaintSetPageParam.getEnableFlag()), Q_COMPLAINT_SET_DO.enableFlag, complaintSetPageParam.getEnableFlag())
                .andIn(Q_COMPLAINT_SET_DO.deleteFlag, Arrays.asList(0, 1))
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_COMPLAINT_SET_DO)
                .where(predicate)
                .orderBy(Q_COMPLAINT_SET_DO.sortNo.desc())
                .fetch();
    }

    public List<ComplaintSetVO> complaintSetExist(ComplaintSetParam complaintSetParam) {
        Predicate predicateExist = Q_COMPLAINT_SET_DO.isNotNull();
        if (!StringUtils.isEmpty(complaintSetParam.getComplaintType())) {
            predicateExist = ExpressionUtils.and(predicateExist, Q_COMPLAINT_SET_DO.complaintType.eq(complaintSetParam.getComplaintType()));
        }
        if (!StringUtils.isEmpty(complaintSetParam.getClassifyCode()) && !StringUtils.isEmpty(complaintSetParam.getClassifyName())) {
            predicateExist = ExpressionUtils.and(predicateExist, Q_COMPLAINT_SET_DO.classifyCode.eq(complaintSetParam.getClassifyCode()).or(Q_COMPLAINT_SET_DO.classifyName.eq(complaintSetParam.getClassifyName())));
        }

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_COMPLAINT_SET_DO)
                .where(predicateExist)
                .orderBy(Q_COMPLAINT_SET_DO.sortNo.desc())
                .fetch();
    }

    public void complaintSetDelete(List<Long> ids) {
        Predicate predicate = Q_COMPLAINT_SET_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_SET_DO)
                .set(Q_COMPLAINT_SET_DO.deleteFlag, 1)
                .where(ExpressionUtils.and(predicate, Q_COMPLAINT_SET_DO.id.in(ids)));
        jpaUpdateClause.execute();
    }

    public void complaintSetEnabledToC(String enableFlag, String complaintType, String classifyCode) {
        Predicate predicate = Q_COMPLAINT_SET_DO.isNotNull();
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(Q_COMPLAINT_SET_DO)
                .set(Q_COMPLAINT_SET_DO.enableFlag, enableFlag)
                .where(ExpressionUtils.and(predicate, Q_COMPLAINT_SET_DO.complaintType.eq(complaintType)))
                .where(ExpressionUtils.and(predicate, Q_COMPLAINT_SET_DO.classifyCode.eq(classifyCode)));
        jpaUpdateClause.execute();
    }

    private QBean<ComplaintSetVO> fieldsOfYstDemoDTO() {
        return Projections.bean(ComplaintSetVO.class,
                Q_COMPLAINT_SET_DO.id,
                Q_COMPLAINT_SET_DO.updater,
                Q_COMPLAINT_SET_DO.secUserId,
                Q_COMPLAINT_SET_DO.secBuId,
                Q_COMPLAINT_SET_DO.secOuId,
                Q_COMPLAINT_SET_DO.deleteFlag,
                Q_COMPLAINT_SET_DO.creator,
                Q_COMPLAINT_SET_DO.createTime,
                Q_COMPLAINT_SET_DO.createUserId,
                Q_COMPLAINT_SET_DO.classifyCode,
                Q_COMPLAINT_SET_DO.classifyName,
                Q_COMPLAINT_SET_DO.complaintType,
                Q_COMPLAINT_SET_DO.enableFlag,
                Q_COMPLAINT_SET_DO.maxResp,
                Q_COMPLAINT_SET_DO.maxHandle,
                Q_COMPLAINT_SET_DO.issueDesc,
                Q_COMPLAINT_SET_DO.sortNo,
                Q_COMPLAINT_SET_DO.pid
        );
    }

    public List<ComplaintSetVO> businessComplaintSetQueryBase() {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(Q_COMPLAINT_SET_DO.complaintType, "2")
                .andEq(Q_COMPLAINT_SET_DO.pid, 0L)
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_COMPLAINT_SET_DO)
                .where(predicate)
                .orderBy(Q_COMPLAINT_SET_DO.sortNo.desc())
                .fetch();
    }


    public List<ComplaintSetVO> businessComplaintSetQuerySub(Long id) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(Q_COMPLAINT_SET_DO.complaintType, "2")
                .andEq(Q_COMPLAINT_SET_DO.pid, id)
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_COMPLAINT_SET_DO)
                .where(predicate)
                .orderBy(Q_COMPLAINT_SET_DO.sortNo.desc())
                .fetch();
    }

    public List<ComplaintSetVO> businessComplaintSetExist(BusinessComplaintSetParam businessComplaintSetParam) {
        Predicate predicateExist = Q_COMPLAINT_SET_DO.isNotNull();
        predicateExist = ExpressionUtils.and(predicateExist, Q_COMPLAINT_SET_DO.complaintType.eq("2"));
        if (!StringUtils.isEmpty(businessComplaintSetParam.getClassifyCode()) && !StringUtils.isEmpty(businessComplaintSetParam.getClassifyName())) {
            predicateExist = ExpressionUtils.and(predicateExist, Q_COMPLAINT_SET_DO.classifyCode.eq(businessComplaintSetParam.getClassifyCode()).or(Q_COMPLAINT_SET_DO.classifyName.eq(businessComplaintSetParam.getClassifyName())));
        }

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(Q_COMPLAINT_SET_DO)
                .where(predicateExist)
                .orderBy(Q_COMPLAINT_SET_DO.sortNo.desc())
                .fetch();
    }
}
