package com.elitesland.yst.production.aftersale.util;

import lombok.Getter;

/**
 * @ProjectName: yst-dch-score
 * @Package: com.elitesland.common
 * @ClassName: UdcEnum
 * @Author: chen
 * @Description: udc枚举
 * @Date: 2020/7/7 15:22
 * @Version: 1.0
 */
@Getter
public enum UdcEnum {
    //数据库sql拼接：SELECT CONCAT(domain_code,'_',udc_code,'_',udc_val,'("',domain_code,'","',udc_code,'","',udc_name,'","',udc_val,'","',val_desc,'"),') FROM sys_udc ORDER BY domain_code,udc_name
    REPAIR_ORDER_JSS001("yst-after-sale", "REPAIR_ORDER", "维修工单状态", "JSS001", "待维修"),
    REPAIR_ORDER_JSS002("yst-after-sale", "REPAIR_ORDER", "维修工单状态", "JSS002", "维修中"),
    REPAIR_ORDER_JSS003("yst-after-sale", "REPAIR_ORDER", "维修工单状态", "JSS003", "已完成"),
    REPAIR_ORDER_JSS004("yst-after-sale", "REPAIR_ORDER", "维修工单状态", "JSS004", "已取消"),
    COMPLAINT_ORDER_KSS001("yst-after-sale", "COMPLAINT_ORDER", "客诉工单状态", "KSS001", "待受理"),
    COMPLAINT_ORDER_KSS002("yst-after-sale", "COMPLAINT_ORDER", "客诉工单状态", "KSS002", "受理中"),
    COMPLAINT_ORDER_KSS003("yst-after-sale", "COMPLAINT_ORDER", "客诉工单状态", "KSS003", "已完成"),
    COMPLAINT_ORDER_KSS004("yst-after-sale", "COMPLAINT_ORDER", "客诉工单状态", "KSS004", "已取消"),
    COMPLAINT_ORDER_KSS005("yst-after-sale", "COMPLAINT_ORDER", "客诉工单状态", "KSS005", "待评价"),
    PICTURE_ORDER_TYPE_1("yst-after-sale", "PICTURE_ORDER_TYPE", "图片工单类型", "1", "维修工单"),
    PICTURE_ORDER_TYPE_2("yst-after-sale", "PICTURE_ORDER_TYPE", "图片工单类型", "2", "客诉工单"),
    PICTURE_ORDER_TYPE_3("yst-after-sale", "PICTURE_ORDER_TYPE", "图片工单类型", "3", "评论图片"),
    PICTURE_ORDER_TYPE_4("yst-after-sale", "PICTURE_ORDER_TYPE", "图片工单类型", "4", "客诉解决图片"),
    PICTURE_ORDER_TYPE_5("yst-after-sale", "PICTURE_ORDER_TYPE", "图片工单类型", "5", "车辆绑定图片"),
    PICTURE_ORDER_TYPE_6("yst-after-sale", "PICTURE_ORDER_TYPE", "图片工单类型", "6", "配件故障图片"),
    ISSUE_TYPE_ISS001("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS001", "质量问题"),
    ISSUE_TYPE_ISS002("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS002", "配件问题"),
    ISSUE_TYPE_ISS003("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS003", "服务问题"),
    ISSUE_TYPE_ISS004("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS004", "与商品描述不符"),
    ISSUE_TYPE_ISS005("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS005", "包装/商品残破"),
    ISSUE_TYPE_ISS006("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS006", "发票问题"),
    ISSUE_TYPE_ISS007("yst-after-sale", "ISSUE_TYPE", "客诉问题类型", "ISS007", "其它"),
    EVALUATION_LEVEL_1("yst-after-sale", "EVALUATION_LEVEL", "评价级别", "1", "满意"),
    EVALUATION_LEVEL_2("yst-after-sale", "EVALUATION_LEVEL", "评价级别", "2", "不满意"),
    EVALUATION_ORDER_TYPE_1("yst-after-sale", "EVALUATION_ORDER_TYPE", "评论工单类型", "1", "维修工单"),
    EVALUATION_ORDER_TYPE_2("yst-after-sale", "EVALUATION_ORDER_TYPE", "评论工单类型", "2", "客诉工单"),
    COMPLAINT_TYPE_1("yst-after-sale", "COMPLAINT_TYPE", "客诉类型", "1", "C端投诉"),
    COMPLAINT_TYPE_2("yst-after-sale", "COMPLAINT_TYPE", "客诉类型", "2", "B端投诉"),

    PARTS_SERVICE_TYPE_1("yst-after-sale", "PARTS_SERVICE", "配件服务类型", "1", "配件服务"),
    PARTS_SERVICE_TYPE_2("yst-after-sale", "PARTS_SERVICE", "配件服务类型", "2", "增值服务"),

    ORDER_TYPE_1("yst-after-sale", "ORDER_TYPE", "日志工单类型", "1", "维修工单"),
    ORDER_TYPE_2("yst-after-sale", "ORDER_TYPE", "日志工单类型", "2", "客诉工单"),
    SEX_0("yst-after-sale", "SEX", "性别", "0", "女"),
    SEX_1("yst-after-sale", "SEX", "性别", "1", "男"),
    ENABLED_FLAG_0("yst-after-sale", "ENABLED_FLAG", "启用状态", "1", "启用"),
    ENABLED_FLAG_1("yst-after-sale", "ENABLED_FLAG", "启用状态", "0", "禁用"),

    VEHICLE_SOURCE_0("yst-after-sale", "VEHICLE_SOURCE", "车辆来源", "0", "非立马品牌"),
    VEHICLE_SOURCE_1("yst-after-sale", "VEHICLE_SOURCE", "车辆来源", "1", "立马品牌"),

    RETURN_LEVEL_1("yst-after-sale", "RETURN_LEVEL", "回访满意度", "1", "十分满意"),
    RETURN_LEVEL_2("yst-after-sale", "RETURN_LEVEL", "回访满意度", "2", "满意"),
    RETURN_LEVEL_3("yst-after-sale", "RETURN_LEVEL", "回访满意度", "3", "不满意"),

    CANCEL_REASON_B_1("yst-after-sale", "CANCEL_REASON_B", "B端取消原因", "CB001", "B端测试原因1"),
    CANCEL_REASON_B_2("yst-after-sale", "CANCEL_REASON_B", "B端取消原因", "CB002", "B端测试原因2"),
    CANCEL_REASON_B_3("yst-after-sale", "CANCEL_REASON_B", "B端取消原因", "CB003", "其他"),

    CANCEL_REASON_C_1("yst-after-sale", "CANCEL_REASON_C", "C端取消原因", "CC001", "C端测试原因1"),
    CANCEL_REASON_C_2("yst-after-sale", "CANCEL_REASON_C", "C端取消原因", "CC002", "C端测试原因2"),
    CANCEL_REASON_C_3("yst-after-sale", "CANCEL_REASON_C", "C端取消原因", "CC003", "其他"),

    BASIC_SET_COMPLAINT("yst-after-sale", "BASIC_SET", "基本设置", "COMPLAINT", "客诉工单默认评价时间"),
    BASIC_SET_REPAIR("yst-after-sale", "BASIC_SET", "基本设置", "REPAIR", "维修工单默认评价时间"),
    BASIC_SET_ENABLE("yst-after-sale", "BASIC_SET", "基本设置", "ENABLE", "是否开启客诉"),

    TIMEOUT_STATUS_1("yst-after-sale", "TIMEOUT_STATUS", "时效状态", "1", "正常"),
    TIMEOUT_STATUS_2("yst-after-sale", "TIMEOUT_STATUS", "时效状态", "2", "响应超时"),
    TIMEOUT_STATUS_3("yst-after-sale", "TIMEOUT_STATUS", "时效状态", "3", "处理超时"),


    CUST_TYPE_CUST("yst-after-sale", "CUST_TYPE", "客户类型", "CUST", "客户"),
    CUST_TYPE_INTENDED_USER("yst-after-sale", "CUST_TYPE", "客户类型", "INTENDED_USER", "意向用户"),
    CUST_TYPE_OTHER("yst-after-sale", "CUST_TYPE", "客户类型", "OTHER", "其他"),
    CUST_TYPE_USER("yst-after-sale", "CUST_TYPE", "客户类型", "USER", "用户"),


    CALL_TYPE_OTHER("yst-after-sale", "CALL_TYPE", "来电类型", "OTHER", "其他"),
    CALL_TYPE_COMPLAINT("yst-after-sale", "CALL_TYPE", "来电类型", "COMPLAINT", "投诉"),
    CALL_TYPE_CONSULT("yst-after-sale", "CALL_TYPE", "来电类型", "CONSULT", "咨询"),
    CALL_TYPE_FOLLOW_UP("yst-after-sale", "CALL_TYPE", "来电类型", "FOLLOW_UP", "回访"),
    CALL_TYPE_JOIN("yst-after-sale", "CALL_TYPE", "来电类型", "JOIN", "加盟"),
    CALL_TYPE_QUALITY("yst-after-sale", "CALL_TYPE", "来电类型", "QUALITY", "品质"),


    ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }


}
