/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.model.Result;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserAccountDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignRecipientUserDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.config.AuthorizationServiceConfiguration;
import com.elitesland.yst.production.aftersale.convert.ComplaintOrderConvert;
import com.elitesland.yst.production.aftersale.convert.PictureOrderConvert;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.ComplaintOrderDO;
import com.elitesland.yst.production.aftersale.model.entity.OrderEvaluationDO;
import com.elitesland.yst.production.aftersale.model.entity.orderlog.OrderLogDO;
import com.elitesland.yst.production.aftersale.model.entity.picture.PictureOrderDO;
import com.elitesland.yst.production.aftersale.model.param.CarParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderCancelParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderExlParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderPageParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintOrderParam;
import com.elitesland.yst.production.aftersale.model.param.ComplaintSetPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderEvaluationParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.OrderLogSaveParam;
import com.elitesland.yst.production.aftersale.model.param.PictureOrderParam;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.model.vo.CarVO;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.ComplaintSetVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderEvaluationVO;
import com.elitesland.yst.production.aftersale.model.vo.OrderLogVO;
import com.elitesland.yst.production.aftersale.model.vo.PictureOrderVO;
import com.elitesland.yst.production.aftersale.model.vo.RepairOrderVO;
import com.elitesland.yst.production.aftersale.out.sys.SystemService;
import com.elitesland.yst.production.aftersale.provider.support.OrgStoreRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysMsgRpcProvider;
import com.elitesland.yst.production.aftersale.provider.system.SysUserPermissionRpcProvider;
import com.elitesland.yst.production.aftersale.service.CarService;
import com.elitesland.yst.production.aftersale.service.ComplaintOrderService;
import com.elitesland.yst.production.aftersale.service.OrderEvaluationService;
import com.elitesland.yst.production.aftersale.service.OrderLogService;
import com.elitesland.yst.production.aftersale.service.PictureOrderService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.CarMaintainCardRepo;
import com.elitesland.yst.production.aftersale.service.repo.CarOwnerVehicleRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintOrderRepo;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintOrderRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepo;
import com.elitesland.yst.production.aftersale.service.repo.ComplaintSetRepoProc;
import com.elitesland.yst.production.aftersale.service.repo.PictureOrderRepo;
import com.elitesland.yst.production.aftersale.util.NumSendEnum;
import com.elitesland.yst.production.aftersale.util.UdcEnum;
import com.elitesland.yst.production.order.rpc.LmVehicleNoRpcService;
import com.elitesland.yst.production.order.rpc.param.LmAfterSaleTimeParam;
import com.elitesland.yst.production.order.rpc.param.resp.LmVehicleNoTimeDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.dto.CrmCustDTO;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.elitesland.yst.production.sale.service.CrmCustRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ComplaintOrderServiceImpl
implements ComplaintOrderService {
    private static final Logger log = LogManager.getLogger(ComplaintOrderServiceImpl.class);
    @Autowired
    private ComplaintOrderRepo complaintOrderRepo;
    @Autowired
    private ComplaintOrderRepoProc complaintOrderRepoProc;
    @Autowired
    private CarOwnerVehicleRepoProc carOwnerVehicleRepoProc;
    @Autowired
    private PictureOrderRepo pictureOrderRepo;
    @Autowired
    private PictureOrderService pictureOrderService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private CarService carService;
    @Autowired
    private OrderEvaluationService orderEvaluationService;
    @Autowired
    private OrderLogService orderLogService;
    @Autowired
    private UserService userService;
    @Autowired
    private ComplaintSetRepoProc complaintSetRepoProc;
    @Autowired
    private ComplaintSetRepo complaintSetRepo;
    @Autowired
    private SysMsgRpcProvider sysMsgRpcProvider;
    @Autowired
    private SysUserPermissionRpcProvider sysUserPermissionRpcProvider;
    @Autowired
    private AuthorizationServiceConfiguration authorizationServiceConfiguration;
    @Autowired
    private OrgStoreRpcProvider orgStoreRpcProvider;
    @Autowired
    private LmVehicleNoRpcService vehicleNoRpcService;
    @Autowired
    private CarMaintainCardRepo carMaintainCardRepo;
    @Autowired
    private CrmCustAccountRpcService crmCustAccountRpcService;
    @Autowired
    private CrmCustRpcService crmCustRpcService;
    @Value(value="${file.upload.url}")
    private String pictureURL;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String COMPLETE = "\u5de5\u5355\u5b8c\u6210";
    private static final String CANCEL = "\u5de5\u5355\u53d6\u6d88";
    private static final String COMMIT = "\u5de5\u5355\u63d0\u4ea4";
    private static final String DELETE = "\u5de5\u5355\u5220\u9664";
    private static final String DISPATCH = "\u6d3e\u5355";
    private static final String RETURN_APPLY = "\u5de5\u5355\u56de\u8bbf";
    private static final String REPAIR = "REPAIR";
    private static final String COMPLAINT = "COMPLAINT";
    private static final String EVALUATION = "\u5de5\u5355\u8bc4\u8bba";
    private static final String EVALUATION_CONTENT = "\u7cfb\u7edf\u9ed8\u8ba4\u597d\u8bc4";
    private static final String EVALUATION_CONTENT_LOG = "\u8bc4\u8bba\u7ea7\u522b\uff1a\u6ee1\u610f \u8bc4\u8bba\u5185\u5bb9\uff1a\u7cfb\u7edf\u9ed8\u8ba4\u597d\u8bc4";
    private static final String SYSTEM_USER = "\u7cfb\u7edf\u7ba1\u7406\u5458";
    private static final Integer LIMIT = 1000;
    private static final String SYSTEM_ROLE_CODE = "ROLE_admin";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ComplaintOrderParam saveVO) {
        log.info("\u5ba2\u8bc9\u5de5\u5355\u4fdd\u5b58\u5165\u53c2", (Object)JSON.toJSONString((Object)saveVO));
        this.check(saveVO);
        SysUserDTO user = this.userService.getUserDetail();
        if (!StringUtils.isEmpty((CharSequence)user.getUsername()) && user.getUsername().length() == 6) {
            List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOS = this.orgStoreRpcProvider.queryByStoreCodes(List.of(user.getUsername()));
            if (!CollectionUtils.isEmpty(orgStoreDetailRpcDTOS)) {
                OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreDetailRpcDTOS.get(0);
                saveVO.setCustName(orgStoreDetailRpcDTO.getCustName());
            }
        } else if (!StringUtils.isEmpty((CharSequence)user.getUsername()) && user.getUsername().length() > 6 && UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(saveVO.getOrderType())) {
            CustAccountVO custAccount = this.crmCustAccountRpcService.getCustAccountByUserId(user.getId());
            if (custAccount != null && custAccount.getSubAcFlag().booleanValue()) {
                String pcustCode = custAccount.getCustCode();
                ApiResult pcustInfoRpc = this.crmCustRpcService.getCustInfo(pcustCode);
                if (pcustInfoRpc.isSuccess() && pcustInfoRpc.getData() != null) {
                    CrmCustDTO data = (CrmCustDTO)pcustInfoRpc.getData();
                    saveVO.setCustName(data.getCustName());
                }
            } else {
                saveVO.setCustName(user.getPrettyName());
            }
        }
        if (saveVO.getId() != null && saveVO.getId() != 0L) {
            this.pictureOrderRepo.deleteByOrderId(saveVO.getId());
        } else {
            String orderNo = this.systemService.sysNumberRuleGenerateCode(NumSendEnum.LMK.getCode(), new ArrayList<String>());
            saveVO.setOrderNo(orderNo);
            log.info("\u5ba2\u8bc9\u5de5\u5355\u53d1\u53f7\uff1a{}", (Object)orderNo);
            saveVO.setCarOwnerId(user.getId());
            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(saveVO.getOrderType())) {
                saveVO.setOrderPerson(user.getPrettyName());
            }
            saveVO.setOrderTel(user.getMobile());
            saveVO.setOrderStatus(UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode());
            saveVO.setTimeoutStatus(UdcEnum.TIMEOUT_STATUS_1.getValueCode());
        }
        ComplaintOrderDO complaintOrderDO = ComplaintOrderConvert.INSTANCE.saveVoTODO(saveVO);
        Long id = ((ComplaintOrderDO)this.complaintOrderRepo.save(complaintOrderDO)).getId();
        List<PictureOrderParam> pictureOrderParamList = saveVO.getPictureOrderParamList();
        if (!CollectionUtils.isEmpty(pictureOrderParamList)) {
            List collect = pictureOrderParamList.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO((PictureOrderParam)t);
                pictureOrderDO.setOrderId(id);
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            this.pictureOrderRepo.saveAll(collect);
        }
        if (null == saveVO.getId()) {
            OrderLogSaveParam param = new OrderLogSaveParam(id, UdcEnum.ORDER_TYPE_2.getValueCode(), COMMIT, LocalDateTime.now(), user.getUsername(), user.getId());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(saveVO.getOrderType())) {
                param.setRemark("\u8f66\u4e3b" + user.getUsername() + "\u63d0\u4ea4\u4e86\u5ba2\u8bc9\u5de5\u5355");
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(saveVO.getOrderType())) {
                param.setRemark("\u7ecf\u9500\u5546(\u95e8\u5e97)" + user.getLastName() + "\u63d0\u4ea4\u4e86\u5ba2\u8bc9\u5de5\u5355");
            }
            this.orderLogService.orderLogSave(param);
            saveVO.setId(id);
            this.sendCreateMsg(saveVO);
        }
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintOrderBatchCancel(List<Long> ids) {
        log.info("\u5ba2\u8bc9\u5de5\u5355\u6279\u91cf\u53d6\u6d88\u5165\u53c2", ids);
        if (ids == null || ids.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.complaintOrderRepoProc.batchCancel(ids);
        SysUserDTO user = this.userService.getUserDetail();
        ids.forEach(item -> {
            OrderLogSaveParam param = new OrderLogSaveParam((Long)item, UdcEnum.ORDER_TYPE_2.getValueCode(), CANCEL, LocalDateTime.now(), user.getUsername(), user.getId());
            this.orderLogService.orderLogSave(param);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintOrderCancel(ComplaintOrderCancelParam param) {
        log.info("\u5ba2\u8bc9\u5de5\u5355\u53d6\u6d88\u5165\u53c2", (Object)param);
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        ComplaintOrderDO oldOrder = this.complaintOrderRepo.findById(param.getId()).orElse(null);
        if (null == oldOrder || null != oldOrder.getOrderStatus() && !UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode().equals(oldOrder.getOrderStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u5f85\u53d7\u7406\u72b6\u6001\u624d\u80fd\u53d6\u6d88");
        }
        this.complaintOrderRepoProc.cancel(param);
        SysUserDTO user = this.userService.getUserDetail();
        Object remark = "\u53d6\u6d88\u539f\u56e0\uff1a";
        if (null != param.getCancelReasonC()) {
            remark = (String)remark + this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode()).get(param.getCancelReasonC());
        } else if (null != param.getCancelReasonB()) {
            remark = (String)remark + this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode()).get(param.getCancelReasonB());
        }
        if (null != param.getCancelDetail()) {
            remark = (String)remark + " \u8be6\u7ec6\u4fe1\u606f\uff1a" + param.getCancelDetail();
        }
        OrderLogSaveParam orderLogSaveParam = new OrderLogSaveParam(param.getId(), UdcEnum.ORDER_TYPE_2.getValueCode(), CANCEL, LocalDateTime.now(), user.getUsername(), user.getId());
        orderLogSaveParam.setRemark((String)remark);
        this.orderLogService.orderLogSave(orderLogSaveParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintOrderDelete(List<Long> ids) {
        log.info("\u5ba2\u8bc9\u5de5\u5355\u5220\u9664\u5165\u53c2", ids);
        if (ids == null || ids.isEmpty()) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.complaintOrderRepoProc.deleteComplaint(ids);
        SysUserDTO user = this.userService.getUserDetail();
        ids.forEach(item -> {
            OrderLogSaveParam param = new OrderLogSaveParam((Long)item, UdcEnum.ORDER_TYPE_2.getValueCode(), DELETE, LocalDateTime.now(), user.getUsername(), user.getId());
            this.orderLogService.orderLogSave(param);
        });
    }

    @Override
    public PagingVO<ComplaintOrderVO> query(ComplaintOrderPageParam param) {
        Long userId = this.userService.getUserId();
        if ("PC".equals(param.getSource())) {
            param.setCarOwnerId(null);
            if (!this.userService.getUserDetail().getRoleCodes().contains(SYSTEM_ROLE_CODE)) {
                param.setHandlePersonId(userId);
            }
        } else {
            param.setCarOwnerId(userId);
        }
        PagingVO<ComplaintOrderVO> complaintOrderVOS = null;
        if (UdcEnum.COMPLAINT_ORDER_KSS005.getValueCode().equals(param.getOrderStatus())) {
            param.setOrderStatus(UdcEnum.COMPLAINT_ORDER_KSS003.getValueCode());
            complaintOrderVOS = this.complaintOrderRepoProc.unEvaluationQuery(param);
        } else {
            complaintOrderVOS = this.complaintOrderRepoProc.query(param);
        }
        if (CollectionUtils.isEmpty((Collection)complaintOrderVOS.getRecords())) {
            return complaintOrderVOS;
        }
        this.pictureQuery(complaintOrderVOS.getRecords());
        this.evaluationQuery(complaintOrderVOS.getRecords());
        this.setQuery(complaintOrderVOS.getRecords());
        this.udcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    @Override
    public ComplaintOrderVO queryInfo(ComplaintOrderPageParam param) {
        OrderLogVO orderLogVO;
        if (param.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ComplaintOrderVO complaintOrderVO = this.complaintOrderRepoProc.queryInfo(param);
        if (!StringUtils.isEmpty((CharSequence)complaintOrderVO.getVehicleNo())) {
            CarMaintainCardDO carMaintainCardDO;
            LmVehicleNoTimeDTO vehicleNo;
            CarOwnerVehicleInfoVO byVerNo = this.carOwnerVehicleRepoProc.getByVerNo(complaintOrderVO.getVehicleNo());
            if (byVerNo != null) {
                complaintOrderVO.setVehicleColor(byVerNo.getVehicleColor());
                complaintOrderVO.setItemCode(byVerNo.getItemCode());
                complaintOrderVO.setVehicleType(byVerNo.getVehicleType());
                complaintOrderVO.setActivatTime(byVerNo.getActivatTime());
                complaintOrderVO.setManufactureDate(byVerNo.getManufactureDate());
            } else {
                CarParam carParam = new CarParam();
                carParam.setVehicleNo(complaintOrderVO.getVehicleNo());
                ApiResult<CarVO> query = null;
                try {
                    query = this.carService.query(carParam);
                }
                catch (Exception e) {
                    log.info("\u6839\u636e\u8f66\u67b6\u53f7\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
                }
                if (query != null && query.getCode() == ApiCode.SUCCESS.getCode() && query.getData() != null) {
                    CarVO carVo = (CarVO)query.getData();
                    complaintOrderVO.setVehicleColor(carVo.getVehicleColor());
                    complaintOrderVO.setManufactureDate(carVo.getManufactureDate());
                    complaintOrderVO.setDocTime(carVo.getDocTime());
                    complaintOrderVO.setVehicleType(carVo.getVehicleType());
                    complaintOrderVO.setBindingTime(carVo.getBindingTime());
                    complaintOrderVO.setItemCode(carVo.getMtnrv());
                }
            }
            String veNo = complaintOrderVO.getVehicleNo();
            if (complaintOrderVO.getDocTime() == null && (vehicleNo = this.vehicleNoRpcService.getDocTimeByVehicle(veNo)) != null) {
                complaintOrderVO.setManufactureDate(vehicleNo.getOfflineTime());
                complaintOrderVO.setDocTime(vehicleNo.getDocTime());
            }
            if (complaintOrderVO.getBindActiveTime() == null && (carMaintainCardDO = this.carMaintainCardRepo.findByVehicleNoAndDeleteFlag(veNo, 0)) != null) {
                complaintOrderVO.setBindActiveTime(carMaintainCardDO.getCreateTime());
            }
        }
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(param.getId());
        pictureOrderParam.setOrderList(idList);
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
        }
        if (!CollectionUtils.isEmpty((Collection)data)) {
            complaintOrderVO.setPictureOrderVOS(data.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
            complaintOrderVO.setCompletePictureVOS(data.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
        }
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderId(param.getId());
        orderEvaluationParam.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode());
        OrderEvaluationVO orderEvaluationVO = this.orderEvaluationService.query(orderEvaluationParam);
        complaintOrderVO.setOrderEvaluationVO(orderEvaluationVO);
        OrderLogPageParam orderLogPageParam = new OrderLogPageParam();
        orderLogPageParam.setOrderId(param.getId());
        orderLogPageParam.setOrderType(UdcEnum.ORDER_TYPE_2.getValueCode());
        List<OrderLogVO> logs = this.orderLogService.query(orderLogPageParam);
        complaintOrderVO.setOrderLogs(logs);
        ArrayList<OrderLogVO> replyLogs = new ArrayList<OrderLogVO>();
        if (null != orderEvaluationVO && StringUtils.isNotEmpty((CharSequence)orderEvaluationVO.getReturnReply())) {
            orderLogVO = new OrderLogVO();
            orderLogVO.setOperationTime(orderEvaluationVO.getModifyTime());
            orderLogVO.setRemark(orderEvaluationVO.getReturnReply());
            replyLogs.add(orderLogVO);
        }
        if (StringUtils.isNotEmpty((CharSequence)complaintOrderVO.getHandleReply())) {
            orderLogVO = new OrderLogVO();
            orderLogVO.setOperationTime(complaintOrderVO.getCompleteTime());
            orderLogVO.setRemark(complaintOrderVO.getHandleReply());
            replyLogs.add(orderLogVO);
        }
        complaintOrderVO.setReplies(replyLogs);
        if (!replyLogs.isEmpty()) {
            complaintOrderVO.setLatestReply(((OrderLogVO)((Object)replyLogs.get(0))).getRemark());
        }
        ArrayList<ComplaintOrderVO> list = new ArrayList<ComplaintOrderVO>();
        list.add(complaintOrderVO);
        this.setQuery(list);
        this.udcTranslate(list);
        return complaintOrderVO;
    }

    @Override
    public PagingVO<ComplaintOrderVO> export(ComplaintOrderExlParam complaintOrderExlParam) {
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setOrderType(complaintOrderExlParam.getOrderType());
        complaintOrderPageParam.setIdList(complaintOrderExlParam.getIdList());
        complaintOrderPageParam.setOrderNo(complaintOrderExlParam.getOrderNo());
        complaintOrderPageParam.setOrderStatus(complaintOrderExlParam.getOrderStatus());
        complaintOrderPageParam.setOrderTel(complaintOrderExlParam.getOrderTel());
        complaintOrderPageParam.setOrderPerson(complaintOrderExlParam.getOrderPerson());
        complaintOrderPageParam.setIssueType(complaintOrderExlParam.getIssueType());
        complaintOrderPageParam.setStartTime(complaintOrderExlParam.getStartTime());
        complaintOrderPageParam.setEndTime(complaintOrderExlParam.getEndTime());
        complaintOrderPageParam.setCurrent(complaintOrderExlParam.getCurrent());
        complaintOrderPageParam.setSize(complaintOrderExlParam.getSize());
        complaintOrderPageParam.setOrders(complaintOrderExlParam.getOrders());
        complaintOrderPageParam.setVehicleType(complaintOrderExlParam.getVehicleType());
        complaintOrderPageParam.setBindingTimeStart(complaintOrderExlParam.getBindingTimeStart());
        complaintOrderPageParam.setBindingTimeEnd(complaintOrderExlParam.getBindingTimeEnd());
        complaintOrderPageParam.setVehicleNo(complaintOrderExlParam.getVehicleNo());
        complaintOrderPageParam.setActivatTimeStart(complaintOrderExlParam.getActivatTimeStart());
        complaintOrderPageParam.setActivatTimeEnd(complaintOrderExlParam.getActivatTimeEnd());
        complaintOrderPageParam.setCustName(complaintOrderExlParam.getCustName());
        PagingVO<ComplaintOrderVO> complaintOrderVOS = this.complaintOrderRepoProc.exportQuery(complaintOrderPageParam);
        this.setQuery(complaintOrderVOS.getRecords());
        complaintOrderVOS.getRecords().forEach(x -> {
            if (StringUtils.isNotEmpty((CharSequence)x.getEvaluationLevel())) {
                x.setEvaluationStatus("\u5df2\u8bc4\u4ef7");
            } else {
                x.setEvaluationStatus("\u5f85\u8bc4\u4ef7");
            }
            x.setFeedbackPerson(x.getOrderPerson());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(x.getOrderType())) {
                x.setSource("\u8f66\u4e3b");
            }
            if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(x.getOrderType())) {
                x.setSource("\u7ecf\u9500\u5546");
            }
        });
        this.docTimeQuery(complaintOrderVOS, complaintOrderPageParam);
        this.udcTranslate(complaintOrderVOS.getRecords());
        this.evaluationUdcTranslate(complaintOrderVOS.getRecords());
        return complaintOrderVOS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintOrderDispatch(ComplaintOrderParam saveVO) {
        if (null == saveVO.getId()) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ComplaintOrderDO oldOrder = this.complaintOrderRepo.findById(saveVO.getId()).orElse(null);
        if (null == oldOrder || null != oldOrder.getOrderStatus() && !UdcEnum.COMPLAINT_ORDER_KSS001.getValueCode().equals(oldOrder.getOrderStatus()) && !UdcEnum.COMPLAINT_ORDER_KSS002.getValueCode().equals(oldOrder.getOrderStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u5f85\u53d7\u7406\u548c\u53d7\u7406\u4e2d\u72b6\u6001\u624d\u80fd\u6d3e\u5355");
        }
        SysUserDTO user = this.userService.getUserDetail();
        saveVO.setDispatchPersonId(user.getId());
        this.complaintOrderRepoProc.complaintOrderDispatch(saveVO);
        OrderLogSaveParam param = new OrderLogSaveParam(saveVO.getId(), UdcEnum.ORDER_TYPE_2.getValueCode(), DISPATCH, LocalDateTime.now(), user.getUsername(), user.getId());
        param.setRemark("\u6307\u6d3e\uff1a" + saveVO.getHandlePersonName() + ",\u5904\u7406,\u8054\u7cfb\u7535\u8bdd:" + saveVO.getHandlePersonTel());
        this.orderLogService.orderLogSave(param);
        oldOrder.setHandlePersonId(saveVO.getHandlePersonId());
        this.sendDispatchMsg(oldOrder);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintOrderComplete(ComplaintOrderParam saveVO) {
        if (null == saveVO.getId()) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ComplaintOrderDO oldOrder = this.complaintOrderRepo.findById(saveVO.getId()).orElse(null);
        if (null == oldOrder || null != oldOrder.getOrderStatus() && !UdcEnum.COMPLAINT_ORDER_KSS002.getValueCode().equals(oldOrder.getOrderStatus())) {
            throw new BusinessException(ApiCode.FAIL, "\u53ea\u6709\u53d7\u7406\u72b6\u6001\u4e0b\u624d\u80fd\u5b8c\u6210");
        }
        SysUserDTO user = this.userService.getUserDetail();
        this.complaintOrderRepoProc.complaintOrderComplete(saveVO);
        List<PictureOrderParam> completePictures = saveVO.getCompletePictureVOS();
        if (!CollectionUtils.isEmpty(completePictures)) {
            List collect = completePictures.stream().map(t -> {
                PictureOrderDO pictureOrderDO = PictureOrderConvert.INSTANCE.saveVoTODO((PictureOrderParam)t);
                pictureOrderDO.setOrderId(saveVO.getId());
                pictureOrderDO.setOrderType(UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode());
                return pictureOrderDO;
            }).collect(Collectors.toList());
            this.pictureOrderRepo.saveAll(collect);
        }
        OrderLogSaveParam param = new OrderLogSaveParam(saveVO.getId(), UdcEnum.ORDER_TYPE_2.getValueCode(), COMPLETE, LocalDateTime.now(), user.getUsername(), user.getId());
        param.setRemark("\u5904\u7406\u56de\u590d\uff1a" + saveVO.getHandleReply());
        this.orderLogService.orderLogSave(param);
        this.sendCompleteMsg(oldOrder);
    }

    private void check(ComplaintOrderParam saveVO) {
        log.info("\u5ba2\u8bc9\u5de5\u5355\u63d0\u4ea4\u5165\u53c2", (Object)JSON.toJSONString((Object)saveVO));
        if (saveVO.getIssueType() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u95ee\u9898\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getIssueDescription() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u95ee\u9898\u63cf\u8ff0\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (saveVO.getOrderType() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba2\u8bc9\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    public void evaluationUdcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.EVALUATION_LEVEL_1.getModel(), UdcEnum.EVALUATION_LEVEL_1.getCode());
        Map<String, String> ajStatusMap2 = this.systemService.sysUdcGetCodeMap(UdcEnum.RETURN_LEVEL_1.getModel(), UdcEnum.RETURN_LEVEL_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(t.getEvaluationLevel())) {
                t.setEvaluationLevelName((String)ajStatusMap.get(t.getEvaluationLevel()));
            }
            if (!CollectionUtils.isEmpty((Map)ajStatusMap2) && ajStatusMap2.containsKey(t.getEvaluationLevel())) {
                t.setReturnLevelName((String)ajStatusMap2.get(t.getReturnLevel()));
            }
        });
    }

    public void udcTranslate(List<ComplaintOrderVO> complaintOrderVO) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_ORDER_KSS001.getModel(), UdcEnum.COMPLAINT_ORDER_KSS001.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(t.getOrderStatus())) {
                t.setOrderStatusName((String)ajStatusMap.get(t.getOrderStatus()));
            }
        });
        Map<String, String> ajStatusMap2 = this.systemService.sysUdcGetCodeMap(UdcEnum.TIMEOUT_STATUS_1.getModel(), UdcEnum.TIMEOUT_STATUS_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap2) && ajStatusMap2.containsKey(t.getTimeoutStatus())) {
                t.setTimeoutStatusName((String)ajStatusMap2.get(t.getTimeoutStatus()));
            }
        });
        Map<String, String> ajStatusMap3 = this.systemService.sysUdcGetCodeMap(UdcEnum.COMPLAINT_TYPE_1.getModel(), UdcEnum.COMPLAINT_TYPE_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap3) && ajStatusMap3.containsKey(t.getOrderType())) {
                t.setOrderTypeName((String)ajStatusMap3.get(t.getOrderType()));
            }
        });
        Map<String, String> ajStatusMap4 = this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_C_1.getModel(), UdcEnum.CANCEL_REASON_C_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap4) && ajStatusMap4.containsKey(t.getCancelReasonC())) {
                t.setCancelReasonCName((String)ajStatusMap4.get(t.getCancelReasonC()));
            }
        });
        Map<String, String> ajStatusMap5 = this.systemService.sysUdcGetCodeMap(UdcEnum.CANCEL_REASON_B_1.getModel(), UdcEnum.CANCEL_REASON_B_1.getCode());
        complaintOrderVO.stream().forEach(t -> {
            if (!CollectionUtils.isEmpty((Map)ajStatusMap5) && ajStatusMap5.containsKey(t.getCancelReasonB())) {
                t.setCancelReasonBName((String)ajStatusMap5.get(t.getCancelReasonB()));
            }
        });
    }

    public PagingVO<ComplaintOrderVO> docTimeQuery(PagingVO<ComplaintOrderVO> complaintOrderVOS, ComplaintOrderPageParam param) {
        List dtos;
        List vehicles = complaintOrderVOS.stream().map(ComplaintOrderVO::getVehicleNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (vehicles.isEmpty()) {
            return complaintOrderVOS;
        }
        HashMap<String, LmVehicleNoTimeDTO> vehicleInfoMap = new HashMap<String, LmVehicleNoTimeDTO>();
        LmAfterSaleTimeParam lmAfterSaleTimeParam = new LmAfterSaleTimeParam();
        lmAfterSaleTimeParam.setVehicles(vehicles);
        ApiResult docTimeByListVehicles = this.vehicleNoRpcService.getDocTimeByListVehicles(lmAfterSaleTimeParam);
        if (docTimeByListVehicles != null && (dtos = (List)docTimeByListVehicles.getData()) != null) {
            for (LmVehicleNoTimeDTO dto : dtos) {
                vehicleInfoMap.put(dto.getVehicleNo(), dto);
            }
        }
        complaintOrderVOS.getRecords().forEach(x -> {
            String vehicleNo = x.getVehicleNo();
            LmVehicleNoTimeDTO vehicleNoInfo = (LmVehicleNoTimeDTO)vehicleInfoMap.get(vehicleNo);
            if (vehicleNoInfo != null) {
                x.setDocTime(vehicleNoInfo.getDocTime());
                x.setManufactureDate(vehicleNoInfo.getOfflineTime());
                x.setItemCode(vehicleNoInfo.getItemCode());
            }
        });
        return complaintOrderVOS;
    }

    public void setQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        if (complaintOrderVOS.isEmpty()) {
            return;
        }
        String sql = "SELECT * FROM complaint_set";
        List complaintSetVOS = this.jdbcTemplate.query(sql, (RowMapper)new BeanPropertyRowMapper(ComplaintSetVO.class));
        complaintOrderVOS.forEach(t -> complaintSetVOS.forEach(set -> {
            List<ComplaintSetVO> complaintOrders;
            if (t.getIssueType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null && String.valueOf(set.getId()).equals(t.getIssueType()) && set.getComplaintType().equals(t.getOrderType())) {
                complaintOrders = this.getAllItems(complaintSetVOS, set.getId());
                t.setIssueTypeName(this.getAllClassifyName(complaintOrders));
            }
            if (t.getConfirmType() != null && t.getOrderType() != null && set.getId() != null && set.getComplaintType() != null) {
                if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("2")) {
                    complaintOrders = this.getAllItems(complaintSetVOS, set.getId());
                    t.setConfirmTypeName(this.getAllClassifyName(complaintOrders));
                } else if (String.valueOf(set.getId()).equals(t.getConfirmType()) && t.getOrderType().equals("1")) {
                    t.setConfirmTypeName(set.getClassifyName());
                }
            }
        }));
    }

    public List<ComplaintSetVO> getAllItems(List<ComplaintSetVO> complaintSetVOS, Long id) {
        ArrayList<ComplaintSetVO> complaintOrders = new ArrayList<ComplaintSetVO>();
        while (id != 0L) {
            Long finalId = id;
            Optional<ComplaintSetVO> op = complaintSetVOS.stream().filter(x -> x.getId().equals(finalId)).findFirst();
            if (op.isEmpty()) {
                throw new BusinessException("");
            }
            complaintOrders.add(op.get());
            id = op.get().getPid();
        }
        return complaintOrders;
    }

    public String getAllClassifyName(List<ComplaintSetVO> complaintOrders) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = complaintOrders.size() - 1; i >= 0; --i) {
            if (i != 0) {
                stringBuilder.append(complaintOrders.get(i).getClassifyName()).append("->");
                continue;
            }
            stringBuilder.append(complaintOrders.get(i).getClassifyName());
        }
        return stringBuilder.toString();
    }

    public void pictureQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(BaseModelVO::getId).collect(Collectors.toList());
        PictureOrderParam pictureOrderParam = new PictureOrderParam();
        pictureOrderParam.setOrderList(collect);
        List data = (List)this.pictureOrderService.query(pictureOrderParam).getData();
        for (PictureOrderVO pictureOrderVO : data) {
            pictureOrderVO.setFullUrl(this.pictureURL + pictureOrderVO.getUrl());
        }
        complaintOrderVOS.stream().forEach(t -> {
            List respVOList = data.stream().filter(pic -> pic.getOrderId().equals(t.getId())).collect(Collectors.toList());
            t.setPictureOrderVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_2.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
            t.setCompletePictureVOS(respVOList.stream().filter(x -> UdcEnum.PICTURE_ORDER_TYPE_4.getValueCode().equals(x.getOrderType())).collect(Collectors.toList()));
        });
    }

    public void evaluationQuery(List<ComplaintOrderVO> complaintOrderVOS) {
        List<Long> collect = complaintOrderVOS.stream().filter(t -> t.getId() != null && t.getId() != 0L).map(BaseModelVO::getId).collect(Collectors.toList());
        OrderEvaluationParam orderEvaluationParam = new OrderEvaluationParam();
        orderEvaluationParam.setOrderIdList(collect);
        orderEvaluationParam.setOrderType(UdcEnum.EVALUATION_ORDER_TYPE_2.getValueCode());
        List<OrderEvaluationVO> data = this.orderEvaluationService.queryList(orderEvaluationParam);
        complaintOrderVOS.forEach(t -> {
            List evaluationVOList = data.stream().filter(item -> item.getOrderId().equals(t.getId())).collect(Collectors.toList());
            if (!evaluationVOList.isEmpty()) {
                t.setOrderEvaluationVO((OrderEvaluationVO)evaluationVOList.get(0));
            }
        });
    }

    private void sendCreateMsg(ComplaintOrderParam param) {
        try {
            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("WXC0001");
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("orderNo", param.getOrderNo());
            objectObjectHashMap.put("orderId", param.getId().toString());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(param.getOrderType())) {
                objectObjectHashMap.put("msgType", "cm_complaint_order_list");
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(param.getOrderType())) {
                objectObjectHashMap.put("msgType", "bm_complaint_order_list");
            }
            dto.setMesJoinParamMap(objectObjectHashMap);
            HashMap interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", param.getOrderNo());
            Set<Long> set = this.sysUserPermissionRpcProvider.getUserIdByRoleCode("KSSENDUSER");
            ArrayList<Long> userIdList = new ArrayList<Long>(set);
            ArrayList<MsgRecipientUserDTO> recipientUserList = new ArrayList<MsgRecipientUserDTO>();
            userIdList.forEach(x -> {
                MsgRecipientUserDTO recipient = MsgRecipientUserDTO.builder().userId(x).build();
                recipientUserList.add(recipient);
            });
            this.sysMsgRpcProvider.sendEmployeeInteriorMsg(dto, interiorMap, recipientUserList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void sendDispatchMsg(ComplaintOrderDO complaintOrderDO) {
        try {
            TemplateEmployeeSendParamDTO dto = new TemplateEmployeeSendParamDTO();
            dto.setTemplateCode("WXC0003");
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("orderNo", complaintOrderDO.getOrderNo());
            objectObjectHashMap.put("orderId", complaintOrderDO.getId().toString());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "cm_complaint_order_list");
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "bm_complaint_order_list");
            }
            dto.setMesJoinParamMap(objectObjectHashMap);
            ArrayList<MsgRecipientUserDTO> recipientUserList = new ArrayList<MsgRecipientUserDTO>();
            MsgRecipientUserDTO recipient = MsgRecipientUserDTO.builder().userId(complaintOrderDO.getHandlePersonId()).build();
            recipientUserList.add(recipient);
            HashMap interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", complaintOrderDO.getOrderNo());
            this.sysMsgRpcProvider.sendEmployeeInteriorMsg(dto, interiorMap, recipientUserList);
            TemplateAssignSendParamDTO custDto = new TemplateAssignSendParamDTO();
            custDto.setTemplateCode("WXB0003");
            String receiveUser = "";
            HashMap<String, String> custObjectObjectHashMap = new HashMap<String, String>();
            custObjectObjectHashMap.put("orderNo", complaintOrderDO.getOrderNo());
            custObjectObjectHashMap.put("orderId", complaintOrderDO.getId().toString());
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(complaintOrderDO.getOrderType())) {
                custObjectObjectHashMap.put("msgType", "c_complaint_order_detail");
                UserTransferHelper userTransferHelper = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer());
                Result result = userTransferHelper.getUserByMobile(complaintOrderDO.getOrderTel());
                if (null != result) {
                    receiveUser = ((AuthUserDTO)result.getData()).getUsername();
                }
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(complaintOrderDO.getOrderType())) {
                custObjectObjectHashMap.put("msgType", "b_complaint_order_list");
                receiveUser = complaintOrderDO.getCreator();
            }
            custDto.setMesJoinParamMap(custObjectObjectHashMap);
            HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
            map3.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(receiveUser).build());
            ArrayList<TemplateAssignRecipientUserDTO> custRecipientUserList = new ArrayList<TemplateAssignRecipientUserDTO>();
            TemplateAssignRecipientUserDTO custRecipient = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map3).userName(complaintOrderDO.getOrderPerson()).build();
            custRecipientUserList.add(custRecipient);
            HashMap custInteriorMap = Maps.newHashMap();
            custInteriorMap.put("orderNo", complaintOrderDO.getOrderNo());
            this.sysMsgRpcProvider.sendCustomInteriorMsg(custDto, custInteriorMap, custRecipientUserList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void sendCompleteMsg(ComplaintOrderDO complaintOrderDO) {
        try {
            TemplateAssignSendParamDTO dto = new TemplateAssignSendParamDTO();
            HashMap<String, String> objectObjectHashMap = new HashMap<String, String>();
            objectObjectHashMap.put("orderNo", complaintOrderDO.getOrderNo());
            objectObjectHashMap.put("orderId", complaintOrderDO.getId().toString());
            String receiveUser = "";
            if (UdcEnum.COMPLAINT_TYPE_1.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "c_complaint_order_detail");
                dto.setTemplateCode("WXC0007");
                UserTransferHelper userTransferHelper = UserTransferHelper.getInstance((String)this.authorizationServiceConfiguration.getAuthServer());
                Result result = userTransferHelper.getUserByMobile(complaintOrderDO.getOrderTel());
                if (null != result) {
                    receiveUser = ((AuthUserDTO)result.getData()).getUsername();
                }
            } else if (UdcEnum.COMPLAINT_TYPE_2.getValueCode().equals(complaintOrderDO.getOrderType())) {
                objectObjectHashMap.put("msgType", "b_complaint_order_list");
                dto.setTemplateCode("WXB0002");
                receiveUser = complaintOrderDO.getCreator();
            }
            dto.setMesJoinParamMap(objectObjectHashMap);
            HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO> map3 = new HashMap<MsgSendTypeEnum, TemplateAssignRecipientUserAccountDTO>();
            map3.put(MsgSendTypeEnum.SYS_INTERIOR, TemplateAssignRecipientUserAccountDTO.builder().account(receiveUser).build());
            ArrayList<TemplateAssignRecipientUserDTO> recipientUserList = new ArrayList<TemplateAssignRecipientUserDTO>();
            TemplateAssignRecipientUserDTO custRecipient = TemplateAssignRecipientUserDTO.builder().recipientUserAccountDtoMap(map3).userName(complaintOrderDO.getOrderPerson()).build();
            recipientUserList.add(custRecipient);
            HashMap interiorMap = Maps.newHashMap();
            interiorMap.put("orderNo", complaintOrderDO.getOrderNo());
            this.sysMsgRpcProvider.sendCustomInteriorMsg(dto, interiorMap, recipientUserList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void complaintOrderJob() {
        log.info("\u5f00\u59cb\u66f4\u65b0\u5ba2\u8bc9\u5de5\u5355\u72b6\u6001");
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        complaintSetPageParam.setComplaintType("3");
        complaintSetPageParam.setClassifyCode(COMPLAINT);
        List<ComplaintSetVO> complaintSetVOS = this.complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);
        if (CollectionUtils.isEmpty(complaintSetVOS)) {
            throw new BusinessException(ApiCode.FAIL, "\u83b7\u53d6\u5ba2\u8bc9\u5de5\u5355\u9ed8\u8ba4\u8bc4\u4ef7\u65f6\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        ArrayList<OrderItem> itemList = new ArrayList<OrderItem>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);
        ComplaintSetVO complaintSetVO = complaintSetVOS.get(0);
        LocalDateTime time = LocalDateTime.now().minusHours(Long.parseLong(complaintSetVO.getMaxHandle()));
        PagingVO<ComplaintOrderVO> list = this.complaintOrderRepoProc.findPageComplaintOrder(complaintOrderPageParam, time);
        ArrayList<OrderEvaluationDO> evaluationDOS = new ArrayList<OrderEvaluationDO>(1000);
        ArrayList<OrderLogDO> orderLogDOS = new ArrayList<OrderLogDO>(1000);
        while (!CollectionUtils.isEmpty((Collection)list.getRecords())) {
            list.getRecords().forEach(item -> {
                OrderEvaluationDO orderEvaluationDO = new OrderEvaluationDO();
                orderEvaluationDO.setOrderId(item.getId());
                orderEvaluationDO.setEvaluationLevel(UdcEnum.EVALUATION_LEVEL_1.getValueCode());
                orderEvaluationDO.setEvaluationContent(EVALUATION_CONTENT);
                orderEvaluationDO.setOrderType(UdcEnum.ORDER_TYPE_2.getValueCode());
                orderEvaluationDO.setModifyUserId(1L);
                orderEvaluationDO.setCreateUserId(1L);
                orderEvaluationDO.setCreator(SYSTEM_USER);
                orderEvaluationDO.setUpdater(SYSTEM_USER);
                evaluationDOS.add(orderEvaluationDO);
                OrderLogDO orderLogDO = new OrderLogDO();
                orderLogDO.setOrderId(item.getId());
                orderLogDO.setOrderType(UdcEnum.ORDER_TYPE_2.getValueCode());
                orderLogDO.setOperationContent(EVALUATION);
                orderLogDO.setRemark(EVALUATION_CONTENT_LOG);
                orderLogDO.setModifyUserId(1L);
                orderLogDO.setCreateUserId(1L);
                orderLogDO.setCreator(SYSTEM_USER);
                orderLogDO.setUpdater(SYSTEM_USER);
                orderLogDO.setOperationTime(LocalDateTime.now());
                orderLogDO.setOperationUser(SYSTEM_USER);
                orderLogDO.setOperationUserId(1L);
                orderLogDOS.add(orderLogDO);
            });
            this.orderEvaluationService.batchSave(evaluationDOS);
            this.orderLogService.batchSave(orderLogDOS);
            evaluationDOS.clear();
            orderLogDOS.clear();
            complaintOrderPageParam.setCurrent(++current);
            list = this.complaintOrderRepoProc.findPageComplaintOrder(complaintOrderPageParam, time);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairOrderJob() {
        log.info("\u5f00\u59cb\u66f4\u65b0\u7ef4\u4fee\u5de5\u5355\u72b6\u6001");
        ComplaintSetPageParam complaintSetPageParam = new ComplaintSetPageParam();
        complaintSetPageParam.setComplaintType("3");
        complaintSetPageParam.setClassifyCode(REPAIR);
        List<ComplaintSetVO> complaintSetVOS = this.complaintSetRepoProc.complaintSetQuery(complaintSetPageParam);
        if (CollectionUtils.isEmpty(complaintSetVOS)) {
            throw new BusinessException(ApiCode.FAIL, "\u83b7\u53d6\u7ef4\u4fee\u5de5\u5355\u9ed8\u8ba4\u8bc4\u4ef7\u65f6\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        ArrayList<OrderItem> itemList = new ArrayList<OrderItem>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);
        ComplaintSetVO complaintSetVO = complaintSetVOS.get(0);
        LocalDateTime time = LocalDateTime.now().minusHours(Long.parseLong(complaintSetVO.getMaxHandle()));
        PagingVO<RepairOrderVO> list = this.complaintOrderRepoProc.findPageRepairOrder(complaintOrderPageParam, time);
        ArrayList<OrderEvaluationDO> evaluationDOS = new ArrayList<OrderEvaluationDO>(1000);
        ArrayList<OrderLogDO> orderLogDOS = new ArrayList<OrderLogDO>(1000);
        while (!CollectionUtils.isEmpty((Collection)list.getRecords())) {
            list.getRecords().forEach(item -> {
                OrderEvaluationDO orderEvaluationDO = new OrderEvaluationDO();
                orderEvaluationDO.setOrderId(item.getId());
                orderEvaluationDO.setEvaluationLevel(UdcEnum.EVALUATION_LEVEL_1.getValueCode());
                orderEvaluationDO.setEvaluationContent(EVALUATION_CONTENT);
                orderEvaluationDO.setOrderType(UdcEnum.ORDER_TYPE_1.getValueCode());
                orderEvaluationDO.setModifyUserId(1L);
                orderEvaluationDO.setCreateUserId(1L);
                orderEvaluationDO.setCreator(SYSTEM_USER);
                orderEvaluationDO.setUpdater(SYSTEM_USER);
                evaluationDOS.add(orderEvaluationDO);
                OrderLogDO orderLogDO = new OrderLogDO();
                orderLogDO.setOrderId(item.getId());
                orderLogDO.setOrderType(UdcEnum.ORDER_TYPE_1.getValueCode());
                orderLogDO.setOperationContent(EVALUATION);
                orderLogDO.setRemark(EVALUATION_CONTENT_LOG);
                orderLogDO.setModifyUserId(1L);
                orderLogDO.setCreateUserId(1L);
                orderLogDO.setCreator(SYSTEM_USER);
                orderLogDO.setUpdater(SYSTEM_USER);
                orderLogDO.setOperationTime(LocalDateTime.now());
                orderLogDO.setOperationUser(SYSTEM_USER);
                orderLogDO.setOperationUserId(1L);
                orderLogDOS.add(orderLogDO);
            });
            this.orderEvaluationService.batchSave(evaluationDOS);
            this.orderLogService.batchSave(orderLogDOS);
            evaluationDOS.clear();
            orderLogDOS.clear();
            complaintOrderPageParam.setCurrent(++current);
            list = this.complaintOrderRepoProc.findPageRepairOrder(complaintOrderPageParam, time);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void respTimeOutJob() {
        log.info("\u5f00\u59cb\u5de5\u5355\u54cd\u5e94\u8d85\u65f6\u72b6\u6001\u4efb\u52a1");
        ComplaintSetPageParam bParam = new ComplaintSetPageParam();
        bParam.setComplaintType(UdcEnum.COMPLAINT_TYPE_2.getValueCode());
        List<ComplaintSetVO> complaintBSetCVOS = this.complaintSetRepoProc.complaintSetQuery(bParam);
        Map<String, String> bMap = complaintBSetCVOS.stream().filter(complaintSetVO -> StringUtils.isNotEmpty((CharSequence)complaintSetVO.getMaxResp())).collect(Collectors.toMap(ComplaintSetVO::getClassifyCode, ComplaintSetVO::getMaxResp));
        if (CollectionUtils.isEmpty(complaintBSetCVOS)) {
            throw new BusinessException(ApiCode.FAIL, "\u83b7\u53d6\u5de5\u5355\u8d85\u65f6\u65f6\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        ArrayList<OrderItem> itemList = new ArrayList<OrderItem>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);
        LocalDateTime now = LocalDateTime.now();
        PagingVO<ComplaintOrderVO> complaintOrderVOS = this.complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "rsp");
        ArrayList<Long> idList = new ArrayList<Long>();
        while (!CollectionUtils.isEmpty((Collection)complaintOrderVOS.getRecords())) {
            complaintOrderVOS.getRecords().forEach(item -> {
                if (bMap.containsKey(item.getIssueType()) && item.getCreateTime().plusHours(Long.parseLong((String)bMap.get(item.getIssueType()))).compareTo(now) < 0) {
                    idList.add(item.getId());
                }
            });
            complaintOrderPageParam.setCurrent(++current);
            complaintOrderVOS = this.complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "rsp");
        }
        if (!idList.isEmpty()) {
            this.complaintOrderRepoProc.rspTimeOut(idList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleTimeOutJob() {
        log.info("\u5f00\u59cb\u5de5\u5355\u5904\u7406\u8d85\u65f6\u72b6\u6001\u4efb\u52a1");
        ComplaintSetPageParam bParam = new ComplaintSetPageParam();
        bParam.setComplaintType(UdcEnum.COMPLAINT_TYPE_2.getValueCode());
        List<ComplaintSetVO> complaintBSetCVOS = this.complaintSetRepoProc.complaintSetQuery(bParam);
        Map<String, String> bMap = complaintBSetCVOS.stream().filter(complaintSetVO -> StringUtils.isNotEmpty((CharSequence)complaintSetVO.getMaxHandle())).collect(Collectors.toMap(ComplaintSetVO::getClassifyCode, ComplaintSetVO::getMaxHandle));
        if (CollectionUtils.isEmpty(bMap)) {
            throw new BusinessException(ApiCode.FAIL, "\u83b7\u53d6\u5de5\u5355\u8d85\u65f6\u65f6\u95f4\u914d\u7f6e\u4e3a\u7a7a");
        }
        int current = 1;
        ComplaintOrderPageParam complaintOrderPageParam = new ComplaintOrderPageParam();
        complaintOrderPageParam.setCurrent(current);
        complaintOrderPageParam.setSize(LIMIT);
        OrderItem orderItem = new OrderItem();
        orderItem.setAsc(false);
        orderItem.setColumn("createTime");
        ArrayList<OrderItem> itemList = new ArrayList<OrderItem>();
        itemList.add(orderItem);
        complaintOrderPageParam.setOrders(itemList);
        LocalDateTime now = LocalDateTime.now();
        PagingVO<ComplaintOrderVO> complaintOrderVOS = this.complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "handle");
        ArrayList<Long> idList = new ArrayList<Long>();
        while (!CollectionUtils.isEmpty((Collection)complaintOrderVOS.getRecords())) {
            complaintOrderVOS.getRecords().forEach(item -> {
                if (bMap.containsKey(item.getIssueType()) && item.getDispatchTime().plusHours(Long.parseLong((String)bMap.get(item.getIssueType()))).compareTo(now) < 0) {
                    idList.add(item.getId());
                }
            });
            complaintOrderPageParam.setCurrent(++current);
            complaintOrderVOS = this.complaintOrderRepoProc.findPageTimeout(complaintOrderPageParam, "handle");
        }
        if (!idList.isEmpty()) {
            this.complaintOrderRepoProc.handleTimeOut(idList);
        }
    }
}

