package com.elitesland.yst.production.aftersale.controller.miniapp;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.time.LocalDateTime;

/**
 * @Context:
 * @title: ThreePackageController
 * @Author： 郑杰
 * @Date: 2023/2/14 16:23
 */
@RestController
@RequestMapping(value = "/miniApp/threePackage", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "三包", tags = {"三包"})
public class MaintainCardController {

    @Autowired
    private MaintainCardService maintainCardService;

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;


    @PostMapping(value = "/activateThreePackage")
    @ApiOperation(value = "三包激活")
    public ApiResult<Object> activateThreePackage(@RequestBody @Valid com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam carMaintainCardParam) {
//        carMaintainCardParam.setSourcePlatform("MNAPP");
//        ApiResult<Object> activate = maintainCardService.activate(carMaintainCardParam);
//        return activate;
        throw new BusinessException("该接口已进行升级,请刷新小程序页面");
    }

    @PostMapping(value = "/threePackageQuery")
    @ApiOperation(value = "三包查询")
    public ApiResult<Object> threePackageQuery(@RequestBody CarOwnerMaintainCardParam car) {
        ApiResult<Object> query = maintainCardService.query(car.getCarOwnerId(), car.getPage(), car.getPageSize());
        return query;
    }

    @PostMapping(value = "/threePackageQueryById")
    @ApiOperation(value = "通过车架号查询三包信息")
    public ApiResult<CarMaintainCardVO> threePackageQueryById(@RequestBody CarMaintainCardParam car) {
        ApiResult<CarMaintainCardVO> query = maintainCardService.queryById(car.getVehicleNo());
        return query;
    }


    @PostMapping(value = "/activateThreePackage2")
    @ApiOperation(value = "三包激活-绑定车辆")
    public ApiResult<Object> activateThreePackage2(@RequestBody @Valid CarOwnerVehicleParam carOwnerVehicleParam) {

        if (null == (carOwnerVehicleParam.getCarOwnerId())) {
            throw new BusinessException("carOwnerId不能为空");
        }
        carOwnerVehicleParam.setActivatFlag(true);
        carOwnerVehicleParam.setActivatTime(LocalDateTime.now());
        Boolean res = null;
        try {
            res = maintainCardService.activateThreePackage2Mn(carOwnerVehicleParam, "MNAPP");
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.ok(res);
    }

    @PostMapping(value = "/站内信发送测试")
    @ApiOperation(value = "站内信发送测试")
    public ApiResult sendActiveMsg(@RequestBody @Valid CarOwnerVehicleParam carOwnerVehicleParam) {
         maintainCardService.sendActiveMsg(carOwnerVehicleParam);
        return ApiResult.ok();
    }


}
