package com.elitesland.yst.production.aftersale.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleRelateDO
 * @Date2023/2/8 15:24
 */
@Entity
@Table(name = "car_owner_vehicle_relate")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "car_owner_vehicle_relate", comment = "车主车辆关系表")
@Where(clause = "delete_flag = 0")
@Data
@Accessors(chain = true)
@ApiModel(value = "car_owner_vehicle_relate", description = "车主车辆关系表")
public class CarOwnerVehicleRelateDO extends BaseModel {

    @ApiModelProperty("车主id")
    @Column(name = "car_owner_id ", columnDefinition = "bigint(20) default 0 comment '车主id'")
    private Long carOwnerId;

    @ApiModelProperty("车主车辆信息表id")
    @Column(name = "vehicle_info_id ", columnDefinition = "bigint(30) default 0 comment '车主车辆表id'")
    private Long vehicleInfoId;

    @ApiModelProperty("车型")
    @Column(name = "vehicle_type ", columnDefinition = "varchar(40) comment '车型'")
    private Long vehicleType;

}
