package com.elitesland.yst.production.aftersale.service.repo;

import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecClsDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zhengyue
 * @description: 400电话记录分类
 * @date 2024/4/18 16:56
 */
@Repository
public interface PhoneRecClsRepo extends JpaRepository<PhoneRecClsDO, Long>, QuerydslPredicateExecutor<PhoneRecClsDO> {
    /**
     * 查询相同的父类下是否有相同的名称
     * @param name
     * @param pid
     * @return
     */
    boolean existsByNameAndPid(String name, Long pid);

    /**
     * 查询相同的父类下除自己外是否有相同的名称
     * @param name
     * @param pid
     * @return
     */
    boolean existsByNameAndPidAndIdNot(String name, Long pid, Long id);

    /**
     * 查询一级分类信息
     * @param Pid
     * @return
     */
    List<PhoneRecClsDO> findByPid(Long Pid);


    /**
     *判断是否存在下级
     * @param ids
     * @return
     */
    Boolean existsByPidIn(List<Long> ids);

}
