package com.elitesland.yst.production.aftersale.util;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.base.param.ExportColumnParam;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * excel工具类
 *
 * @author elvis.hong
 * @date 2023/02/16
 */
public class ExcelUtils {

    private ExcelUtils() {
    }

    /**
     * 构建导出列
     * @param param 查询条件
     * @param clazz 导出对象class
     */
    public static void buildExportColumn(AbstractExportQueryParam param, Class<?> clazz) {
        List<ExportColumnParam> exportColumn = new ArrayList<>();
        Field[] fields = ReflectUtil.getFields(clazz);
        Arrays.stream(fields).filter(f -> f.isAnnotationPresent(ExcelProperty.class)).forEach(f -> {
            var exportColumnParam = new ExportColumnParam();
            exportColumnParam.setField(f.getName());
            exportColumnParam.setTitle(f.getAnnotation(ExcelProperty.class).value()[0]);
            exportColumn.add(exportColumnParam);
        });
        param.setExportColumn(exportColumn);
    }

}
