/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.aftersale.convert.PhoneRecordConvert;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecordDO;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordPageParam;
import com.elitesland.yst.production.aftersale.model.param.PhoneRecordParam;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecordVO;
import com.elitesland.yst.production.aftersale.service.PhoneRecordService;
import com.elitesland.yst.production.aftersale.service.impl.UserService;
import com.elitesland.yst.production.aftersale.service.repo.PhoneRecordRepo;
import com.elitesland.yst.production.aftersale.service.repo.PhoneRecordRepoProc;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhoneRecordServiceImpl
implements PhoneRecordService {
    private static final Logger log = LoggerFactory.getLogger(PhoneRecordServiceImpl.class);
    private final PhoneRecordRepoProc phoneRecordRepoProc;
    private final PhoneRecordRepo phoneRecordRepo;
    private final SysUdcProxyService sysUdcProxyService;
    private final UserService userService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PhoneRecordDO save(PhoneRecordParam phoneRecordParam) {
        this.checkData(phoneRecordParam);
        phoneRecordParam.setFollowUpFlag(phoneRecordParam.getFollowUpFlag() == null ? false : phoneRecordParam.getFollowUpFlag());
        PhoneRecordDO phoneRecordDO = PhoneRecordConvert.INSTANCE.saveVoTODO(phoneRecordParam);
        SysUserDTO userDetail = this.userService.getUserDetail();
        phoneRecordDO.setCreateName(userDetail.getLastName());
        PhoneRecordDO res = (PhoneRecordDO)((Object)this.phoneRecordRepo.save((Object)phoneRecordDO));
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PhoneRecordDO update(PhoneRecordParam phoneRecordParam) {
        Assert.notNull((Object)phoneRecordParam.getId(), (String)"id is null", (Object[])new Object[0]);
        PhoneRecordDO res = this.save(phoneRecordParam);
        return res;
    }

    @Override
    @SysCodeProc
    public PhoneRecordVO get(Long id) {
        PhoneRecordVO res = this.phoneRecordRepoProc.get(id);
        return res;
    }

    @Override
    @SysCodeProc
    public PagingVO<PhoneRecordVO> page(PhoneRecordPageParam phoneRecordPageParam) {
        PagingVO<PhoneRecordVO> res = this.phoneRecordRepoProc.page(phoneRecordPageParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        Long res = this.phoneRecordRepoProc.del(ids);
        return res;
    }

    private void checkData(PhoneRecordParam phoneRecordParam) {
        if (phoneRecordParam.getRecordTime() == null) {
            throw new BusinessException("\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (phoneRecordParam.getCityCode() == null || phoneRecordParam.getCityName() == null) {
            throw new BusinessException("\u57ce\u5e02\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (phoneRecordParam.getContacts() == null) {
            throw new BusinessException("\u8054\u7edc\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (phoneRecordParam.getContactPhone() == null) {
            throw new BusinessException("\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (phoneRecordParam.getCustType() == null) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (phoneRecordParam.getCallType() == null) {
            throw new BusinessException("\u6765\u7535\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (phoneRecordParam.getCallContent() == null) {
            throw new BusinessException("\u901a\u8bdd\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    @Override
    public PagingVO<PhoneRecordVO> export(PhoneRecordPageParam param) {
        PagingVO<PhoneRecordVO> page = this.page(param);
        this.sysUdcProxyService.translate((Object)page.getRecords());
        page.stream().forEach(t -> {
            t.setFollowUpFlagName(t.getFollowUpFlag() != false ? "\u662f" : "\u5426");
            if (t.getServiceSatisfied() != null) {
                switch (t.getServiceSatisfied()) {
                    case 1: {
                        t.setServiceSatisfiedName("\u6ee1\u610f");
                        break;
                    }
                    case 2: {
                        t.setServiceSatisfiedName("\u5341\u5206\u6ee1\u610f");
                        break;
                    }
                    case 3: {
                        t.setServiceSatisfiedName("\u4e0d\u6ee1\u610f");
                        break;
                    }
                    default: {
                        throw new BusinessException("\u6570\u636e\u6765\u6e90\u5f02\u5e38");
                    }
                }
            }
        });
        return page;
    }

    public PhoneRecordServiceImpl(PhoneRecordRepoProc phoneRecordRepoProc, PhoneRecordRepo phoneRecordRepo, SysUdcProxyService sysUdcProxyService, UserService userService) {
        this.phoneRecordRepoProc = phoneRecordRepoProc;
        this.phoneRecordRepo = phoneRecordRepo;
        this.sysUdcProxyService = sysUdcProxyService;
        this.userService = userService;
    }
}

