package com.elitesland.yst.production.aftersale.controller.app;

import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponse;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.BindSoldVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.BindSoldVehicleVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author elvis.hong
 * @date 2023/3/23
 */
@RestController
@RequestMapping(value = "/app/activateRecord", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Slf4j
@RequiredArgsConstructor
@Api(value = "经销商App端激活记录", tags = {"经销商App端激活记录"})
public class AppActivateRecordController {

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;


    @PostMapping("/activateRecordQuery")
    @ApiOperation("绑定记录分页查询")
    public ApiResult<PagingVO<BindSoldVehicleVO>> activateRecordQuery(@RequestBody BindSoldVehicleParam param) {
        PagingVO<BindSoldVehicleVO> query = carOwnerVehicleService.bindSoldVehicleQuery(param);
        return ApiResult.ok(query);
    }

    @GetMapping(value = "/activateRecordDetail/{id}")
    @ApiOperation(value = "激活记录明细查询")
    public ApiResult<CarOwnerVehicleInfoVO> activateRecordDetail(@PathVariable("id") Long id) {
        CarOwnerVehicleInfoVO carOwnerVehicleInfoVO = carOwnerVehicleService.bindSoldVehicleDetail(id);
        return ApiResult.ok(carOwnerVehicleInfoVO);
    }

    @PostMapping(value = "/activateRecordSave")
    @ApiOperation(value = "激活记录信息保存")
    public ApiResult<Long> activateRecordSave(@RequestBody @Validated CarOwnerVehicleParam carOwnerVehicleParam) {

        throw new BusinessException("该接口已进行升级,请升级APP新版本");
//        carOwnerVehicleParam.setActivatFlag(false);
//        ApiResult<Long> res
//                = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam,"APP");
//        return res;
    }


    @PostMapping(value = "/delThreePackage")
    @ApiOperation(value = "解绑车辆并删除三包信息")
    public ApiResult<Object> delThreePackage(@RequestBody Long id) {
        ApiResult<Object> res = carOwnerVehicleService.deleteBindVehicleAndThreePack(id);
        return res;
    }

    @PostMapping(value = "/findCarByUserPhone")
    @ApiOperation(value = "根据手机号查询已绑定的车辆信息")
    public ApiResult<List<CarOwnerVehicleInfoVO>> findCarByUserPhone(String phone) {

        List<CarOwnerVehicleInfoVO> res = carOwnerVehicleService.findCarByUserPhone(phone);
        return ApiResult.ok(res);
    }


    @PostMapping(value = "/bindSoldVehicleSave2")
    @ApiOperation(value = "售出车辆绑定信息保存(不进行激活)")
    public ApiResult<Long> bindSoldVehicleSave2(@RequestBody @Validated CarOwnerVehicleParam carOwnerVehicleParam) {
        carOwnerVehicleParam.setActivatFlag(false);
        ApiResult<Long> res = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam, "APP");
        return res;
    }


    @PostMapping(value = "/ocrScan")
    @ApiOperation(value = "身份证ocr识别")
    public ApiResult<Object> ocrScan(@RequestParam("file") MultipartFile file) {
        RecognizeIdcardResponse response = carOwnerVehicleService.ocrScan(file);
        return ApiResult.ok(response);
    }

}
