package com.elitesland.yst.production.aftersale.controller.pc;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerInfoMngParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerInfoMngRespVO;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.util.AsyncExcelUtils;
import com.elitesland.yst.production.aftersale.util.ExcelUtils;
import com.elitesland.yst.production.aftersale.util.excel.support.ExportColumnParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Context:
 * @title: ThreePackageController
 * @Author： 郑杰
 * @Date: 2023/2/14 16:23
 */
@RestController
@RequestMapping(value = "/pc/threePackage", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "三包", tags = {"三包"})
public class MaintainCardController {

    @Autowired
    private MaintainCardService maintainCardService;

    @Autowired
    private ExportExcelService<CarOwnerMaintainCardPageParam, CarMaintainCardVO, Serializable> exportExcelService;

//    @Autowired
//    private CarOwnerVehicleService carOwnerVehicleService;

    @PostMapping(value = "/activateThreePackage")
    @ApiOperation(value = "三包激活")
    public ApiResult<Object> activateThreePackage(@RequestBody @Valid CarMaintainCardParam carMaintainCardParam) {
        carMaintainCardParam.setSourcePlatform("PC");
        ApiResult<Object> activate = maintainCardService.activate(carMaintainCardParam);
        return activate;
    }

    @PostMapping(value = "/threePackageQuery")
    @ApiOperation(value = "三包查询")
    public ApiResult<Object> threePackageQuery(@RequestBody CarOwnerMaintainCardParam car) {
        ApiResult<Object> query = maintainCardService.query(car.getCarOwnerId(), car.getPage(), car.getPageSize());
        return query;
    }

    @PostMapping(value = "/threePackageQueryById")
    @ApiOperation(value = "通过车架号查询三包信息")
    public ApiResult<CarMaintainCardVO> threePackageQueryById(@RequestBody CarMaintainCardParam car) {
        ApiResult<CarMaintainCardVO> query = maintainCardService.queryById(car.getVehicleNo());
        return query;
    }


    @PostMapping(value = "/activateThreePackage2")
    @ApiOperation(value = "三包激活-绑定车辆")
    public ApiResult<Object> activateThreePackage2(@RequestBody @Valid CarOwnerVehicleParam carOwnerVehicleParam) {

        if (null == (carOwnerVehicleParam.getCarOwnerId())) {
            throw new BusinessException("carOwnerId不能为空");
        }
        carOwnerVehicleParam.setActivatFlag(true);
        carOwnerVehicleParam.setActivatTime(LocalDateTime.now());
        Boolean res = null;
        try {
            res = maintainCardService.activateThreePackage2(carOwnerVehicleParam,"PC");
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.ok(res);

    }


    @PostMapping(value = "/page")
    @ApiOperation(value = "三包查询分页查询")
    public ApiResult<PagingVO> page(@RequestBody CarOwnerMaintainCardPageParam car) {
        PagingVO<CarMaintainCardVO> res = maintainCardService.page(car);
        return ApiResult.ok(res);
    }

    @PostMapping(value = "/pageSaleMan")
    @ApiOperation(value = "三包查询分页查询(业务)")
    public ApiResult<PagingVO> pageSaleMan(@RequestBody CarOwnerMaintainCardPageParam car) {
        PagingVO<CarMaintainCardVO> res = maintainCardService.pageSaleMan(car);
        return ApiResult.ok(res);
    }

    @GetMapping("get/{id}")
    @ApiOperation("详情-车辆三包信息")
    @ApiOperationSupport(order = 1)
    public ApiResult<CarMaintainCardVO> get(@PathVariable Long id) {

        CarMaintainCardVO res = maintainCardService.get(id);
        return ApiResult.ok(res);

    }

    @PostMapping("del")
    @ApiOperation("删除-根据车架号删除该车辆下三包信息和所有绑定关系")
    public ApiResult<Boolean> del(@RequestBody List<String> vehicleNos) {
        Boolean res = maintainCardService.delAllByVehicleNo(vehicleNos);
        return ApiResult.ok(res);
    }


//    @PostMapping(value = "/export", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
//    @ApiOperation(value = "车主信息管理导出数据")
//    public ApiResult<?> export(HttpServletResponse response, @RequestBody CarOwnerMaintainCardPageParam queryVO) {
//        ExcelUtils.buildExportColumn(queryVO, CarMaintainCardVO.class);
//        try {
//            exportExcelService.export(queryVO, response, maintainCardService::page).get();
//            return null;
//        } catch (Exception e) {
//            return ApiResult.fail("导出失败：" + e.getMessage());
//        }
//    }

//    @PostMapping(value = "/exportSaleMan", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
//    @ApiOperation(value = "车主信息管理导出数据(业务)")
//    public ApiResult<?> exportSaleMan(HttpServletResponse response, @RequestBody CarOwnerMaintainCardPageParam queryVO) {
//        ExcelUtils.buildExportColumn(queryVO, CarMaintainCardVO.class);
//        try {
//            exportExcelService.export(queryVO, response, maintainCardService::pageSaleMan).get();
//            return null;
//        } catch (Exception e) {
//            return ApiResult.fail("导出失败：" + e.getMessage());
//        }
//    }

    @PostMapping(value = "/export", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperation(value = "车主信息管理导出数据")
    public ApiResult<?> export(HttpServletResponse response, @RequestBody CarOwnerMaintainCardPageParam queryVO) {
        try {
            AsyncExcelUtils.export(response, "车主信息管理导出数据", AsyncExcelUtils.buildExportColumn(CarMaintainCardVO.class), maintainCardService::page, queryVO);
            return null;
        } catch (Exception e) {
            return ApiResult.fail("导出失败：" + e.getMessage());
        }
    }

    @PostMapping(value = "/exportSaleMan", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
    @ApiOperation(value = "车主信息管理导出数据(业务)")
    public ApiResult<?> exportSaleMan(HttpServletResponse response, @RequestBody CarOwnerMaintainCardPageParam queryVO) {
        try {
            AsyncExcelUtils.export(response, "车主信息管理导出数据(业务)", AsyncExcelUtils.buildExportColumn(CarMaintainCardVO.class), maintainCardService::pageSaleMan, queryVO);
            return null;
        } catch (Exception e) {
            return ApiResult.fail("导出失败：" + e.getMessage());
        }
    }

}

