package com.elitesland.yst.production.aftersale.model.entity;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.elitescloud.boot.model.entity.BaseModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import org.hibernate.annotations.Where;
import lombok.EqualsAndHashCode;

/**
 * @author : http://www.chiner.pro
 * @date : 2023-2-28
 * @desc : 客诉设置
 */
@Entity
@Table(name = "complaint_set")
@org.hibernate.annotations.Table(appliesTo = "complaint_set", comment = "客诉设置")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class ComplaintSetDO extends BaseModel {

    @Column(name = "classify_code", columnDefinition = "varchar(255) comment '分类编码'")
    private String classifyCode;

    @Column(name = "classify_name", columnDefinition = "varchar(255) comment '分类名称'")
    private String classifyName;

    @Column(name = "complaint_type", columnDefinition = "varchar(255) comment '客诉类型（b/c）'")
    private String complaintType;

    @Column(name = "enable_flag", columnDefinition = "varchar(255) comment '启用状态'")
    private String enableFlag;

    @Column(name = "max_resp", columnDefinition = "varchar(255) comment '最大响应时间'")
    private String maxResp;

    @Column(name = "max_handle", columnDefinition = "varchar(255) comment '最大处理时间'")
    private String maxHandle;

    @Column(name = "issue_desc", columnDefinition = "varchar(255) comment '问题描述'")
    private String issueDesc;

    @Column(name = "sort_no", columnDefinition = "int(11) comment '序号'")
    private Integer sortNo;

    @Column(name = "pid", columnDefinition = "bigint(20) comment '上级id'")
    private Long pid;

}