package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class BatteryQueryParam extends AbstractOrderQueryParam {
    @ApiModelProperty("商品统一编码")
    private String code;

    @ApiModelProperty("商品类型")
    private String type;

    @ApiModelProperty("厂家商品编码")
    private String fgCode;

    @ApiModelProperty("厂家编码")
    private String factoryCode;

    @ApiModelProperty("厂家名称")
    private String factoryName;

    @ApiModelProperty("产品品类")
    private String prodCategory;

    @ApiModelProperty("产品规格")
    private String prodSpecs;

    @ApiModelProperty("产品型号")
    private String prodModel;

    @ApiModelProperty("产地")
    private String producer;

    @ApiModelProperty("厂家出库时间")
    private LocalDateTime factoryOutTimeS;
    private LocalDateTime factoryOutTimeE;

    @ApiModelProperty("入库时间")
    private LocalDateTime inTimeS;
    private LocalDateTime inTimeE;

    @ApiModelProperty("出库时间")
    private LocalDateTime outTimeS;
    private LocalDateTime outTimeE;
}
