package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author elvis.hong
 * @title BindSoldVehicleParam
 * @Date  2023/2/21 17:22
 */
@Data
@ApiModel(description = "pc售出车辆绑定查询数据参数")
public class BindSoldVehicleParam extends AbstractExportQueryParam implements Serializable {

    @ApiModelProperty(value = "车架号")
    private String vehicleNo;
    @ApiModelProperty(value = "车主信息")
    private String vehicleType;

    @ApiModelProperty(value = "车架号集合")
    private List<String> vehicleNoList;

    @ApiModelProperty(value = "id集合")
    private List<Long> idList;

    @ApiModelProperty(value = "客户信息")
    private String custInfo;

    @ApiModelProperty(value = "车架号/客户手机号")
    private String appInfo;

    @ApiModelProperty("车辆来源")
    private Integer vehicleSource;

    @ApiModelProperty("激活标识")
    private Integer activatFlag;

    @ApiModelProperty(value = "销售门店编码")
    private String salesOutletsCode;

    @ApiModelProperty(value = "开始日期")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "结束日期")
    private LocalDateTime endTime;

    @ApiModelProperty("销售门店ID")
    private Long salesOutletsId;
    private List<Long> salesOutletsIdS;
    private List<Long> salesOutletsIds2;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("所属经销商")
    private String custName;

    @ApiModelProperty("所属区域名称")
    private String salesOutletsRegionName;

    @ApiModelProperty("所属区域")
    private String salesOutletsRegion;

}
