package com.elitesland.yst.production.aftersale.model.param;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/23
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ComplaintOrderExlParam extends AbstractExportQueryParam implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("唯一标识")
    Long id;

    @ApiModelProperty("唯一标识集合")
    List<Long> idList;

    @ApiModelProperty("工单类型")
    private String orderType;

    @ApiModelProperty("工单单号")
    private String orderNo;

    @ApiModelProperty("问题类型")
    private String issueType;

    @ApiModelProperty("车主id")
    private Long carOwnerId;

    @ApiModelProperty("联系电话")
    private String orderTel;

    @ApiModelProperty("联系人")
    private String orderPerson;

    @ApiModelProperty("处理状态")
    private String orderStatus;

    @ApiModelProperty("搜索内容")
    private String searchContent;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("绑定时间")
    private LocalDateTime bindingTime;

    @ApiModelProperty("绑定时间开始")
    private LocalDateTime bindingTimeStart;

    @ApiModelProperty("绑定时间结束")
    private LocalDateTime bindingTimeEnd;

    @ApiModelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("生产日期")
    private LocalDateTime manufactureDate;

    @ApiModelProperty("生产日期开始")
    private LocalDateTime manufactureDateStart;

    @ApiModelProperty("生产日期结束")
    private LocalDateTime manufactureDateEnd;

    @ApiModelProperty("出库日期")
    private LocalDateTime docTime;

    @ApiModelProperty("出库日期开始")
    private LocalDateTime docTimeStart;

    @ApiModelProperty("出库日期结束")
    private LocalDateTime docTimeEnd;

    @ApiModelProperty("激活时间")
    private LocalDateTime activatTime;

    @ApiModelProperty("激活时间开始")
    private LocalDateTime activatTimeStart;

    @ApiModelProperty("激活时间结束")
    private LocalDateTime activatTimeEnd;

    @ApiModelProperty("所属经销商名称")
    private String custName;

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof ComplaintOrderExlParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
