package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author RYH
 * @date 2023/2/14
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ComplaintOrderParam extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("id数组")
    private List<Long> ids;

    @ApiModelProperty("工单单号")
    private String orderNo;

    @ApiModelProperty("问题类型")
    private String issueType;

    @ApiModelProperty("问题描述")
    private String issueDescription;

    @ApiModelProperty("车主id")
    private Long carOwnerId;

    @ApiModelProperty("联系人")
    private String orderPerson;

    @ApiModelProperty("联系电话")
    private String orderTel;

    @ApiModelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("车型")
    private String vehicleType;

    @ApiModelProperty("客诉类型")
    private String orderType;

    @ApiModelProperty("处理状态")
    private String orderStatus;

    @ApiModelProperty("处理人id")
    private Long handlePersonId;

    @ApiModelProperty("处理人")
    private String handlePersonName;

    @ApiModelProperty("处理人电话")
    private String handlePersonTel;

    @ApiModelProperty("处理回复")
    private String handleReply;

    @ApiModelProperty("C端取消原因udc")
    private String cancelReasonC;

    @ApiModelProperty("B端取消原因udc")
    private String cancelReasonB;

    @ApiModelProperty("取消原因明细")
    private String cancelDetail;

    @ApiModelProperty("基地")
    private String baseNo;

    @ApiModelProperty("确认分类")
    private String confirmType;

    @ApiModelProperty("问题补充")
    private String issueSupplement;

    @ApiModelProperty("细分分类")
    private String subdivisionType;

    @ApiModelProperty("派单人id")
    private Long dispatchPersonId;

    @ApiModelProperty("时效状态")
    private String timeoutStatus;

    @ApiModelProperty("派单时间")
    private LocalDateTime dispatchTime;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("所属经销商名称")
    private String custName;

    @ApiModelProperty("上传图片集合")
    List<PictureOrderParam> pictureOrderParamList;

    @ApiModelProperty("解决图片集合")
    List<PictureOrderParam> completePictureVOS;


    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof ComplaintOrderParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
