package com.elitesland.yst.production.aftersale.model.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.aftersale.model.base.BaseModelVO;
import com.elitesland.yst.production.aftersale.model.entity.MaintainCardInfoDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Context:
 * @title: CarThreePackageRespVO
 * @Author： 郑杰
 * @Date: 2023/2/14 16:09
 */
@Data
@ApiModel(description = "根据车架号查询三包信息详情返回结果")
public class CarMaintainCardVO extends BaseModelVO {
    private static final long serialVersionUID = -8282920176472466272L;

    @ExcelProperty("车架号")
    @ApiModelProperty(value = "车架号")
    private String vehicleNo;

    @ApiModelProperty(value = "身份证")
    private String userIdCard;

    @ApiModelProperty(value = "生日")
    private LocalDate userBirthday;

    @ApiModelProperty(value = "性别")
    @SysCode(sys = "yst-after-sale", mod = "SEX")
    private String userSex;
    private String userSexName;

    @ApiModelProperty(value = "区域")
    private String userArea;

    @ApiModelProperty(value = "购买价格")
    private BigDecimal vehicleBuyPrice;


    @ApiModelProperty(value = "车辆名称")
    private String carName;

    @ExcelProperty("车辆信息")
    @ApiModelProperty(value = "车辆型号")
    private String vehicleType;

    @ApiModelProperty("门店id")
    @ExcelProperty("门店id")
    private String salesOutletsCode;

    @ApiModelProperty(value = "购买日期")
    @ExcelProperty("购买日期")
    private LocalDate purchaseTime;

    @ApiModelProperty("车辆规格")
    @ExcelProperty("车辆规格")
    private String vehicleSpecs;

    @ApiModelProperty("车辆颜色")
    @ExcelProperty("车辆颜色")
    private String vehicleColor;

    @ApiModelProperty(value = "配件三包信息集合")
    private List<CarMaintainCardInfoVo> maintainCardInfoS;


    @ApiModelProperty("销售门店")
    @ExcelProperty("绑定门店")
    private String salesOutletsName;

    @ApiModelProperty("客户号")
    @ExcelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("所属经销商")
    @ExcelProperty("所属经销商")
    private String custName;

    @ApiModelProperty("所属区域")
    @ExcelProperty("所属区域")
    private String salesOutletsRegionName;
    @ApiModelProperty(value = "所属区域")
    private String region;
    @ApiModelProperty("车主名称")
    @ExcelProperty("车主名称")
    private String userName;


    @ApiModelProperty("车主手机号")
    @ExcelProperty("车主手机号")
    private String userPhone;

    @ApiModelProperty("绑定时间")
    @ExcelProperty("绑定时间")
    private LocalDateTime bindingTime;

    @ApiModelProperty("车辆来源")
    @SysCode(sys = "yst-after-sale", mod = "VEHICLE_SOURCE")
    private Integer vehicleSource;
    private String vehicleSourceName;

    @ApiModelProperty("绑定时间")
    @ExcelProperty("绑定时间")
    private LocalDateTime createTime;

    @ExcelIgnore
    @ApiModelProperty("图片数据")
    private List<PictureOrderVO> imgs;

    @ApiModelProperty("是否购买保险")
    @ExcelProperty("是否购买保险")
    private String isSignedInsurance;

    @ApiModelProperty("保险名称")
    @ExcelProperty("保险名称")
    private String planName;

    @ApiModelProperty("是否激活保险")
    @ExcelIgnore
    private Integer isCancel;
    private String isCancelStr;

    @ApiModelProperty("电池编码")
    @ExcelProperty("电池编码")
    private String batteryCodes;

    @ApiModelProperty("电充编码")
    @ExcelProperty("电充编码")
    private String chargerCode;
}
