package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.convert.ExecutRecordConvert;
import com.elitesland.yst.production.aftersale.model.entity.TemTransmissionLogDO;
import com.elitesland.yst.production.aftersale.model.param.TemTransmissionLogPageParam;
import com.elitesland.yst.production.aftersale.model.param.TemTransmissionLogParam;
import com.elitesland.yst.production.aftersale.model.vo.TemTransmissionLogVO;
import com.elitesland.yst.production.aftersale.service.TemTransmissionLogService;
import com.elitesland.yst.production.aftersale.service.repo.TemTransmissionLogRepo;
import com.elitesland.yst.production.aftersale.service.repo.TemTransmissionLogRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-5-24
 * @desc : 传输日志记录表Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class TemTransmissionLogServiceImpl implements TemTransmissionLogService {


    private final TemTransmissionLogRepoProc temTransmissionLogRepoProc;

    private final TemTransmissionLogRepo temTransmissionLogRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public TemTransmissionLogDO save(TemTransmissionLogParam temTransmissionLogParam) {

        checkData(temTransmissionLogParam);
        TemTransmissionLogDO temTransmissionLogDO = new TemTransmissionLogDO();
        temTransmissionLogDO = ExecutRecordConvert.INSTANCE.p2d(temTransmissionLogParam);

        TemTransmissionLogDO res = temTransmissionLogRepo.save(temTransmissionLogDO);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public TemTransmissionLogDO update(TemTransmissionLogParam temTransmissionLogParam) {

        Assert.notNull(temTransmissionLogParam.getId(), "id is null");
        TemTransmissionLogDO res = save(temTransmissionLogParam);
        return res;

    }


    @Override
    public TemTransmissionLogVO get(Long id) {

        TemTransmissionLogVO res = temTransmissionLogRepoProc.get(id);
        return res;

    }


    @Override
    public PagingVO<TemTransmissionLogVO> page(TemTransmissionLogPageParam temTransmissionLogPageParam) {

        PagingVO<TemTransmissionLogVO> res = temTransmissionLogRepoProc.page(temTransmissionLogPageParam);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        Long res = temTransmissionLogRepoProc.del(ids);
        return res;

    }


    /**
     * 数据校验
     *
     * @param temTransmissionLogParam
     */
    private void checkData(TemTransmissionLogParam temTransmissionLogParam) {

    }


}

