package com.elitesland.yst.production.aftersale.service.repo;

import com.elitesland.yst.production.aftersale.model.entity.CarMaintainCardDO;
import com.elitesland.yst.production.aftersale.model.entity.CarOwnerVehicleInfoDO;
import com.elitesland.yst.production.aftersale.model.vo.CarOwnerVehicleInfoVO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleRepo
 * @Date2023/2/8 15:30
 */
@Repository
public interface CarOwnerVehicleRepo extends JpaRepository<CarOwnerVehicleInfoDO, Long>, QuerydslPredicateExecutor<CarOwnerVehicleInfoDO> {

    CarOwnerVehicleInfoDO findByVehicleNo(String vehicleNo);

    @Query(value = "select * from  car_owner_vehicle_info  where activat_time >= ?1 and  activat_time <= ?2 and vehicle_source = ?3 and activat_flag = ?4", nativeQuery = true)
    List<CarOwnerVehicleInfoDO> findByBindingTimeBetween(LocalDateTime startTime, LocalDateTime endTime, int vehicleSource, int activatFlag);

    @Query(value = "select * from  car_owner_vehicle_info  where binding_time >= ?1 and  binding_time <= ?2 and vehicle_source = ?3  and activat_flag = ?4 and if(?5 is not null and ?5 <> '',vehicle_no =?5,1=1)", nativeQuery = true)
    List<CarOwnerVehicleInfoDO> findByBindingTimeOrVehicleNo(LocalDateTime startTime, LocalDateTime endTime, int vehicleSource, int activatFlag, String vehicalNo);

    @Transactional
    @Modifying
    @Query(value = "update car_owner_vehicle_info set  cust_code = ?1,cust_ame = ?2 ,cust_abbr = ?3 ,cust_code2 = ?4 ,salesman_name = ?5  where id = ?6", nativeQuery = true)
    void updateCustAndSalesManName(String custCode, String custName, String custAbbr, String custCode2, String salesmanName, Long id);

    @Query(value = "select * from  car_owner_vehicle_info  where modify_time >= ?1 and  modify_time <= ?2 and vehicle_source = ?3 and activat_flag = ?4 and delete_flag=?5", nativeQuery = true)
    List<CarOwnerVehicleInfoDO> findByModifTimeBetween(LocalDateTime startTime, LocalDateTime endTime, int i, int activatFlag, int deleteFlag);

    @Query(value = "select max(create_time) as create_time,sales_outlets_code,salesman_name from  car_owner_vehicle_info  where sales_outlets_code in ?1 GROUP BY sales_outlets_code order by create_time desc ", nativeQuery = true)
    List<CarOwnerVehicleInfoVO> findAllByStoreCode(List<String> storeCode);


    @Query(value = "select count(*) from car_owner_vehicle_info where user_phone = ?1 and delete_flag=0",nativeQuery = true)
    int findCountByUserPhone(String userPhone);

    @Query(value = "select count(*) from car_owner_vehicle_info where user_idcard = ?1 and delete_flag=0",nativeQuery = true)
    int findCountByUserIdCard(String userIdCard);

}

