package com.elitesland.yst.production.aftersale.service.repo;


import com.alibaba.excel.util.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.aftersale.model.entity.QRepairPartsServiceDO;
import com.elitesland.yst.production.aftersale.model.entity.RepairPartsServiceDO;
import com.elitesland.yst.production.aftersale.model.param.RepairPartsServiceExlParam;
import com.elitesland.yst.production.aftersale.model.vo.RepairPartsServiceVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQuery;
import io.jsonwebtoken.lang.Collections;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public class RepairPartsServiceRepoProc extends BaseRepoProc<RepairPartsServiceDO> {
    private static final QRepairPartsServiceDO QDO = QRepairPartsServiceDO.repairPartsServiceDO;

    protected RepairPartsServiceRepoProc() {
        super(QDO);
    }


    public List<RepairPartsServiceVO> query(RepairPartsServiceExlParam queryDTO) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(queryDTO.getId() != null, QDO.id, queryDTO.getId())
                .andEq(queryDTO.getRepairId() != null, QDO.repairId, queryDTO.getRepairId())
                .andIn(!Collections.isEmpty(queryDTO.getRepairIdList()), QDO.repairId, queryDTO.getRepairIdList())
                .build();

        return jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(QDO)
                .where(predicate)
                .fetch();
    }

    public PagingVO<RepairPartsServiceVO> pageQuery(RepairPartsServiceExlParam queryDTO) {
        Predicate predicate = PredicateBuilder.builder()
                .andEq(queryDTO.getId() != null, QDO.id, queryDTO.getId())
                .andEq(queryDTO.getRepairId() != null, QDO.repairId, queryDTO.getRepairId())
                .andEq(queryDTO.getServiceType() != null, QDO.serviceType, queryDTO.getServiceType())
                .andLike(!StringUtils.isEmpty(queryDTO.getPartsName()), QDO.partsName, queryDTO.getPartsName())
                .andIn(!Collections.isEmpty(queryDTO.getRepairIdList()), QDO.repairId, queryDTO.getRepairIdList())
                .build();


        JPAQuery<RepairPartsServiceVO> jpaQuery = jpaQueryFactory.select(fieldsOfYstDemoDTO())
                .from(QDO)
                .where(predicate);

        queryDTO.fillOrders(jpaQuery, QDO);
        queryDTO.setPaging(jpaQuery);
        jpaQuery.where(QDO.deleteFlag.eq(0).or(QDO.deleteFlag.isNull()));

        return PagingVO.<RepairPartsServiceVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }


    private QBean<RepairPartsServiceVO> fieldsOfYstDemoDTO() {
        return Projections.bean(RepairPartsServiceVO.class,
                QDO.id,
                QDO.updater,
                QDO.secUserId,
                QDO.secBuId,
                QDO.secOuId,
                QDO.deleteFlag,
                QDO.creator,
                QDO.createTime,
                QDO.createUserId,
                QDO.repairId,
                QDO.partsId,
                QDO.partsName,
                QDO.partsType,
                QDO.partsPrice,
                QDO.servicePrice,
                QDO.serviceType,
                QDO.remark,
                QDO.partsNum,
                QDO.isThreePackage,
                QDO.breakdownMaintenanceId,
                QDO.breakdownMaintenanceName

        );
    }
}
