package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
public class RepairPartsServiceParam extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8282920176472466272L;

    @ApiModelProperty("配件id")
    Long partsId;

    @ApiModelProperty("所属维修工单id")
    Long repairId;

    @ApiModelProperty("配件名称")
    String partsName;

    @ApiModelProperty("配件分类")
    String partsType;

    @ApiModelProperty("配件售价")
    BigDecimal partsPrice;

    @ApiModelProperty("服务价格")
    BigDecimal servicePrice;

    @ApiModelProperty("服务类型")
    String serviceType;

    @ApiModelProperty("所属维修工单id")
    List<Long> repairIdList;

    @ApiModelProperty("配件数量")
    Integer partsNum;

    @ApiModelProperty("三包类型")
    String isThreePackage;

    @ApiModelProperty("故障类型id")
    private Long breakdownMaintenanceId;

    @ApiModelProperty("故障类型名称")
    private String breakdownMaintenanceName;

    @ApiModelProperty("上传图片集合")
    List<PictureOrderParam> pictureOrderParamList;



    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            return o instanceof RepairPartsServiceParam;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
