/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.controller.front;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.model.param.CarMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardPageParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerMaintainCardParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.param.CarOwnverCardUpdParam;
import com.elitesland.yst.production.aftersale.model.vo.CarMaintainCardVO;
import com.elitesland.yst.production.aftersale.service.MaintainCardService;
import com.elitesland.yst.production.aftersale.service.RepairOrderService;
import com.elitesland.yst.production.support.provider.store.dto.OrgStoreRpcDTO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/threePackage"}, produces={"application/json"})
@Validated
@Api(value="\u4e09\u5305", tags={"\u4e09\u5305"})
public class MaintainCardController {
    @Autowired
    private MaintainCardService maintainCardService;
    @Autowired
    private RepairOrderService repairOrderService;

    @PostMapping(value={"/activateThreePackage"})
    @ApiOperation(value="\u4e09\u5305\u6fc0\u6d3b")
    public ApiResult<Object> activateThreePackage(@RequestBody @Valid CarMaintainCardParam carMaintainCardParam) {
        throw new BusinessException("\u8be5\u63a5\u53e3\u5df2\u8fdb\u884c\u5347\u7ea7,\u8bf7\u5237\u65b0web\u9875\u9762");
    }

    @PostMapping(value={"/threePackageQuery"})
    @ApiOperation(value="\u4e09\u5305\u67e5\u8be2")
    public ApiResult<Object> threePackageQuery(@RequestBody CarOwnerMaintainCardParam car) {
        ApiResult<Object> query = this.maintainCardService.query(car.getCarOwnerId(), car.getPage(), car.getPageSize());
        return query;
    }

    @PostMapping(value={"/threePackageQueryById"})
    @ApiOperation(value="\u901a\u8fc7\u8f66\u67b6\u53f7\u67e5\u8be2\u4e09\u5305\u4fe1\u606f")
    public ApiResult<CarMaintainCardVO> threePackageQueryById(@RequestBody CarMaintainCardParam car) {
        ApiResult<CarMaintainCardVO> query = this.maintainCardService.queryById(car.getVehicleNo());
        return query;
    }

    @PostMapping(value={"/activateThreePackage2"})
    @ApiOperation(value="\u4e09\u5305\u6fc0\u6d3b-\u7ed1\u5b9a\u8f66\u8f86")
    public ApiResult<Object> activateThreePackage2(@RequestBody @Valid CarOwnerVehicleParam carOwnerVehicleParam) {
        if (null == carOwnerVehicleParam.getCarOwnerId()) {
            throw new BusinessException("carOwnerId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        carOwnerVehicleParam.setActivatFlag(true);
        carOwnerVehicleParam.setActivatTime(LocalDateTime.now());
        Boolean res = null;
        try {
            res = this.maintainCardService.activateThreePackage2(carOwnerVehicleParam, "WEB");
        }
        catch (Exception e) {
            return ApiResult.fail((String)e.getMessage());
        }
        return ApiResult.ok((Object)res);
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u8be6\u60c5-\u8f66\u8f86\u4e09\u5305\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    public ApiResult<CarMaintainCardVO> get(@PathVariable Long id) {
        CarMaintainCardVO res = this.maintainCardService.get(id);
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664-\u6839\u636e\u8f66\u67b6\u53f7\u5220\u9664\u8be5\u8f66\u8f86\u4e0b\u4e09\u5305\u4fe1\u606f\u548c\u6240\u6709\u7ed1\u5b9a\u5173\u7cfb")
    public ApiResult<Boolean> del(@RequestBody List<String> vehicleNos) {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairOrderService.repairStoreQuery();
        ArrayList<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<Long>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        Boolean res = this.maintainCardService.delAllByVehicleNoApp(vehicleNos, collect);
        return ApiResult.ok((Object)res);
    }

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u4e09\u5305\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<CarMaintainCardVO>> page(@RequestBody CarOwnerMaintainCardPageParam car) {
        List<OrgStoreRpcDTO> orgStoreRpcDTOS = this.repairOrderService.repairStoreQuery();
        ArrayList<Long> collect = CollectionUtils.isEmpty(orgStoreRpcDTOS) ? new ArrayList<Long>() : orgStoreRpcDTOS.stream().filter(t -> Objects.nonNull(t.getId())).map(OrgStoreRpcDTO::getId).collect(Collectors.toList());
        PagingVO<CarMaintainCardVO> res = this.maintainCardService.pageApp(car, collect);
        return ApiResult.ok(res);
    }

    @PostMapping(value={"/updIdCard"})
    @ApiOperation(value="\u4e09\u5305\u8eab\u4efd\u8bc1\u4fe1\u606f\u4fee\u6539")
    public ApiResult updIdCard(@RequestBody @Valid CarOwnverCardUpdParam updParam) {
        this.maintainCardService.updIdCard(updParam);
        return ApiResult.ok();
    }
}

