/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.aftersale.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.aftersale.convert.PhoneRecClsConvert;
import com.elitesland.yst.production.aftersale.model.entity.phonerecord.PhoneRecClsDO;
import com.elitesland.yst.production.aftersale.model.vo.PhoneRecClsRespVO;
import com.elitesland.yst.production.aftersale.model.vo.query.PhoneRecClsQueryVO;
import com.elitesland.yst.production.aftersale.model.vo.save.PhoneRecClsSaveVO;
import com.elitesland.yst.production.aftersale.service.PhoneRecClsService;
import com.elitesland.yst.production.aftersale.service.repo.PhoneRecClsRepo;
import com.elitesland.yst.production.aftersale.service.repo.PhoneRecClsRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhoneRecClsServiceImpl
implements PhoneRecClsService {
    private static final Logger log = LoggerFactory.getLogger(PhoneRecClsServiceImpl.class);
    @Autowired
    private PhoneRecClsRepo phoneRecClsRepo;
    @Autowired
    private PhoneRecClsRepoProc phoneRecClsRepoProc;
    @Autowired
    private SeqNumProvider seqNumProvider;

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"PHONE_REC_CLS"}, allEntries=true)})
    @Transactional(rollbackFor={Exception.class})
    public Long create(PhoneRecClsSaveVO saveVO) {
        log.info("\u65b0\u5efa\u5206\u7c7b\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)saveVO));
        if (saveVO.getPid().equals(saveVO.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u5141\u8bb8\u5c06\u81ea\u5df1\u9009\u62e9\u4e3a\u4e0a\u7ea7");
        }
        if (this.phoneRecClsRepo.existsByNameAndPid(saveVO.getName(), saveVO.getPid())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        PhoneRecClsDO phoneRecClsDO = PhoneRecClsConvert.INSTANCE.saveVOToDO(saveVO);
        phoneRecClsDO.setCode(this.seqNumProvider.generateCode("yst-after-sale", "phoneRecClsCode", new ArrayList()));
        PhoneRecClsDO result = (PhoneRecClsDO)((Object)this.phoneRecClsRepo.save((Object)phoneRecClsDO));
        return result.getId();
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"PHONE_REC_CLS"}, allEntries=true)})
    public Long update(PhoneRecClsSaveVO saveVO) {
        log.info("\u7f16\u8f91\u5206\u7c7b\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)saveVO));
        Optional optional = this.phoneRecClsRepo.findById(saveVO.getId());
        if (optional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u5206\u7c7b\uff1a" + saveVO.getName());
        }
        if (saveVO.getId().equals(saveVO.getPid())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u4e0d\u5141\u8bb8\u5c06\u81ea\u5df1\u9009\u62e9\u4e3a\u4e0a\u7ea7");
        }
        if (this.phoneRecClsRepo.existsByNameAndPidAndIdNot(saveVO.getName(), saveVO.getPid(), saveVO.getId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        PhoneRecClsDO itmItemCateDO = (PhoneRecClsDO)((Object)optional.get());
        PhoneRecClsConvert.INSTANCE.updatePhoneRecClsDO(saveVO, itmItemCateDO);
        PhoneRecClsDO result = (PhoneRecClsDO)((Object)this.phoneRecClsRepo.save((Object)itmItemCateDO));
        return result.getId();
    }

    @Override
    @Caching(evict={@CacheEvict(cacheNames={"PHONE_REC_CLS"}, allEntries=true)})
    @Transactional(rollbackFor={Exception.class})
    public Long delete(List<Long> ids) {
        log.info("\u5220\u9664\u5206\u7c7b\u5165\u53c2 {}", (Object)JSON.toJSONString(ids));
        List allById = this.phoneRecClsRepo.findAllById(ids);
        if (CollUtil.isEmpty((Collection)allById)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        if (this.phoneRecClsRepo.existsByPidIn(ids).booleanValue()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u9009\u4e2d\u7684\u5206\u7c7b\u5b58\u5728\u4e0b\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        List<Long> deleteIds = allById.stream().map(BaseModel::getId).collect(Collectors.toList());
        return this.phoneRecClsRepoProc.updateDeleteFlag(deleteIds);
    }

    @Override
    public List<PhoneRecClsRespVO> query() {
        List phoneRecClsDOS = this.phoneRecClsRepo.findAll();
        if (CollUtil.isEmpty((Collection)phoneRecClsDOS)) {
            return Collections.emptyList();
        }
        List<PhoneRecClsRespVO> comClgClassRespVOS = PhoneRecClsConvert.INSTANCE.phoneRecClsDOToRespVOs(phoneRecClsDOS);
        List<PhoneRecClsRespVO> base = comClgClassRespVOS.stream().filter(s -> s.getPid() == 0L).sorted(Comparator.comparing(PhoneRecClsRespVO::getSortNo).reversed()).collect(Collectors.toList());
        Map<Long, List<PhoneRecClsRespVO>> under = comClgClassRespVOS.stream().filter(s -> s.getPid() != 0L).collect(Collectors.groupingBy(PhoneRecClsRespVO::getPid));
        if (CollUtil.isEmpty(under)) {
            return base;
        }
        base.forEach(s -> {
            if (CollUtil.isNotEmpty((Collection)((Collection)under.get(s.getId())))) {
                s.setUnder(((List)under.get(s.getId())).stream().sorted(Comparator.comparing(PhoneRecClsRespVO::getSortNo).reversed()).collect(Collectors.toList()));
                s.setHasUnder(true);
            } else {
                s.setHasUnder(false);
            }
        });
        return base;
    }

    @Override
    public PhoneRecClsRespVO queryDetail(Long id) {
        log.info("\u5206\u7c7b\u660e\u7ec6\u67e5\u8be2\u5165\u53c2 {}", (Object)id);
        Optional phoneRecClsDOOptional = this.phoneRecClsRepo.findById(id);
        if (phoneRecClsDOOptional.isEmpty()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        PhoneRecClsDO phoneRecClsDO = (PhoneRecClsDO)((Object)phoneRecClsDOOptional.get());
        List<PhoneRecClsDO> byPid = this.phoneRecClsRepo.findByPid(phoneRecClsDO.getId());
        PhoneRecClsRespVO comClgClassRespVO = PhoneRecClsConvert.INSTANCE.phoneRecClsDOToRespVO(phoneRecClsDO);
        comClgClassRespVO.setHasUnder(CollUtil.isNotEmpty(byPid));
        return comClgClassRespVO;
    }

    @Override
    public PagingVO<PhoneRecClsRespVO> queryByParam(PhoneRecClsQueryVO param) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570 {}", (Object)JSON.toJSONString((Object)((Object)param)));
        List<PhoneRecClsRespVO> query = this.query();
        if (CollUtil.isEmpty(query)) {
            return PagingVO.builder();
        }
        if (StringUtils.isNotBlank((CharSequence)param.getName())) {
            return PhoneRecClsServiceImpl.searchByName(param, query);
        }
        query = query.stream().distinct().filter(s -> s.getPid() == 0L).sorted(Comparator.comparing(PhoneRecClsRespVO::getSortNo).reversed()).collect(Collectors.toList());
        List page = ListUtil.page((int)param.getCurrent(), (int)param.getSize(), query);
        return PagingVO.builder().total((long)query.size()).records(page).build();
    }

    private static PagingVO<PhoneRecClsRespVO> searchByName(PhoneRecClsQueryVO param, List<PhoneRecClsRespVO> query) {
        List<Object> respVOS = new ArrayList<PhoneRecClsRespVO>();
        for (PhoneRecClsRespVO comClgClassRespVO : query) {
            if (comClgClassRespVO.getName().contains(param.getName())) {
                respVOS.add(comClgClassRespVO);
            }
            if (!CollUtil.isNotEmpty(comClgClassRespVO.getUnder())) continue;
            for (PhoneRecClsRespVO clgClassRespVO : comClgClassRespVO.getUnder()) {
                if (!clgClassRespVO.getName().contains(param.getName())) continue;
                respVOS.add(clgClassRespVO);
                respVOS.add(comClgClassRespVO);
            }
        }
        respVOS = respVOS.stream().distinct().filter(s -> s.getPid() == 0L).sorted(Comparator.comparing(PhoneRecClsRespVO::getSortNo).reversed()).collect(Collectors.toList());
        List page = ListUtil.page((int)param.getCurrent(), (int)param.getSize(), respVOS);
        return PagingVO.builder().total((long)respVOS.size()).records(page).build();
    }

    @Override
    public List<PhoneRecClsRespVO> querySub(Long id) {
        if (id == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<PhoneRecClsDO> classRepoByPid = this.phoneRecClsRepo.findByPid(id);
        if (CollUtil.isEmpty(classRepoByPid)) {
            return Collections.emptyList();
        }
        return PhoneRecClsConvert.INSTANCE.phoneRecClsDOToRespVOs(classRepoByPid);
    }

    @Override
    public List<PhoneRecClsRespVO> queryBase() {
        List<PhoneRecClsDO> byPid = this.phoneRecClsRepo.findByPid(0L);
        if (CollUtil.isEmpty(byPid)) {
            return Collections.emptyList();
        }
        return PhoneRecClsConvert.INSTANCE.phoneRecClsDOToRespVOs(byPid);
    }
}

