package com.elitesland.yst.production.aftersale.controller.miniapp;

import com.aliyun.ocr_api20210707.models.RecognizeIdcardResponse;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.aftersale.model.param.CarOwnerVehicleParam;
import com.elitesland.yst.production.aftersale.model.vo.AddressInfoVo;
import com.elitesland.yst.production.aftersale.service.CarOwnerVehicleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author Danny.Wang
 * @title CarOwnerVehicleController
 * @Date2023/2/8 14:32
 */
@RestController
@RequestMapping(value = "/miniApp/bindVehicle", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
@Api(value = "车主关联车辆信息", tags = {"车主关联车辆信息"})
public class CarOwnerVehicleController {

    @Autowired
    private CarOwnerVehicleService carOwnerVehicleService;

    @PostMapping(value = "/bindVehicleSave")
    @ApiOperation(value = "车主关联车辆信息保存")
    public ApiResult<Object> bindVehicleSave(@RequestBody @Validated CarOwnerVehicleParam carOwnerVehicleParam) {
//        return carOwnerVehicleService.bindVehicleSave(carOwnerVehicleParam);
        throw new BusinessException("该接口已进行升级,请刷新小程序页面");
    }



    @PostMapping(value = "/bindSoldVehicleSave2")
    @ApiOperation(value = "售出车辆绑定信息保存(不进行激活)")
    public ApiResult<Long> bindSoldVehicleSave2(@RequestBody @Validated CarOwnerVehicleParam carOwnerVehicleParam) {
        carOwnerVehicleParam.setActivatFlag(false);
        ApiResult<Long> res = carOwnerVehicleService.bindSoldVehicleSave(carOwnerVehicleParam,"MNAPP");
        return res;
    }


    @GetMapping(value = "/deleteBindVehicle/{id}")
    @ApiOperation(value = "车主关联车辆解绑")
    public ApiResult<Object> deleteBindVehicle(@PathVariable("id") Long id) {
        return carOwnerVehicleService.deleteBindVehicle(id);
    }

    @GetMapping(value = "/bindVehicleQuery")
    @ApiOperation(value = "车主关联车辆查询")
    public ApiResult<Object> bindVehicleQuery() {
        return carOwnerVehicleService.bindVehicleQuery();
    }

    @GetMapping(value = "/queryByUserCardId/{userIdCard}")
    @ApiOperation(value = "通过身份证号查询地址等信息")
    public ApiResult<Object> queryByUserCardId(@PathVariable("userIdCard") String userIdCard) {
        AddressInfoVo addressInfoVo = carOwnerVehicleService.queryByUserCardId(userIdCard);
        return ApiResult.ok(addressInfoVo);
    }

    @PostMapping(value = "/ocrScan")
    @ApiOperation(value = "身份证ocr识别")
    public ApiResult<Object> ocrScan(@RequestParam("file") MultipartFile file) {
        RecognizeIdcardResponse response = carOwnerVehicleService.ocrScan(file);
        return ApiResult.ok(response);
    }


    @PostMapping(value = "/delThreePackage")
    @ApiOperation(value = "解绑车辆并删除三包信息")
    public ApiResult<Object> delThreePackage(@RequestBody Long id) {
        ApiResult<Object> res = carOwnerVehicleService.deleteBindVehicleAndThreePack(id);
        return res;
    }

    @PostMapping("/getUserFlmVehicleBindQty")
    @ApiOperation("获取用户绑定的非立马车辆的数量")
    public ApiResult<Integer> getUserFlmVehicleBindQty() {
        return ApiResult.ok(carOwnerVehicleService.getUserFlmVehicleBindQty());
    }


}
