package com.elitesland.yst.production.aftersale.model.param;

import com.elitescloud.cloudt.authorization.sdk.cas.common.IdType;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 注册会员
 *
 * @author elvis.hong
 * @date 2022/03/08 17:55
 */
@Data
public class RegisterMemberParam extends BaseModel implements Serializable {

    /**
     * 用户账号
     */
    @ApiModelProperty(value = "用户账号")
    private String userName;

    /**
     * 用户密码
     * <p>
     * 编辑用户时，传入新值则修改密码，否则密码不变
     */
    @ApiModelProperty(value = "用户密码")
    private String password;

    /**
     * 用户姓氏
     */
    @ApiModelProperty(value = "用户姓氏")
    private String lastName;

    /**
     * 用户名字
     */
    @ApiModelProperty(value = "用户名字")
    private String firstName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    @ApiModelProperty(value = "性别")
    private String gender;

    /**
     * 密码过期时间
     */
    @ApiModelProperty(value = "密码过期时间")
    private LocalDateTime passwordExpiredTime;

    /**
     * 账号过期时间
     */
    @ApiModelProperty(value = "账号过期时间")
    private LocalDateTime expiredTime;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称")
    private String nickname;

    /**
     * 是否启用，默认是
     */
    @ApiModelProperty(value = "是否启用，默认是")
    private Boolean enabled;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 证件类型
     */
    @ApiModelProperty(value = "证件类型")
    private IdType idTypes;

    /**
     * 证件号码
     */
    @ApiModelProperty(value = "证件号码")
    private String idNum;

    /**
     * 统一认证中心的用户ID
     */
    @ApiModelProperty("统一认证中心的用户ID")
    private Long casUserId;

    /**
     * 车主id
     */
    @ApiModelProperty(value = "车主id")
    private Long carOwnerId;

    @ApiModelProperty("验证码")
    private String kaptcha;
}
